--[[--
	by ALA
--]]--
----------------------------------------------------------------------------------------------------
local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if CT.TOCVERSION >= 40000 or CT.TOCVERSION < 30400 then
	return;
end
-- if WOW_PROJECT_ID ~= WOW_PROJECT_WRATH_CLASSIC then
-- 	return;
-- end

----------------------------------------------------------------------------------------------------

DT.MAX_LEVEL = 80;
DT.MAX_NUM_TIER = 11;
DT.MAX_NUM_COL = 4;
DT.MAX_NUM_TALENTS = 44;
DT.CUR_PHASE = 3;
--
DT.ClassSpec = {
	DEATHKNIGHT = {
		398,	--Blood,鲜血
		399,	--Frost,冰霜
		400,	--Unholy,邪恶
	},
	DRUID = {
		283,	--Balance,平衡
		281,	--Feral,野性战斗
		282,	--Restoration,恢复
	},
	HUNTER = {
		361,	--BeastMastery,野兽控制
		363,	--Marksmanship,射击
		362,	--Survival,生存
	},
	MAGE = {
		81,		--Arcane,奥术
		41,		--Fire,火焰
		61,		--Frost,冰霜
	},
	PALADIN = {
		382,	--Holy,神圣
		383,	--Protection,防护
		381,	--Discipline,惩戒
	},
	PRIEST = {
		201,	--Discipline,戒律
		202,	--Holy,神圣
		203,	--Shadow,暗影
	},
	ROGUE = {
		182,	--Assassination,刺杀
		181,	--Combat,战斗
		183,	--Subtlety,敏锐
	},
	SHAMAN = {
		261,	--Elemental,元素
		263,	--Enhancement,增强
		262,	--Restoration,恢复
	},
	WARLOCK = {
		302,	--Affliction,痛苦
		303,	--Demonology,恶魔学识
		301,	--Destruction,毁灭
	},
	WARRIOR = {
		161,	--Arms,武器
		164,	--Fury,狂怒
		163,	--Protection,防护
	},
};
--
	--	DT.TalentDB
	--1-----2----3---4---------5--------6-------7------8---------9--------10-----------11--------------------12
	--tier, col, id, maxPoint, reqTier, reqCol, reqId, Spell[5], texture, [icon index, req index in TreeTDB, req by index in TreeTDB](calculated after addon loaded)
--
DT.TalentDB = {
	DEATHKNIGHT = {
		[398] = {
			{  0, 0, 1939, 2, nil, nil,  nil, { 48979, 49483,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1945, 3, nil, nil,  nil, { 48997, 49490, 49491,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 2017, 5, nil, nil,  nil, { 49182, 49500, 49501, 55225, 55226, }, 'TEXTURE', },
			{  1, 0, 1938, 5, nil, nil,  nil, { 48978, 49390, 49391, 49392, 49393, }, 'TEXTURE', },
			{  1, 1, 1948, 3, nil, nil,  nil, { 49004, 49508, 49509,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 2217, 2, nil, nil,  nil, { 55107, 55108,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1941, 1, nil, nil,  nil, { 48982,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1943, 5, nil, nil,  nil, { 48987, 49477, 49478, 49479, 49480, }, 'TEXTURE', },
			{  2, 2, 2086, 3, nil, nil,  nil, { 49467, 50033, 50034,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1942, 3,   2,   0, 1941, { 48985, 49488, 49489,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2018, 3, nil, nil,  nil, { 49145, 49495, 49497,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1953, 3, nil, nil,  nil, { 49015, 50154, 55136,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2015, 3, nil, nil,  nil, { 48977, 49394, 49395,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1950, 3, nil, nil,  nil, { 49006, 49526, 50029,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1949, 1, nil, nil,  nil, { 49005,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 1944, 3,   2,   1, 1943, { 48988, 49503, 49504,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 2105, 2, nil, nil,  nil, { 53137, 53138,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1960, 3, nil, nil,  nil, { 49027, 49542, 49543,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1954, 1, nil, nil,  nil, { 49016,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1936, 2, nil, nil,  nil, { 50365, 50371,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2259, 2, nil, nil,  nil, { 62905, 62908,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1955, 3, nil, nil,  nil, { 49018, 49529, 49530,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 2019, 1, nil, nil,  nil, { 55233,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1959, 3, nil, nil,  nil, { 49189, 50149, 50150,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1957, 1, nil, nil,  nil, { 55050,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1958, 3, nil, nil,  nil, { 49023, 49533, 49534,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2034, 5, nil, nil,  nil, { 61154, 61155, 61156, 61157, 61158, }, 'TEXTURE', },
			{ 10, 1, 1961, 1, nil, nil,  nil, { 49028,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[399] = {
			{  0, 0, 2031, 3, nil, nil,  nil, { 49175, 50031, 51456,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2020, 2, nil, nil,  nil, { 49455, 50147,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 1968, 5, nil, nil,  nil, { 49042, 49786, 49787, 49788, 49789, }, 'TEXTURE', },
			{  1, 1, 2035, 2, nil, nil,  nil, { 55061, 55062,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1973, 5, nil, nil,  nil, { 49140, 49661, 49662, 49663, 49664, }, 'TEXTURE', },
			{  1, 3, 2022, 3, nil, nil,  nil, { 49226, 50137, 50138,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2042, 5,   0,   0, 2031, { 50880, 50884, 50885, 50886, 50887, }, 'TEXTURE', },
			{  2, 1, 2215, 1, nil, nil,  nil, { 49039,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 2048, 3, nil, nil,  nil, { 51468, 51472, 51473,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 2044, 5, nil, nil,  nil, { 51123, 51127, 51128, 51129, 51130, }, 'TEXTURE', },
			{  3, 2, 1981, 2, nil, nil,  nil, { 49149, 50115,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1971, 2, nil, nil,  nil, { 49137, 49657,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1990, 3, nil, nil,  nil, { 49186, 51108, 51109,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2030, 3, nil, nil,  nil, { 49471, 49790, 49791,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1980, 1, nil, nil,  nil, { 49796,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 2223, 1,   2,   0, 2042, { 55610,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 1993, 2, nil, nil,  nil, { 49024, 49538,   nil,   nil,   nil, }, 'TEXTURE', },
			-- {  5, 1, 1993, 2, 'ReqTier', 'ReqCol', 1994, { 49024, 49538,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1992, 3, nil, nil,  nil, { 49188, 56822, 59057,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2260, 3, nil, nil,  nil, { 50040, 50041, 50043,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1999, 1, nil, nil,  nil, { 49203,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 2029, 2, nil, nil,  nil, { 50384, 50385,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2284, 3, nil, nil,  nil, { 65661, 66191, 66192,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 2210, 3, nil, nil,  nil, { 54639, 54638, 54637,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1979, 1, nil, nil,  nil, { 51271,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1997, 3, nil, nil,  nil, { 49200, 50151, 50152,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1975, 1, nil, nil,  nil, { 49143,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2040, 3, nil, nil,  nil, { 50187, 50190, 50191,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1998, 5, nil, nil,  nil, { 49202, 50127, 50128, 50129, 50130, }, 'TEXTURE', },
			{ 10, 1, 1989, 1, nil, nil,  nil, { 49184,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[400] = {
			{  0, 0, 2082, 2, nil, nil,  nil, { 51745, 51746,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1932, 3, nil, nil,  nil, { 48962, 49567, 49568,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 2218, 5, nil, nil,  nil, { 55129, 55130, 55131, 55132, 55133, }, 'TEXTURE', },
			{  1, 0, 1963, 2, nil, nil,  nil, { 49036, 49562,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1933, 3, nil, nil,  nil, { 48963, 49564, 49565,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 2025, 2, nil, nil,  nil, { 49588, 49589,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 1934, 3, nil, nil,  nil, { 48965, 49571, 49572,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2008, 3, nil, nil,  nil, { 49013, 55236, 55237,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 2047, 5, nil, nil,  nil, { 51459, 51462, 51463, 51464, 51465, }, 'TEXTURE', },
			{  2, 2, 1985, 1, nil, nil,  nil, { 49158,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 2039, 2, nil, nil,  nil, { 49146, 51267,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2004, 3, nil, nil,  nil, { 49219, 49627, 49628,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2225, 2, nil, nil,  nil, { 55620, 55623,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1996, 1, nil, nil,  nil, { 49194,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 2005, 5, nil, nil,  nil, { 49220, 49633, 49635, 49636, 49638, }, 'TEXTURE', },
			{  4, 2, 2011, 2, nil, nil,  nil, { 49223, 49599,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 2226, 2, nil, nil,  nil, { 55666, 55667,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 2009, 3, nil, nil,  nil, { 49224, 49610, 49611,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 2001, 3, nil, nil,  nil, { 49208, 56834, 56835,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 1984, 1,   3,   3, 2225, { 52143,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2285, 5, nil, nil,  nil, { 66799, 66814, 66815, 66816, 66817, }, 'TEXTURE', },
			{  6, 1, 2221, 1,   5,   1, 2009, { 51052,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 2013, 2, nil, nil,  nil, { 50391, 50392,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 3, 2085, 1,   5,   3, 1984, { 63560,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1962, 3, nil, nil,  nil, { 49032, 49631, 49632,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 2007, 1, nil, nil,  nil, { 49222,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2003, 3, nil, nil,  nil, { 49217, 49654, 49655,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 2043, 3,   7,   1, 1962, { 51099, 51160, 51161,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2216, 1, nil, nil,  nil, { 55090,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2036, 5, nil, nil,  nil, { 50117, 50118, 50119, 50120, 50121, }, 'TEXTURE', },
			{ 10, 1, 2000, 1, nil, nil,  nil, { 49206,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	DRUID = {
		[283] = {
			{  0, 1,  762, 5, nil, nil,  nil, { 16814, 16815, 16816, 16817, 16818, }, 'TEXTURE', },
			{  0, 2, 2238, 5, nil, nil,  nil, { 57810, 57811, 57812, 57813, 57814, }, 'TEXTURE', },
			{  1, 0,  783, 3, nil, nil,  nil, { 16845, 16846, 16847,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1822, 2, nil, nil,  nil, { 35363, 35364,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  763, 2, nil, nil,  nil, { 16821, 16822,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  782, 3, nil, nil,  nil, { 16836, 16839, 16840,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  789, 3,   1,   1, 1822, { 16880, 61345, 61346,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 2240, 1,   1,   1, 1822, { 57865,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  764, 2, nil, nil,  nil, { 16819, 16820,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  792, 5, nil, nil,  nil, { 16909, 16910, 16911, 16912, 16913, }, 'TEXTURE', },
			{  3, 2,  784, 3, nil, nil,  nil, { 16850, 16923, 16924,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1782, 3, nil, nil,  nil, { 33589, 33590, 33591,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  788, 1, nil, nil,  nil, {  5570,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2239, 3,   4,   1,  788, { 57849, 57850, 57851,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1784, 3, nil, nil,  nil, { 33597, 33599, 33956,   nil,   nil, }, 'TEXTURE', },
			{  5, 1,  790, 3, nil, nil,  nil, { 16896, 16897, 16899,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1783, 2, nil, nil,  nil, { 33592, 33596,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  793, 1, nil, nil,  nil, { 24858,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1912, 3,   6,   1,  793, { 48384, 48395, 48396,   nil,   nil, }, 'TEXTURE', },
			{  6, 3, 1785, 3, nil, nil,  nil, { 33600, 33601, 33602,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1913, 3,   6,   1,  793, { 48389, 48392, 48393,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1786, 5, nil, nil,  nil, { 33603, 33604, 33605, 33606, 33607, }, 'TEXTURE', },
			{  8, 0, 1924, 3, nil, nil,  nil, { 48516, 48521, 48525,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1923, 1,   6,   1,  793, { 50516,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1787, 1, nil, nil,  nil, { 33831,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 3, 1925, 2, nil, nil,  nil, { 48488, 48514,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1928, 3, nil, nil,  nil, { 48506, 48510, 48511,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 1926, 1, nil, nil,  nil, { 48505,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[281] = {
			{  0, 1,  796, 5, nil, nil,  nil, { 16934, 16935, 16936, 16937, 16938, }, 'TEXTURE', },
			{  0, 2,  795, 5, nil, nil,  nil, { 16858, 16859, 16860, 16861, 16862, }, 'TEXTURE', },
			{  1, 0,  799, 3, nil, nil,  nil, { 16947, 16948, 16949,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  805, 2, nil, nil,  nil, { 16998, 16999,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  794, 3, nil, nil,  nil, { 16929, 16930, 16931,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  807, 2, nil, nil,  nil, { 17002, 24866,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1162, 1, nil, nil,  nil, { 61336,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  798, 3, nil, nil,  nil, { 16942, 16943, 16944,   nil,   nil, }, 'TEXTURE', },
			{  3, 0,  802, 2, nil, nil,  nil, { 16966, 16968,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  803, 3, nil, nil,  nil, { 16972, 16974, 16975,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  801, 2,   2,   2,  798, { 37116, 37117,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1914, 2,   2,   2,  798, { 48409, 48410,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  797, 2, nil, nil,  nil, { 16940, 16941,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  804, 1, nil, nil,  nil, { 49377,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1792, 2, nil, nil,  nil, { 33872, 33873,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 2242, 3, nil, nil,  nil, { 57878, 57880, 57881,   nil,   nil, }, 'TEXTURE', },
			{  5, 1,  808, 5,   3,   1,  803, { 17003, 17004, 17005, 17006, 24894, }, 'TEXTURE', },
			{  5, 2, 1794, 3, nil, nil,  nil, { 33853, 33855, 33856,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  809, 1, nil, nil,  nil, { 17007,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1798, 2,   6,   1,  809, { 34297, 34300,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 3, 1793, 3, nil, nil,  nil, { 33851, 33852, 33957,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2241, 3,   6,   1,  809, { 57873, 57876, 57877,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1795, 3, nil, nil,  nil, { 33859, 33866, 33867,   nil,   nil, }, 'TEXTURE', },
			{  7, 3, 1919, 3, nil, nil,  nil, { 48483, 48484, 48485,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1921, 3, nil, nil,  nil, { 48492, 48494, 48495,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1796, 1,   6,   1,  809, { 33917,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1920, 3,   8,   1, 1796, { 48532, 48489, 48491,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1918, 5, nil, nil,  nil, { 48432, 48433, 48434, 51268, 51269, }, 'TEXTURE', },
			{  9, 2, 2266, 1,   9,   1, 1918, { 63503,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 1927, 1, nil, nil,  nil, { 50334,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[282] = {
			{  0, 0,  821, 2, nil, nil,  nil, { 17050, 17051,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  823, 3, nil, nil,  nil, { 17063, 17065, 17066,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  822, 5, nil, nil,  nil, { 17056, 17058, 17059, 17060, 17061, }, 'TEXTURE', },
			{  1, 0,  824, 5, nil, nil,  nil, { 17069, 17070, 17071, 17072, 17073, }, 'TEXTURE', },
			{  1, 1,  841, 3, nil, nil,  nil, { 17118, 17119, 17120,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  826, 3, nil, nil,  nil, { 16833, 16834, 16835,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  829, 3, nil, nil,  nil, { 17106, 17107, 17108,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  827, 1, nil, nil,  nil, { 16864,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1915, 2,   1,   2,  826, { 48411, 48412,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  843, 5, nil, nil,  nil, { 24968, 24969, 24970, 24971, 24972, }, 'TEXTURE', },
			{  3, 2,  830, 3, nil, nil,  nil, { 17111, 17112, 17113,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  831, 1,   2,   0,  829, { 17116,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  828, 5, nil, nil,  nil, { 17104, 24943, 24944, 24945, 24946, }, 'TEXTURE', },
			{  4, 3,  842, 2, nil, nil,  nil, { 17123, 17124,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1788, 2, nil, nil,  nil, { 33879, 33880,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  825, 5,   3,   2,  830, { 17074, 17075, 17076, 17077, 17078, }, 'TEXTURE', },
			{  6, 0, 1797, 3, nil, nil,  nil, { 34151, 34152, 34153,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  844, 1,   4,   1,  828, { 18562,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1790, 3, nil, nil,  nil, { 33881, 33882, 33883,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1789, 5, nil, nil,  nil, { 33886, 33887, 33888, 33889, 33890, }, 'TEXTURE', },
			{  7, 2, 1922, 3, nil, nil,  nil, { 48496, 48499, 48500,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1929, 3, nil, nil,  nil, { 48539, 48544, 48545,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1791, 1,   7,   1, 1789, { 65139,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1930, 3,   8,   1, 1791, { 48535, 48536, 48537,   nil,   nil, }, 'TEXTURE', },
			{  9, 0, 2264, 2, nil, nil,  nil, { 63410, 63411,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 1916, 5, nil, nil,  nil, { 51179, 51180, 51181, 51182, 51183, }, 'TEXTURE', },
			{ 10, 1, 1917, 1,   8,   1, 1791, { 48438,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	HUNTER = {
		[361] = {
			{  0, 1, 1382, 5, nil, nil,  nil, { 19552, 19553, 19554, 19555, 19556, }, 'TEXTURE', },
			{  0, 2, 1389, 5, nil, nil,  nil, { 19583, 19584, 19585, 19586, 19587, }, 'TEXTURE', },
			{  1, 0, 1624, 2, nil, nil,  nil, { 35029, 35030,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1381, 3, nil, nil,  nil, { 19549, 19550, 19551,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1395, 3, nil, nil,  nil, { 19609, 19610, 19612,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 1625, 2, nil, nil,  nil, { 24443, 19575,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1384, 2, nil, nil,  nil, { 19559, 19560,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 2138, 1, nil, nil,  nil, { 53265,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1396, 5, nil, nil,  nil, { 19616, 19617, 19618, 19619, 19620, }, 'TEXTURE', },
			{  3, 1, 1385, 2, nil, nil,  nil, { 19572, 19573,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1393, 5, nil, nil,  nil, { 19598, 19599, 19600, 19601, 19602, }, 'TEXTURE', },
			{  4, 0, 1388, 2, nil, nil,  nil, { 19578, 20895,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1387, 1, nil, nil,  nil, { 19577,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1390, 2, nil, nil,  nil, { 19590, 19592,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1799, 2, nil, nil,  nil, { 34453, 34454,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1397, 5,   3,   2, 1393, { 19621, 19622, 19623, 19624, 19625, }, 'TEXTURE', },
			{  6, 0, 1800, 3, nil, nil,  nil, { 34455, 34459, 34460,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1386, 1,   4,   1, 1387, { 19574,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1801, 3, nil, nil,  nil, { 34462, 34464, 34465,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2136, 2,   6,   0, 1800, { 53252, 53253,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1802, 5, nil, nil,  nil, { 34466, 34467, 34468, 34469, 34470, }, 'TEXTURE', },
			{  8, 0, 2140, 3, nil, nil,  nil, { 53262, 53263, 53264,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1803, 1,   6,   1, 1386, { 34692,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2137, 3,   7,   2, 1802, { 53256, 53259, 53260,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2227, 5, nil, nil,  nil, { 56314, 56315, 56316, 56317, 56318, }, 'TEXTURE', },
			{ 10, 1, 2139, 1, nil, nil,  nil, { 53270,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[362] = {
			{  0, 0, 1623, 5, nil, nil,  nil, { 52783, 52785, 52786, 52787, 52788, }, 'TEXTURE', },
			{  0, 1, 1820, 3, nil, nil,  nil, { 19498, 19499, 19500,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 1621, 2, nil, nil,  nil, { 19159, 19160,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 1310, 3, nil, nil,  nil, { 19290, 19294, 24283,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1304, 3, nil, nil,  nil, { 19184, 19387, 19388,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1305, 3, nil, nil,  nil, { 19376, 63457, 63458,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 1810, 2, nil, nil,  nil, { 34494, 34496,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1622, 5, nil, nil,  nil, { 19255, 19256, 19257, 19258, 19259, }, 'TEXTURE', },
			{  2, 1, 1814, 1, nil, nil,  nil, { 19503,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1311, 3, nil, nil,  nil, { 19295, 19297, 19298,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 1309, 2, nil, nil,  nil, { 19286, 19287,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 2229, 3, nil, nil,  nil, { 56333, 56336, 56337,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1306, 3, nil, nil,  nil, { 56342, 56343, 56344,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2228, 3,   2,   0, 1622, { 56339, 56340, 56341,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1321, 3, nil, nil,  nil, { 19370, 19371, 19373,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1312, 1,   2,   2, 1311, { 19306,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1303, 5, nil, nil,  nil, { 19168, 19180, 19181, 24296, 24297, }, 'TEXTURE', },
			{  5, 2, 1809, 3, nil, nil,  nil, { 34491, 34492, 34493,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1812, 3,   5,   0, 1303, { 34500, 34502, 34503,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1325, 1,   4,   1, 1321, { 19386,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1811, 3, nil, nil,  nil, { 34497, 34498, 34499,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1813, 5, nil, nil,  nil, { 34506, 34507, 34508, 34838, 34839, }, 'TEXTURE', },
			{  7, 1, 2141, 3,   6,   1, 1325, { 53295, 53296, 53297,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2142, 2, nil, nil,  nil, { 53298, 53299,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1322, 1, nil, nil,  nil, {  3674,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 3, 2143, 3, nil, nil,  nil, { 53302, 53303, 53304,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 2144, 3,   6,   2, 1811, { 53290, 53291, 53292,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 2145, 1,   8,   1, 1322, { 53301,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[363] = {
			{  0, 0, 1341, 2, nil, nil,  nil, { 19407, 19412,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2197, 3, nil, nil,  nil, { 53620, 53621, 53622,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 1344, 5, nil, nil,  nil, { 19426, 19427, 19429, 19430, 19431, }, 'TEXTURE', },
			{  1, 0, 1806, 3, nil, nil,  nil, { 34482, 34483, 34484,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1343, 3, nil, nil,  nil, { 19421, 19422, 19423,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1349, 5, nil, nil,  nil, { 19485, 19487, 19488, 19489, 19490, }, 'TEXTURE', },
			{  2, 0, 1818, 2, nil, nil,  nil, { 34950, 34954,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1346, 3, nil, nil,  nil, { 19454, 19455, 19456,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1345, 1,   1,   2, 1349, { 19434,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 1819, 2, nil, nil,  nil, { 34948, 34949,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 1348, 3, nil, nil,  nil, { 19464, 19465, 19466,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1342, 5, nil, nil,  nil, { 19416, 19417, 19418, 19419, 19420, }, 'TEXTURE', },
			{  4, 0, 1351, 2, nil, nil,  nil, { 35100, 35102,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1353, 1, nil, nil,  nil, { 23989,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1347, 3, nil, nil,  nil, { 19461, 19462, 24691,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1804, 2, nil, nil,  nil, { 34475, 34476,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 1362, 3, nil, nil,  nil, { 19507, 19508, 19509,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2130, 3, nil, nil,  nil, { 53234, 53237, 53238,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1361, 1,   4,   1, 1353, { 19506,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1821, 3,   4,   2, 1347, { 35104, 35110, 35111,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1807, 5, nil, nil,  nil, { 34485, 34486, 34487, 34488, 34489, }, 'TEXTURE', },
			{  7, 2, 2131, 2, nil, nil,  nil, { 53228, 53232,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2132, 3, nil, nil,  nil, { 53215, 53216, 53217,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1808, 1,   7,   1, 1807, { 34490,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2133, 3, nil, nil,  nil, { 53221, 53222, 53224,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2134, 5, nil, nil,  nil, { 53241, 53243, 53244, 53245, 53246, }, 'TEXTURE', },
			{ 10, 1, 2135, 1, nil, nil,  nil, { 53209,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	MAGE = {
		[81] = {
			{  0, 0,   74, 2, nil, nil,  nil, { 11210, 12592,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,   76, 3, nil, nil,  nil, { 11222, 12839, 12840,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,   80, 5, nil, nil,  nil, { 11237, 12463, 12464, 16769, 16770, }, 'TEXTURE', },
			{  1, 0,   85, 3, nil, nil,  nil, { 28574, 54658, 54659,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1650, 2, nil, nil,  nil, { 29441, 29444,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,   75, 5, nil, nil,  nil, { 11213, 12574, 12575, 12576, 12577, }, 'TEXTURE', },
			{  2, 0,   82, 2, nil, nil,  nil, { 11247, 12606,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,   81, 3, nil, nil,  nil, { 11242, 12467, 12469,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1845, 3, nil, nil,  nil, { 44397, 44398, 44399,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 2211, 1, nil, nil,  nil, { 54646,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 0,   83, 2, nil, nil,  nil, { 11252, 12605,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,   88, 2, nil, nil,  nil, { 11255, 12598,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1142, 3, nil, nil,  nil, { 18462, 18463, 18464,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2222, 3, nil, nil,  nil, { 29447, 55339, 55340,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1724, 2, nil, nil,  nil, { 31569, 31570,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,   86, 1, nil, nil,  nil, { 12043,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3,   77, 5, nil, nil,  nil, { 11232, 12500, 12501, 12502, 12503, }, 'TEXTURE', },
			{  5, 0, 1726, 3, nil, nil,  nil, { 31574, 31575, 54354,   nil,   nil, }, 'TEXTURE', },
			{  5, 1,  421, 3,   4,   1,   86, { 15058, 15059, 15060,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1725, 2,   4,   1,   86, { 31571, 31572,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1727, 3, nil, nil,  nil, { 31579, 31582, 31583,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,   87, 1,   5,   1,  421, { 12042,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1844, 3, nil, nil,  nil, { 44394, 44395, 44396,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1843, 2,   6,   1,   87, { 44378, 44379,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1728, 5, nil, nil,  nil, { 31584, 31585, 31586, 31587, 31588, }, 'TEXTURE', },
			{  8, 1, 1729, 1, nil, nil,  nil, { 31589,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2209, 5, nil, nil,  nil, { 44404, 54486, 54488, 54489, 54490, }, 'TEXTURE', },
			{  9, 1, 1846, 3, nil, nil,  nil, { 44400, 44402, 44403,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 1826, 2, nil, nil,  nil, { 35578, 35581,   nil,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 1847, 1, nil, nil,  nil, { 44425,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[41] = {
			{  0, 0,   27, 2, nil, nil,  nil, { 11078, 11080,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1141, 3, nil, nil,  nil, { 18459, 18460, 54734,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,   26, 5, nil, nil,  nil, { 11069, 12338, 12339, 12340, 12341, }, 'TEXTURE', },
			{  1, 0,   34, 5, nil, nil,  nil, { 11119, 11120, 12846, 12847, 12848, }, 'TEXTURE', },
			{  1, 1, 2212, 2, nil, nil,  nil, { 54747, 54749,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,   31, 3, nil, nil,  nil, { 11108, 12349, 12350,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,   28, 2, nil, nil,  nil, { 11100, 12353,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,   30, 3, nil, nil,  nil, { 11103, 12357, 12358,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,   29, 1, nil, nil,  nil, { 11366,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,   23, 2, nil, nil,  nil, { 11083, 12351,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 0,   25, 3, nil, nil,  nil, { 11095, 12872, 12873,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,   24, 2, nil, nil,  nil, { 11094, 13043,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1639, 3, nil, nil,  nil, { 29074, 29075, 29076,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1730, 3, nil, nil,  nil, { 31638, 31639, 31640,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,   33, 3, nil, nil,  nil, { 11115, 11367, 11368,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,   32, 1,   2,   2,   29, { 11113,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1731, 2, nil, nil,  nil, { 31641, 31642,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,   35, 5, nil, nil,  nil, { 11124, 12378, 12398, 12399, 12400, }, 'TEXTURE', },
			{  6, 0, 1733, 3, nil, nil,  nil, { 34293, 34295, 34296,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,   36, 1,   4,   1,   33, { 11129,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1732, 2, nil, nil,  nil, { 31679, 31680,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1848, 2, nil, nil,  nil, { 64353, 64357,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1734, 3, nil, nil,  nil, { 31656, 31657, 31658,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1849, 2,   8,   1, 1735, { 44442, 44443,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1735, 1,   6,   1,   36, { 31661,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1850, 3, nil, nil,  nil, { 44445, 44446, 44448,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1851, 5, nil, nil,  nil, { 44449, 44469, 44470, 44471, 44472, }, 'TEXTURE', },
			{ 10, 1, 1852, 1, nil, nil,  nil, { 44457,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[61] = {
			{  0, 0,   38, 3, nil, nil,  nil, { 11071, 12496, 12497,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,   37, 5, nil, nil,  nil, { 11070, 12473, 16763, 16765, 16766, }, 'TEXTURE', },
			{  0, 2,   62, 3, nil, nil,  nil, { 31670, 31672, 55094,   nil,   nil, }, 'TEXTURE', },
			{  1, 0,   73, 3, nil, nil,  nil, { 11207, 12672, 15047,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,   70, 2, nil, nil,  nil, { 11189, 28332,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1649, 3, nil, nil,  nil, { 29438, 29439, 29440,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,   65, 3, nil, nil,  nil, { 11175, 12569, 12571,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,   61, 3, nil, nil,  nil, { 11151, 12952, 12953,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,   69, 1, nil, nil,  nil, { 12472,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,   63, 3, nil, nil,  nil, { 11185, 12487, 12488,   nil,   nil, }, 'TEXTURE', },
			{  3, 0,  741, 2, nil, nil,  nil, { 16757, 16758,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,   66, 3, nil, nil,  nil, { 11160, 12518, 12519,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,   67, 3, nil, nil,  nil, { 11170, 12982, 12983,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,   72, 1, nil, nil,  nil, { 11958,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,   64, 3, nil, nil,  nil, { 11190, 12489, 12490,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1736, 3, nil, nil,  nil, { 31667, 31668, 31669,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1737, 2,   4,   1,   72, { 55091, 55092,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,   68, 3, nil, nil,  nil, { 11180, 28592, 28593,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2214, 2,   6,   1,   71, { 44745, 54787,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,   71, 1,   4,   1,   72, { 11426,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1738, 5, nil, nil,  nil, { 31674, 31675, 31676, 31677, 31678, }, 'TEXTURE', },
			{  7, 1, 1740, 2, nil, nil,  nil, { 31682, 31683,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1853, 2, nil, nil,  nil, { 44543, 44545,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1854, 3, nil, nil,  nil, { 44546, 44548, 44549,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1741, 1, nil, nil,  nil, { 31687,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1855, 3,   8,   1, 1741, { 44557, 44560, 44561,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1856, 5, nil, nil,  nil, { 44566, 44567, 44568, 44570, 44571, }, 'TEXTURE', },
			{ 10, 1, 1857, 1, nil, nil,  nil, { 44572,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	PALADIN = {
		[382] = {
			{  0, 1, 1432, 5, nil, nil,  nil, { 20205, 20206, 20207, 20209, 20208, }, 'TEXTURE', },
			{  0, 2, 1463, 5, nil, nil,  nil, { 20224, 20225, 20330, 20331, 20332, }, 'TEXTURE', },
			{  1, 0, 1444, 3, nil, nil,  nil, { 20237, 20238, 20239,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1449, 5, nil, nil,  nil, { 20257, 20258, 20259, 20260, 20261, }, 'TEXTURE', },
			{  1, 2, 1628, 2, nil, nil,  nil, {  9453, 25836,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1435, 1, nil, nil,  nil, { 31821,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1461, 5, nil, nil,  nil, { 20210, 20212, 20213, 20214, 20215, }, 'TEXTURE', },
			{  2, 2, 1443, 2, nil, nil,  nil, { 20234, 20235,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1450, 3, nil, nil,  nil, { 20254, 20255, 20256,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1446, 2, nil, nil,  nil, { 20244, 20245,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2198, 2, nil, nil,  nil, { 53660, 53661,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1742, 2, nil, nil,  nil, { 31822, 31823,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1433, 1,   2,   1, 1461, { 20216,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1465, 3, nil, nil,  nil, { 20359, 20360, 20361,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1743, 2, nil, nil,  nil, { 31825, 31826,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1627, 5, nil, nil,  nil, {  5923,  5924,  5925,  5926, 25829, }, 'TEXTURE', },
			{  6, 0, 1745, 3, nil, nil,  nil, { 31833, 31835, 31836,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1502, 1,   4,   1, 1433, { 20473,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1744, 3, nil, nil,  nil, { 31828, 31829, 31830,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2190, 3, nil, nil,  nil, { 53551, 53552, 53553,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1746, 5, nil, nil,  nil, { 31837, 31838, 31839, 31840, 31841, }, 'TEXTURE', },
			{  8, 0, 1747, 1, nil, nil,  nil, { 31842,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2199, 5, nil, nil,  nil, { 53671, 53673, 54151, 54154, 54155, }, 'TEXTURE', },
			{  9, 1, 2193, 2,   6,   1, 1502, { 53569, 53576,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 2191, 2, nil, nil,  nil, { 53556, 53557,   nil,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 2192, 1, nil, nil,  nil, { 53563,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[383] = {
			{  0, 1, 1442, 5, nil, nil,  nil, { 63646, 63647, 63648, 63649, 63650, }, 'TEXTURE', },
			{  0, 2, 2185, 5, nil, nil,  nil, { 20262, 20263, 20264, 20265, 20266, }, 'TEXTURE', },
			{  1, 0, 1748, 3, nil, nil,  nil, { 31844, 31845, 53519,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1425, 2, nil, nil,  nil, { 20174, 20175,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1629, 5, nil, nil,  nil, { 20096, 20097, 20098, 20099, 20100, }, 'TEXTURE', },
			{  2, 0, 2280, 1, nil, nil,  nil, { 64205,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1501, 3, nil, nil,  nil, { 20468, 20469, 20470,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1423, 5, nil, nil,  nil, { 20143, 20144, 20145, 20146, 20147, }, 'TEXTURE', },
			{  3, 0, 2281, 2,   2,   0, 2280, { 53527, 53530,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 1521, 2, nil, nil,  nil, { 20487, 20488,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1422, 3, nil, nil,  nil, { 20138, 20139, 20140,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1431, 1, nil, nil,  nil, { 20911,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1426, 5, nil, nil,  nil, { 20177, 20179, 20181, 20180, 20182, }, 'TEXTURE', },
			{  5, 0, 1750, 2, nil, nil,  nil, { 31848, 31849,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1429, 3, nil, nil,  nil, { 20196, 20197, 20198,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2282, 2, nil, nil,  nil, { 31785, 33776,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1430, 1,   4,   1, 1431, { 20925,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1751, 3, nil, nil,  nil, { 31850, 31851, 31852,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1421, 3, nil, nil,  nil, { 20127, 20130, 20135,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1753, 3, nil, nil,  nil, { 31858, 31859, 31860,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2195, 3, nil, nil,  nil, { 53590, 53591, 53592,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1754, 1,   6,   1, 1430, { 31935,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2194, 2, nil, nil,  nil, { 53583, 53585,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2204, 3,   8,   1, 1754, { 53709, 53710, 53711,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 2200, 2, nil, nil,  nil, { 53695, 53696,   nil,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 2196, 1, nil, nil,  nil, { 53595,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[381] = {
			{  0, 1, 1403, 5, nil, nil,  nil, { 20060, 20061, 20062, 20063, 20064, }, 'TEXTURE', },
			{  0, 2, 1407, 5, nil, nil,  nil, { 20101, 20102, 20103, 20104, 20105, }, 'TEXTURE', },
			{  1, 0, 1631, 2, nil, nil,  nil, { 25956, 25957,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1464, 3, nil, nil,  nil, { 20335, 20336, 20337,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1401, 2, nil, nil,  nil, { 20042, 20045,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1633, 2, nil, nil,  nil, {  9452, 26016,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1411, 5, nil, nil,  nil, { 20117, 20118, 20119, 20120, 20121, }, 'TEXTURE', },
			{  2, 2, 1481, 1, nil, nil,  nil, { 20375,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 1634, 2, nil, nil,  nil, { 26022, 26023,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1632, 2, nil, nil,  nil, {  9799, 25988,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 1761, 3, nil, nil,  nil, { 32043, 35396, 35397,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1755, 3, nil, nil,  nil, { 31866, 31867, 31868,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1410, 3, nil, nil,  nil, { 20111, 20112, 20113,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1756, 1, nil, nil,  nil, { 31869,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			-- {  4, 2, 1756, 1, 'ReqTier', 'ReqCol', 1409, { 31869,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 1402, 3,   2,   1, 1411, { 20049, 20056, 20057,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1757, 2, nil, nil,  nil, { 31871, 31872,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2176, 2, nil, nil,  nil, { 53486, 53488,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1441, 1, nil, nil,  nil, { 20066,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1758, 3, nil, nil,  nil, { 31876, 31877, 31878,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1759, 3,   6,   1, 1441, { 31879, 31880, 31881,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 2147, 2, nil, nil,  nil, { 53375, 53376,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2148, 3, nil, nil,  nil, { 53379, 53484, 53648,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1823, 1, nil, nil,  nil, { 35395,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2179, 3, nil, nil,  nil, { 53501, 53502, 53503,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2149, 3, nil, nil,  nil, { 53380, 53381, 53382,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 2150, 1, nil, nil,  nil, { 53385,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	PRIEST = {
		[203] = {
			{  0, 0,  465, 3, nil, nil,  nil, { 15270, 15335, 15336,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2027, 2,   0,   0,  465, { 15337, 15338,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  462, 5, nil, nil,  nil, { 15259, 15307, 15308, 15309, 15310, }, 'TEXTURE', },
			{  1, 0,  466, 3, nil, nil,  nil, { 15318, 15272, 15320,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  482, 2, nil, nil,  nil, { 15275, 15317,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  463, 3, nil, nil,  nil, { 15260, 15327, 15328,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  542, 2, nil, nil,  nil, { 15392, 15448,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  481, 5, nil, nil,  nil, { 15273, 15312, 15313, 15314, 15316, }, 'TEXTURE', },
			{  2, 2,  501, 1, nil, nil,  nil, { 15407,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  483, 2, nil, nil,  nil, { 15274, 15311,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  881, 2, nil, nil,  nil, { 17322, 17323,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3,  461, 3, nil, nil,  nil, { 15257, 15331, 15332,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  541, 1,   2,   0,  542, { 15487,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  484, 1, nil, nil,  nil, { 15286,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1638, 2,   4,   1,  484, { 27839, 27840,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1777, 3, nil, nil,  nil, { 33213, 33214, 33215,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1781, 2, nil, nil,  nil, { 14910, 33371,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 2267, 3, nil, nil,  nil, { 63625, 63626, 63627,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  521, 1,   4,   1,  484, { 15473,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1778, 5, nil, nil,  nil, { 33221, 33222, 33223, 33224, 33225, }, 'TEXTURE', },
			{  7, 0, 1906, 2,   6,   1,  521, { 47569, 47570,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1816, 3, nil, nil,  nil, { 33191, 33192, 33193,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1908, 1, nil, nil,  nil, { 64044,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1779, 1,   6,   1,  521, { 34914,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1909, 3, nil, nil,  nil, { 47580, 47581, 47582,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 1907, 5, nil, nil,  nil, { 47573, 47577, 47578, 51166, 51167, }, 'TEXTURE', },
			{ 10, 1, 1910, 1,   8,   1, 1779, { 47585,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[202] = {
			{  0, 0,  410, 2, nil, nil,  nil, { 14913, 15012,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  406, 3, nil, nil,  nil, { 14908, 15020, 17191,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  401, 5, nil, nil,  nil, { 14889, 15008, 15009, 15010, 15011, }, 'TEXTURE', },
			{  1, 1,  411, 5, nil, nil,  nil, { 27900, 27901, 27902, 27903, 27904, }, 'TEXTURE', },
			{  1, 2, 1181, 5, nil, nil,  nil, { 18530, 18531, 18533, 18534, 18535, }, 'TEXTURE', },
			{  2, 0,  442, 1, nil, nil,  nil, { 19236,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1636, 3, nil, nil,  nil, { 27811, 27815, 27816,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  361, 3, nil, nil,  nil, { 14892, 15362, 15363,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1635, 2, nil, nil,  nil, { 27789, 27790,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  408, 3, nil, nil,  nil, { 14912, 15013, 15014,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  403, 2,   1,   2, 1181, { 14909, 15017,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  413, 2, nil, nil,  nil, { 14911, 15018,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1561, 1, nil, nil,  nil, { 20711,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  402, 5, nil, nil,  nil, { 14901, 15028, 15029, 15030, 15031, }, 'TEXTURE', },
			{  5, 0, 1766, 2, nil, nil,  nil, { 33150, 33154,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  404, 5, nil, nil,  nil, { 14898, 15349, 15354, 15355, 15356, }, 'TEXTURE', },
			{  6, 0, 1768, 3, nil, nil,  nil, { 34753, 34859, 34860,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1637, 1,   4,   1, 1561, {   724,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1765, 3, nil, nil,  nil, { 33142, 33145, 33146,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2279, 2, nil, nil,  nil, { 64127, 64129,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1767, 5, nil, nil,  nil, { 33158, 33159, 33160, 33161, 33162, }, 'TEXTURE', },
			{  7, 2, 1904, 3, nil, nil,  nil, { 63730, 63733, 63737,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1902, 3, nil, nil,  nil, { 63534, 63542, 63543,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1815, 1, nil, nil,  nil, { 34861,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1903, 3, nil, nil,  nil, { 47558, 47559, 47560,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1905, 5, nil, nil,  nil, { 47562, 47564, 47565, 47566, 47567, }, 'TEXTURE', },
			{ 10, 1, 1911, 1, nil, nil,  nil, { 47788,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[201] = {
			{  0, 1,  342, 5, nil, nil,  nil, { 14522, 14788, 14789, 14790, 14791, }, 'TEXTURE', },
			{  0, 2, 1898, 5, nil, nil,  nil, { 47586, 47587, 47588, 52802, 52803, }, 'TEXTURE', },
			{  1, 0,  352, 3, nil, nil,  nil, { 14523, 14784, 14785,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  346, 3, nil, nil,  nil, { 14747, 14770, 14771,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  344, 2, nil, nil,  nil, { 14749, 14767,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  321, 2, nil, nil,  nil, { 14531, 14774,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  347, 3, nil, nil,  nil, { 14521, 14776, 14777,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  348, 1, nil, nil,  nil, { 14751,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  343, 3, nil, nil,  nil, { 14748, 14768, 14769,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1769, 3, nil, nil,  nil, { 33167, 33171, 33172,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  341, 3, nil, nil,  nil, { 14520, 14780, 14781,   nil,   nil, }, 'TEXTURE', },
			{  3, 3,  350, 2, nil, nil,  nil, { 14750, 14772,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2268, 2, nil, nil,  nil, { 33201, 33202,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 1201, 5, nil, nil,  nil, { 18551, 18552, 18553, 18554, 18555, }, 'TEXTURE', },
			{  4, 2,  351, 1,   2,   2,  343, { 63574,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1771, 2, nil, nil,  nil, { 33186, 33190,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1772, 3, nil, nil,  nil, { 34908, 34909, 34910,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1858, 3, nil, nil,  nil, { 45234, 45243, 45244,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  322, 1,   4,   1, 1201, { 10060,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1773, 3, nil, nil,  nil, { 63504, 63505, 63506,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2235, 2, nil, nil,  nil, { 57470, 57472,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1896, 3, nil, nil,  nil, { 47535, 47536, 47537,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1894, 2, nil, nil,  nil, { 47507, 47508,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1895, 3, nil, nil,  nil, { 47509, 47511, 47515,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1774, 1, nil, nil,  nil, { 33206,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1901, 2, nil, nil,  nil, { 47516, 47517,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1202, 5, nil, nil,  nil, { 52795, 52797, 52798, 52799, 52800, }, 'TEXTURE', },
			{ 10, 1, 1897, 1, nil, nil,  nil, { 47540,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	ROGUE = {
		[182] = {
			{  0, 0,  276, 3, nil, nil,  nil, { 14162, 14163, 14164,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  272, 2, nil, nil,  nil, { 14144, 14148,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  270, 5, nil, nil,  nil, { 14138, 14139, 14140, 14141, 14142, }, 'TEXTURE', },
			{  1, 0,  273, 3, nil, nil,  nil, { 14156, 14160, 14161,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 2068, 2, nil, nil,  nil, { 51632, 51633,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  277, 3, nil, nil,  nil, { 13733, 13865, 13866,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  382, 1, nil, nil,  nil, { 14983,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  278, 2, nil, nil,  nil, { 14168, 14169,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  269, 5,   0,   2,  270, { 14128, 14132, 14135, 14136, 14137, }, 'TEXTURE', },
			{  3, 1,  682, 3, nil, nil,  nil, { 16513, 16514, 16515,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  268, 5, nil, nil,  nil, { 14113, 14114, 14115, 14116, 14117, }, 'TEXTURE', },
			{  4, 0, 1721, 2, nil, nil,  nil, { 31208, 31209,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  280, 1, nil, nil,  nil, { 14177,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  279, 3, nil, nil,  nil, { 14174, 14175, 14176,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1762, 2, nil, nil,  nil, { 31244, 31245,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1,  283, 5,   4,   1,  280, { 14186, 14190, 14193, 14194, 14195, }, 'TEXTURE', },
			{  5, 2,  274, 2, nil, nil,  nil, { 14158, 14159,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 2065, 2, nil, nil,  nil, { 51625, 51626,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  281, 1, nil, nil,  nil, { 58426,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1723, 3, nil, nil,  nil, { 31380, 31382, 31383,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2069, 3, nil, nil,  nil, { 51634, 51635, 51636,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1718, 3, nil, nil,  nil, { 31234, 31235, 31236,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1715, 3, nil, nil,  nil, { 31226, 31227, 58410,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1719, 1,   6,   1,  281, {  1329,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2066, 3, nil, nil,  nil, { 51627, 51628, 51629,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2070, 5, nil, nil,  nil, { 51664, 51665, 51667, 51668, 51669, }, 'TEXTURE', },
			{ 10, 1, 2071, 1, nil, nil,  nil, { 51662,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[181] = {
			{  0, 0,  203, 3, nil, nil,  nil, { 13741, 13793, 13792,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  201, 2, nil, nil,  nil, { 13732, 13863,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  221, 5, nil, nil,  nil, { 13715, 13848, 13849, 13851, 13852, }, 'TEXTURE', },
			{  1, 0, 1827, 2, nil, nil,  nil, { 14165, 14166,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  187, 3, nil, nil,  nil, { 13713, 13853, 13854,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  181, 5, nil, nil,  nil, { 13705, 13832, 13843, 13844, 13845, }, 'TEXTURE', },
			{  2, 0,  204, 2, nil, nil,  nil, { 13742, 13872,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  301, 1,   1,   1,  187, { 14251,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  182, 5,   0,   2,  221, { 13706, 13804, 13805, 13806, 13807, }, 'TEXTURE', },
			{  3, 0,  206, 2, nil, nil,  nil, { 13754, 13867,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  222, 2, nil, nil,  nil, { 13743, 13875,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  186, 3, nil, nil,  nil, { 13712, 13788, 13789,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1122, 5, nil, nil,  nil, { 18427, 18428, 18429, 61330, 61331, }, 'TEXTURE', },
			{  4, 0,  184, 5, nil, nil,  nil, { 13709, 13800, 13801, 13802, 13803, }, 'TEXTURE', },
			{  4, 1,  223, 1, nil, nil,  nil, { 13877,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  242, 5, nil, nil,  nil, { 13960, 13961, 13962, 13963, 13964, }, 'TEXTURE', },
			{  5, 1, 1703, 2,   4,   1,  223, { 30919, 30920,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1706, 2, nil, nil,  nil, { 31124, 31126,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1705, 3, nil, nil,  nil, { 31122, 31123, 61329,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  205, 1, nil, nil,  nil, { 13750,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1707, 2, nil, nil,  nil, { 31130, 31131,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2072, 2, nil, nil,  nil, {  5952, 51679,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1825, 5, nil, nil,  nil, { 35541, 35550, 35551, 35552, 35553, }, 'TEXTURE', },
			{  8, 0, 2073, 2, nil, nil,  nil, { 51672, 51674,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1709, 1,   6,   1,  205, { 32601,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2074, 2, nil, nil,  nil, { 51682, 58413,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2075, 5, nil, nil,  nil, { 51685, 51686, 51687, 51688, 51689, }, 'TEXTURE', },
			{ 10, 1, 2076, 1, nil, nil,  nil, { 51690,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[183] = {
			{  0, 0, 2244, 5, nil, nil,  nil, { 14179, 58422, 58423, 58424, 58425, }, 'TEXTURE', },
			{  0, 1,  241, 3, nil, nil,  nil, { 13958, 13970, 13971,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  261, 2, nil, nil,  nil, { 14057, 14072,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 1700, 2, nil, nil,  nil, { 30892, 30893,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  262, 2, nil, nil,  nil, { 14076, 14094,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  244, 3, nil, nil,  nil, { 13975, 14062, 14063,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  247, 2, nil, nil,  nil, { 13981, 14066,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  303, 1, nil, nil,  nil, { 14278,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1123, 3, nil, nil,  nil, { 14171, 14172, 14173,   nil,   nil, }, 'TEXTURE', },
			{  3, 0,  246, 3, nil, nil,  nil, { 13983, 14070, 14071,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  245, 3, nil, nil,  nil, { 13976, 13979, 13980,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  263, 2, nil, nil,  nil, { 14079, 14080,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1701, 2, nil, nil,  nil, { 30894, 30895,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  284, 1, nil, nil,  nil, { 14185,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  265, 2, nil, nil,  nil, { 14082, 14083,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3,  681, 1,   2,   2, 1123, { 16511,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1713, 3, nil, nil,  nil, { 31221, 31222, 31223,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1702, 5, nil, nil,  nil, { 30902, 30903, 30904, 30905, 30906, }, 'TEXTURE', },
			{  6, 0, 1711, 3, nil, nil,  nil, { 31211, 31212, 31213,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  381, 1,   4,   1,  284, { 14183,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1722, 3, nil, nil,  nil, { 31228, 31229, 31230,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1712, 5,   6,   1,  381, { 31216, 31217, 31218, 31219, 31220, }, 'TEXTURE', },
			{  7, 2, 2077, 2, nil, nil,  nil, { 51692, 51696,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2078, 3, nil, nil,  nil, { 51698, 51700, 51701,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1714, 1, nil, nil,  nil, { 36554,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2079, 2, nil, nil,  nil, { 58414, 58415,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2080, 5, nil, nil,  nil, { 51708, 51709, 51710, 51711, 51712, }, 'TEXTURE', },
			{ 10, 1, 2081, 1, nil, nil,  nil, { 51713,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	SHAMAN = {
		[262] = {
			{  0, 1,  586, 5, nil, nil,  nil, { 16182, 16226, 16227, 16228, 16229, }, 'TEXTURE', },
			{  0, 2,  595, 5, nil, nil,  nil, { 16173, 16222, 16223, 16224, 16225, }, 'TEXTURE', },
			{  1, 0,  589, 2, nil, nil,  nil, { 16184, 16209,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1646, 3, nil, nil,  nil, { 29187, 29189, 29191,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  593, 5, nil, nil,  nil, { 16179, 16214, 16215, 16216, 16217, }, 'TEXTURE', },
			{  2, 0,  583, 3, nil, nil,  nil, { 16180, 16196, 16198,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  587, 3, nil, nil,  nil, { 16181, 16230, 16232,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  582, 1, nil, nil,  nil, { 55198,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  581, 3, nil, nil,  nil, { 16176, 16235, 16240,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  588, 3, nil, nil,  nil, { 16187, 16205, 16206,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  594, 5, nil, nil,  nil, { 16194, 16218, 16219, 16220, 16221, }, 'TEXTURE', },
			{  4, 0, 1648, 3, nil, nil,  nil, { 29206, 29205, 29202,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  591, 1, nil, nil,  nil, { 16188,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1695, 3, nil, nil,  nil, { 30864, 30865, 30866,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  592, 5, nil, nil,  nil, { 16178, 16210, 16211, 16212, 16213, }, 'TEXTURE', },
			{  6, 0, 1699, 5, nil, nil,  nil, { 30881, 30883, 30884, 30885, 30886, }, 'TEXTURE', },
			{  6, 1,  590, 1,   3,   1,  588, { 16190,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 2084, 1,   5,   2,  592, { 51886,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2060, 2, nil, nil,  nil, { 51554, 51555,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1697, 2, nil, nil,  nil, { 30872, 30873,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1696, 3, nil, nil,  nil, { 30867, 30868, 30869,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2061, 3, nil, nil,  nil, { 51556, 51557, 51558,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1698, 1, nil, nil,  nil, {   974,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2059, 2,   8,   1, 1698, { 51560, 51561,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2063, 5, nil, nil,  nil, { 51562, 51563, 51564, 51565, 51566, }, 'TEXTURE', },
			{ 10, 1, 2064, 1, nil, nil,  nil, { 61295,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[263] = CT.IsWotLKTitan and {
			{  0, 0,  610, 3, nil, nil,  nil, { 16259, 16295, 52456,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2101, 2, nil, nil,  nil, { 16043, 16130,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  614, 5, nil, nil,  nil, { 17485, 17486, 17487, 17488, 17489, }, 'TEXTURE', },
			{  1, 0,  609, 2, nil, nil,  nil, { 16258, 16293,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  613, 5, nil, nil,  nil, { 16255, 16302, 16303, 16304, 16305, }, 'TEXTURE', },
			{  1, 2,  605, 2, nil, nil,  nil, { 16262, 16287,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  607, 3, nil, nil,  nil, { 16261, 16290, 51881,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  611, 3, nil, nil,  nil, { 16266, 29079, 29080,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  617, 1, nil, nil,  nil, { 43338,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  601, 3, nil, nil,  nil, { 16254, 16271, 16272,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  602, 5,   1,   1,  613, { 16256, 16281, 16282, 16283, 16284, }, 'TEXTURE', },
			{  3, 2,  615, 5, nil, nil,  nil, { 16252, 16306, 16307, 16308, 16309, }, 'TEXTURE', },
			{  4, 0, 1647, 2, nil, nil,  nil, { 29192, 29193,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  616, 1, nil, nil,  nil, { 16268,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2083, 3, nil, nil,  nil, { 51883, 51884, 51885,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1689, 3, nil, nil,  nil, { 30802, 30808, 30809,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1643, 3, nil, nil,  nil, { 29082, 29084, 29086,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 2263, 2, nil, nil,  nil, { 63373, 63374,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1692, 3,   6,   1, 1690, { 30816, 30818, 30819,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1690, 1,   4,   1,  616, { 30798,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 23706, 3,   6,   1,  616, { 1283508, 1283509, 1283510,   nil,   nil, }, 'TEXTURE', },--	WoTLK Titan特有
			{  6, 3,  901, 1, nil, nil,  nil, { 17364,   nil,   nil,   nil,   nil, }, 'TEXTURE', },	--	右移一格
			{  7, 0, 2055, 3, nil, nil,  nil, { 51525, 51526, 51527,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 2249, 1,   6,   1, 1690, { 60103,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 3, 2054, 2,   6,   3,  901, { 51521, 51522,   nil,   nil,   nil, }, 'TEXTURE', },	--	右移一格
			{  8, 0, 1691, 3, nil, nil,  nil, { 30812, 30813, 30814,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1693, 1, nil, nil,  nil, { 30823,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2056, 2, nil, nil,  nil, { 51523, 51524,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2057, 5, nil, nil,  nil, { 51528, 51529, 51530, 51531, 51532, }, 'TEXTURE', },
			{ 10, 1, 2058, 1, nil, nil,  nil, { 51533,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		} or {
			{  0, 0,  610, 3, nil, nil,  nil, { 16259, 16295, 52456,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2101, 2, nil, nil,  nil, { 16043, 16130,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  614, 5, nil, nil,  nil, { 17485, 17486, 17487, 17488, 17489, }, 'TEXTURE', },
			{  1, 0,  609, 2, nil, nil,  nil, { 16258, 16293,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  613, 5, nil, nil,  nil, { 16255, 16302, 16303, 16304, 16305, }, 'TEXTURE', },
			{  1, 2,  605, 2, nil, nil,  nil, { 16262, 16287,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3,  607, 3, nil, nil,  nil, { 16261, 16290, 51881,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  611, 3, nil, nil,  nil, { 16266, 29079, 29080,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  617, 1, nil, nil,  nil, { 43338,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  601, 3, nil, nil,  nil, { 16254, 16271, 16272,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  602, 5,   1,   1,  613, { 16256, 16281, 16282, 16283, 16284, }, 'TEXTURE', },
			{  3, 2,  615, 5, nil, nil,  nil, { 16252, 16306, 16307, 16308, 16309, }, 'TEXTURE', },
			{  4, 0, 1647, 2, nil, nil,  nil, { 29192, 29193,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  616, 1, nil, nil,  nil, { 16268,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2083, 3, nil, nil,  nil, { 51883, 51884, 51885,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1689, 3, nil, nil,  nil, { 30802, 30808, 30809,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 1643, 3, nil, nil,  nil, { 29082, 29084, 29086,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 2263, 2, nil, nil,  nil, { 63373, 63374,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1692, 3,   6,   1, 1690, { 30816, 30818, 30819,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1690, 1,   4,   1,  616, { 30798,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2,  901, 1, nil, nil,  nil, { 17364,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2055, 3, nil, nil,  nil, { 51525, 51526, 51527,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 2249, 1,   6,   1, 1690, { 60103,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 2054, 2,   6,   2,  901, { 51521, 51522,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1691, 3, nil, nil,  nil, { 30812, 30813, 30814,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1693, 1, nil, nil,  nil, { 30823,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2056, 2, nil, nil,  nil, { 51523, 51524,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2057, 5, nil, nil,  nil, { 51528, 51529, 51530, 51531, 51532, }, 'TEXTURE', },
			{ 10, 1, 2058, 1, nil, nil,  nil, { 51533,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[261] = {
			{  0, 1,  564, 5, nil, nil,  nil, { 16039, 16109, 16110, 16111, 16112, }, 'TEXTURE', },
			{  0, 2,  563, 5, nil, nil,  nil, { 16035, 16105, 16106, 16107, 16108, }, 'TEXTURE', },
			{  1, 0,  561, 3, nil, nil,  nil, { 16038, 16160, 16161,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1640, 3, nil, nil,  nil, { 28996, 28997, 28998,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1645, 3, nil, nil,  nil, { 30160, 29179, 29180,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  575, 5, nil, nil,  nil, { 16040, 16113, 16114, 16115, 16116, }, 'TEXTURE', },
			{  2, 1,  574, 1, nil, nil,  nil, { 16164,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  565, 5, nil, nil,  nil, { 16089, 60184, 60185, 60187, 60188, }, 'TEXTURE', },
			{  3, 0,  567, 2, nil, nil,  nil, { 16086, 16544,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1642, 3, nil, nil,  nil, { 29062, 29064, 29065,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1641, 2, nil, nil,  nil, { 28999, 29000,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  562, 1,   2,   1,  574, { 16041,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 1682, 3, nil, nil,  nil, { 30664, 30665, 30666,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1685, 3, nil, nil,  nil, { 30672, 30673, 30674,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  721, 5,   2,   2,  565, { 16578, 16579, 16580, 16581, 16582, }, 'TEXTURE', },
			{  6, 1,  573, 1,   4,   1,  562, { 16166,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 2052, 3, nil, nil,  nil, { 51483, 51485, 51486,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2262, 2, nil, nil,  nil, { 63370, 63372,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 2049, 2,   6,   1,  573, { 51466, 51470,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1686, 3, nil, nil,  nil, { 30675, 30678, 30679,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2050, 3, nil, nil,  nil, { 51474, 51478, 51479,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1687, 1, nil, nil,  nil, { 30706,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2051, 3, nil, nil,  nil, { 51480, 51481, 51482,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2252, 5, nil, nil,  nil, { 62097, 62098, 62099, 62100, 62101, }, 'TEXTURE', },
			{ 10, 1, 2053, 1, nil, nil,  nil, { 51490,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	WARLOCK = {
		[301] = {
			{  0, 1,  944, 5, nil, nil,  nil, { 17793, 17796, 17801, 17802, 17803, }, 'TEXTURE', },
			{  0, 2,  943, 5, nil, nil,  nil, { 17788, 17789, 17790, 17791, 17792, }, 'TEXTURE', },
			{  1, 0,  982, 2, nil, nil,  nil, { 18119, 18120,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1887, 3, nil, nil,  nil, { 63349, 63350, 63351,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  941, 3, nil, nil,  nil, { 17778, 17779, 17780,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  983, 2, nil, nil,  nil, { 18126, 18127,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  963, 1, nil, nil,  nil, { 17877,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  967, 5, nil, nil,  nil, { 17959, 59738, 59739, 59740, 59741, }, 'TEXTURE', },
			{  3, 0,  985, 2, nil, nil,  nil, { 18135, 18136,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  964, 2, nil, nil,  nil, { 17917, 17918,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3,  965, 3, nil, nil,  nil, { 17927, 17929, 17930,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1817, 3,   3,   0,  985, { 34935, 34938, 34939,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  961, 3, nil, nil,  nil, { 17815, 17833, 17834,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  981, 1,   2,   2,  967, { 18130,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1679, 3, nil, nil,  nil, { 30299, 30301, 30302,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  966, 5, nil, nil,  nil, { 17954, 17955, 17956, 17957, 17958, }, 'TEXTURE', },
			{  6, 1,  968, 1,   4,   1,  961, { 17962,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1678, 3, nil, nil,  nil, { 30293, 30295, 30296,   nil,   nil, }, 'TEXTURE', },
			{  6, 3,  986, 3, nil, nil,  nil, { 18096, 18073, 63245,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1677, 5, nil, nil,  nil, { 30288, 30289, 30290, 30291, 30292, }, 'TEXTURE', },
			{  7, 2, 1889, 2,   6,   2, 1678, { 54117, 54118,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1888, 3,   6,   1,  968, { 47258, 47259, 47260,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1676, 1, nil, nil,  nil, { 30283,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2045, 3, nil, nil,  nil, { 47220, 47221, 47223,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1890, 5, nil, nil,  nil, { 47266, 47267, 47268, 47269, 47270, }, 'TEXTURE', },
			{ 10, 1, 1891, 1, nil, nil,  nil, { 50796,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[302] = {
			{  0, 0, 1284, 2, nil, nil,  nil, { 18827, 18829,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1005, 3, nil, nil,  nil, { 18174, 18175, 18176,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 1003, 5, nil, nil,  nil, { 17810, 17811, 17812, 17813, 17814, }, 'TEXTURE', },
			{  1, 0, 1006, 2, nil, nil,  nil, { 18179, 18180,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1101, 2, nil, nil,  nil, { 18213, 18372,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1007, 2, nil, nil,  nil, { 18182, 18183,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 1004, 2, nil, nil,  nil, { 17804, 17805,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2205, 2, nil, nil,  nil, { 53754, 53759,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1001, 3, nil, nil,  nil, { 17783, 17784, 17785,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1061, 1, nil, nil,  nil, { 18288,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 0, 1021, 2, nil, nil,  nil, { 18218, 18219,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 1002, 2, nil, nil,  nil, { 18094, 18095,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 1764, 3, nil, nil,  nil, { 32381, 32382, 32383,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1763, 5, nil, nil,  nil, { 32385, 32387, 32392, 32393, 32394, }, 'TEXTURE', },
			{  4, 1, 1041, 1, nil, nil,  nil, { 63108,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1081, 1,   2,   2, 1061, { 18223,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1873, 2, nil, nil,  nil, { 54037, 54038,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 1042, 5,   4,   1, 1041, { 18271, 18272, 18273, 18274, 18275, }, 'TEXTURE', },
			{  6, 0, 1878, 3, nil, nil,  nil, { 47195, 47196, 47197,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1669, 5, nil, nil,  nil, { 30060, 30061, 30062, 30063, 30064, }, 'TEXTURE', },
			{  6, 2, 1022, 1, nil, nil,  nil, { 18220,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1668, 2, nil, nil,  nil, { 30054, 30057,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1667, 3, nil, nil,  nil, { 32477, 32483, 32484,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1875, 3, nil, nil,  nil, { 47198, 47199, 47200,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1670, 1,   6,   1, 1669, { 30108,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 2245, 1,   8,   1, 1670, { 58435,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1876, 5, nil, nil,  nil, { 47201, 47202, 47203, 47204, 47205, }, 'TEXTURE', },
			{ 10, 1, 2041, 1, nil, nil,  nil, { 48181,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[303] = {
			{  0, 0, 1221, 2, nil, nil,  nil, { 18692, 18693,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1222, 3, nil, nil,  nil, { 18694, 18695, 18696,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 1223, 3, nil, nil,  nil, { 18697, 18698, 18699,   nil,   nil, }, 'TEXTURE', },
			{  0, 3, 1883, 2, nil, nil,  nil, { 47230, 47231,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 1224, 2, nil, nil,  nil, { 18703, 18704,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 1225, 3, nil, nil,  nil, { 18705, 18706, 18707,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 1242, 3, nil, nil,  nil, { 18731, 18743, 18744,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 1243, 3, nil, nil,  nil, { 18754, 18755, 18756,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 1282, 1, nil, nil,  nil, { 19028,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1226, 1, nil, nil,  nil, { 18708,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 1671, 3, nil, nil,  nil, { 30143, 30144, 30145,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 1262, 5,   2,   1, 1282, { 18769, 18770, 18771, 18772, 18773, }, 'TEXTURE', },
			{  3, 2, 1227, 2,   2,   2, 1226, { 18709, 18710,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 1281, 1,   3,   1, 1262, { 30326,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1261, 2, nil, nil,  nil, { 18767, 18768,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 1244, 5,   3,   1, 1262, { 23785, 23822, 23823, 23824, 23825, }, 'TEXTURE', },
			{  5, 2, 1283, 3, nil, nil,  nil, { 47245, 47246, 47247,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1680, 3, nil, nil,  nil, { 30319, 30320, 30321,   nil,   nil, }, 'TEXTURE', },
			{  6, 1, 1880, 1,   5,   1, 1244, { 47193,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1263, 3, nil, nil,  nil, { 35691, 35692, 35693,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1673, 5, nil, nil,  nil, { 30242, 30245, 30246, 30247, 30248, }, 'TEXTURE', },
			{  7, 2, 2261, 2, nil, nil,  nil, { 63156, 63158,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1882, 3,   7,   1, 1673, { 54347, 54348, 54349,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1672, 1, nil, nil,  nil, { 30146,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1884, 3, nil, nil,  nil, { 63117, 63121, 63123,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1885, 5, nil, nil,  nil, { 47236, 47237, 47238, 47239, 47240, }, 'TEXTURE', },
			{ 10, 1, 1886, 1, nil, nil,  nil, { 59672,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	WARRIOR = {
		[161] = {
			{  0, 0,  124, 3, nil, nil,  nil, { 12282, 12663, 12664,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  130, 5, nil, nil,  nil, { 16462, 16463, 16464, 16465, 16466, }, 'TEXTURE', },
			{  0, 2,  127, 2, nil, nil,  nil, { 12286, 12658,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0,  126, 2, nil, nil,  nil, { 12285, 12697,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  641, 3, nil, nil,  nil, { 12300, 12959, 12960,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  128, 3, nil, nil,  nil, { 12295, 12676, 12677,   nil,   nil, }, 'TEXTURE', },
			{  2, 0,  131, 2, nil, nil,  nil, { 12290, 12963,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  137, 1, nil, nil,  nil, { 12296,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  662, 2, nil, nil,  nil, { 16493, 16494,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  121, 3,   2,   2,  662, { 12834, 12849, 12867,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  136, 3, nil, nil,  nil, { 12163, 12711, 12712,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2232, 3, nil, nil,  nil, { 56636, 56637, 56638,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  132, 5, nil, nil,  nil, { 12700, 12781, 12783, 12784, 12785, }, 'TEXTURE', },
			{  4, 1,  133, 1, nil, nil,  nil, { 12328,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  125, 5, nil, nil,  nil, { 12284, 12701, 12702, 12703, 12704, }, 'TEXTURE', },
			{  4, 3,  123, 5, nil, nil,  nil, { 12281, 12812, 12813, 12814, 12815, }, 'TEXTURE', },
			{  5, 0,  134, 2, nil, nil,  nil, { 20504, 20505,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  129, 3, nil, nil,  nil, { 12289, 12668, 23695,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 1859, 2, nil, nil,  nil, { 46854, 46855,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 0, 1663, 2, nil, nil,  nil, { 29834, 29838,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  135, 1,   4,   1,  133, { 12294,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1862, 2, nil, nil,  nil, { 46865, 46866,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 3, 2233, 2, nil, nil,  nil, { 12862, 12330,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 2283, 1, nil, nil,  nil, { 64976,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1824, 3,   6,   1,  135, { 35446, 35448, 35449,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1860, 2, nil, nil,  nil, { 46859, 46860,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 1662, 3, nil, nil,  nil, { 29723, 29725, 29724,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1661, 1, nil, nil,  nil, { 29623,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1664, 2, nil, nil,  nil, { 29836, 29859,   nil,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2231, 5, nil, nil,  nil, { 46867, 56611, 56612, 56613, 56614, }, 'TEXTURE', },
			{ 10, 1, 1863, 1, nil, nil,  nil, { 46924,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[163] = {
			{  0, 0,  142, 2, nil, nil,  nil, { 12301, 12818,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 1601, 5, nil, nil,  nil, { 12298, 12724, 12725, 12726, 12727, }, 'TEXTURE', },
			{  0, 2,  141, 3, nil, nil,  nil, { 12287, 12665, 12666,   nil,   nil, }, 'TEXTURE', },
			{  1, 1,  144, 3, nil, nil,  nil, { 50685, 50686, 50687,   nil,   nil, }, 'TEXTURE', },
			{  1, 2,  138, 5, nil, nil,  nil, { 12297, 12750, 12751, 12752, 12753, }, 'TEXTURE', },
			{  2, 0,  153, 1, nil, nil,  nil, { 12975,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  147, 2, nil, nil,  nil, { 12797, 12799,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 1654, 2, nil, nil,  nil, { 29598, 29599,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  140, 5, nil, nil,  nil, { 12299, 12761, 12762, 12763, 12764, }, 'TEXTURE', },
			{  3, 0, 2247, 2, nil, nil,  nil, { 59088, 59089,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1,  151, 2, nil, nil,  nil, { 12313, 12804,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  146, 3, nil, nil,  nil, { 12308, 12810, 12811,   nil,   nil, }, 'TEXTURE', },
			{  4, 0,  150, 2, nil, nil,  nil, { 12312, 12803,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  152, 1, nil, nil,  nil, { 12809,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2,  149, 2, nil, nil,  nil, { 12311, 12958,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  702, 5, nil, nil,  nil, { 16538, 16539, 16540, 16541, 16542, }, 'TEXTURE', },
			{  6, 0, 1652, 2, nil, nil,  nil, { 29593, 29594,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  148, 1,   4,   1,  152, { 50720,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 2, 1660, 3, nil, nil,  nil, { 29787, 29790, 29792,   nil,   nil, }, 'TEXTURE', },
			{  7, 1, 1653, 3, nil, nil,  nil, { 29140, 29143, 29144,   nil,   nil, }, 'TEXTURE', },
			{  7, 2, 1870, 2, nil, nil,  nil, { 46945, 46949,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 0, 2236, 1, nil, nil,  nil, { 57499,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1666, 1, nil, nil,  nil, { 20243,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1893, 3, nil, nil,  nil, { 47294, 47295, 47296,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 1871, 3,   8,   1, 1666, { 46951, 46952, 46953,   nil,   nil, }, 'TEXTURE', },
			{  9, 2, 2246, 2, nil, nil,  nil, { 58872, 58874,   nil,   nil,   nil, }, 'TEXTURE', },
			{ 10, 1, 1872, 1, nil, nil,  nil, { 46968,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[164] = {
			{  0, 0, 2250, 3, nil, nil,  nil, { 61216, 61221, 61222,   nil,   nil, }, 'TEXTURE', },
			{  0, 1,  158, 2, nil, nil,  nil, { 12321, 12835,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2,  157, 5, nil, nil,  nil, { 12320, 12852, 12853, 12855, 12856, }, 'TEXTURE', },
			{  1, 1,  161, 5, nil, nil,  nil, { 12324, 12876, 12877, 12878, 12879, }, 'TEXTURE', },
			{  1, 2,  159, 5, nil, nil,  nil, { 12322, 12999, 13000, 13001, 13002, }, 'TEXTURE', },
			{  2, 0,  166, 3, nil, nil,  nil, { 12329, 12950, 20496,   nil,   nil, }, 'TEXTURE', },
			{  2, 1,  160, 1, nil, nil,  nil, { 12323,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2,  661, 3, nil, nil,  nil, { 16487, 16489, 16492,   nil,   nil, }, 'TEXTURE', },
			{  2, 3,  154, 5, nil, nil,  nil, { 12318, 12857, 12858, 12860, 12861, }, 'TEXTURE', },
			{  3, 0, 1581, 5, nil, nil,  nil, { 23584, 23585, 23586, 23587, 23588, }, 'TEXTURE', },
			{  3, 1, 1542, 2, nil, nil,  nil, { 20502, 20503,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2,  155, 5, nil, nil,  nil, { 12317, 13045, 13046, 13047, 13048, }, 'TEXTURE', },
			{  4, 0, 1657, 3, nil, nil,  nil, { 29590, 29591, 29592,   nil,   nil, }, 'TEXTURE', },
			{  4, 1,  165, 1, nil, nil,  nil, { 12292,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 1543, 2, nil, nil,  nil, { 29888, 29889,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 1541, 2, nil, nil,  nil, { 20500, 20501,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2,  156, 5, nil, nil,  nil, { 12319, 12971, 12972, 12973, 12974, }, 'TEXTURE', },
			{  6, 0, 1864, 3, nil, nil,  nil, { 46908, 46909, 56924,   nil,   nil, }, 'TEXTURE', },
			{  6, 1,  167, 1,   4,   1,  165, { 23881,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  6, 3, 1655, 2, nil, nil,  nil, { 29721, 29776,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 0, 1865, 2, nil, nil,  nil, { 46910, 46911,   nil,   nil,   nil, }, 'TEXTURE', },
			{  7, 3, 1658, 5, nil, nil,  nil, { 29759, 29760, 29761, 29762, 29763, }, 'TEXTURE', },
			{  8, 0, 1868, 1, nil, nil,  nil, { 60970,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 1, 1659, 1,   6,   1,  167, { 29801,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  8, 2, 1866, 3,   6,   1,  167, { 46913, 46914, 46915,   nil,   nil, }, 'TEXTURE', },
			{  9, 1, 2234, 5, nil, nil,  nil, { 56927, 56929, 56930, 56931, 56932, }, 'TEXTURE', },
			{ 10, 1, 1867, 1, nil, nil,  nil, { 46917,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	--[[
	PET = {
		[409] = {
			{  0, 0, 2114, 2, nil, nil,  nil, { 61682, 61683,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2237, 1, nil, nil,  nil, { 61685,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 2116, 3, nil, nil,  nil, { 61686, 61687, 61688,   nil,   nil, }, 'TEXTURE', },
			{  0, 3, 2117, 2, nil, nil,  nil, { 61689, 61690,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 2126, 3, nil, nil,  nil, { 53182, 53183, 53184,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 2160, 1, nil, nil,  nil, { 19596,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 2173, 2,   0,   2, 2116, { 53481, 53482,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 2122, 2,   0,   3, 2117, { 53175, 53176,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2110, 3, nil, nil,  nil, { 61680, 61681, 52858,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 2123, 2, nil, nil,  nil, { 53178, 53179,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 2162, 2, nil, nil,  nil, { 53409, 53411,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 2277, 1, nil, nil,  nil, { 63900,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2163, 2, nil, nil,  nil, { 53450, 53451,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2161, 3, nil, nil,  nil, { 53427, 53429, 53430,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2171, 1, nil, nil,  nil, { 53478,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 2170, 1,   2,   1, 2123, { 53477,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2172, 1,   3,   2, 2163, { 53480,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 2169, 1, nil, nil,  nil, { 53476,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 1, 2258, 2, nil, nil,  nil, { 62764, 62765,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 2255, 2,   4,   2, 2172, { 62758, 62762,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[410] = {
			{  0, 0, 2107, 2, nil, nil,  nil, { 61682, 61683,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2109, 1, nil, nil,  nil, { 61684,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2203, 1, nil, nil,  nil, { 23145,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 2112, 3, nil, nil,  nil, { 61686, 61687, 61688,   nil,   nil, }, 'TEXTURE', },
			{  0, 3, 2113, 2, nil, nil,  nil, { 61689, 61690,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 2124, 2, nil, nil,  nil, { 53180, 53181,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 2128, 2, nil, nil,  nil, { 53186, 53187,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 2125, 3, nil, nil,  nil, { 53182, 53183, 53184,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 2151, 1, nil, nil,  nil, { 19596,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2106, 3, nil, nil,  nil, { 61680, 61681, 52858,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 2152, 2, nil, nil,  nil, { 53409, 53411,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 2111, 1, nil, nil,  nil, { 61685,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 3, 2219, 1, nil, nil,  nil, { 52825,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 2156, 1,   1,   1, 2128, { 55709,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2129, 3, nil, nil,  nil, { 53203, 53204, 53205,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2154, 3, nil, nil,  nil, { 53427, 53429, 53430,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2155, 1, nil, nil,  nil, { 53401,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 2153, 1,   3,   1, 2156, { 53426,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2157, 1,   3,   2, 2129, { 53434,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 2254, 2, nil, nil,  nil, { 62759, 62760,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 2, 2253, 2,   4,   2, 2157, { 62758, 62762,   nil,   nil,   nil, }, 'TEXTURE', },
		},
		[411] = {
			{  0, 0, 2118, 2, nil, nil,  nil, { 61682, 61683,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2119, 1, nil, nil,  nil, { 61684,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 1, 2201, 1, nil, nil,  nil, { 23145,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  0, 2, 2120, 3, nil, nil,  nil, { 61686, 61687, 61688,   nil,   nil, }, 'TEXTURE', },
			{  0, 3, 2121, 2, nil, nil,  nil, { 61689, 61690,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 0, 2165, 1, nil, nil,  nil, { 19596,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 2207, 2,   0,   1, 2119, { 53483, 53485,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 1, 2208, 2,   0,   1, 2201, { 53554, 53555,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 2, 2182, 2, nil, nil,  nil, { 53514, 53516,   nil,   nil,   nil, }, 'TEXTURE', },
			{  1, 3, 2127, 3, nil, nil,  nil, { 53182, 53183, 53184,   nil,   nil, }, 'TEXTURE', },
			{  2, 0, 2166, 3, nil, nil,  nil, { 61680, 61681, 52858,   nil,   nil, }, 'TEXTURE', },
			{  2, 1, 2167, 2, nil, nil,  nil, { 53409, 53411,   nil,   nil,   nil, }, 'TEXTURE', },
			{  2, 2, 2206, 1, nil, nil,  nil, { 54044,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 1, 2168, 3, nil, nil,  nil, { 53427, 53429, 53430,   nil,   nil, }, 'TEXTURE', },
			{  3, 2, 2177, 2, nil, nil,  nil, { 52234, 53497,   nil,   nil,   nil, }, 'TEXTURE', },
			{  3, 3, 2183, 2,   1,   3, 2127, { 53511, 53512,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 0, 2181, 1, nil, nil,  nil, { 53508,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 1, 2184, 1, nil, nil,  nil, { 53517,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 2, 2175, 1,   3,   2, 2177, { 53490,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
			{  4, 3, 2257, 2, nil, nil,  nil, { 53450, 53451,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 0, 2256, 2,   4,   0, 2181, { 62758, 62762,   nil,   nil,   nil, }, 'TEXTURE', },
			{  5, 3, 2278, 1,   4,   3, 2257, { 53480,   nil,   nil,   nil,   nil, }, 'TEXTURE', },
		},
	},
	--]]
};
--
	--	DT.SpellDB_P
	--1------2---3-----4------5-----6--------7-------8
	--level, id, cost, phase, name, passive, talent, class
	--	passive = true, talent = true, race = "", require = SpellID,
--
DT.SpellDB = {
	DEATHKNIGHT = {
		{ name = "鲜血打击", { 55, 45902, 0, }, { 59, 49926, 5900, }, { 64, 49927, 64000, }, { 69, 49928, 69000, }, { 74, 49929, 360000, }, { 80, 49930, 360000, }, },
		{ name = "暗影打击", { 55, 45462, 0, }, { 60, 49917, 5800, }, { 65, 49918, 65000, }, { 70, 49919, 360000, }, { 75, 49920, 360000, }, { 80, 49921, 360000, }, },
		{ name = "冰冷触摸", { 55, 45477, 0, }, { 61, 49896, 61000, }, { 67, 49903, 67000, }, { 73, 49904, 360000, }, { 78, 49909, 360000, }, },
		{ name = "凋零缠绕", { 55, 47541, 0, }, { 62, 49892, 59000, }, { 68, 49893, 68000, }, { 76, 49894, 360000, }, { 80, 49895, 360000, }, },
		{ name = "冰锋符文", { 55, 53343, 55000, }, },
		{ name = "灰烬冰河符文", { 55, 53341, 55000, }, },
		{ name = "亡者复生", { 56, 46584, 5600, }, },
		{ name = "传染", { 56, 50842, 5600, }, },
		{ name = "灵界打击", { 56, 49998, 5600, }, { 63, 49999, 65000, }, { 70, 45463, 63000, }, { 75, 49923, 360000, }, { 80, 49924, 360000, }, },
		{ name = "法术碎裂符文", { 57, 53342, 5700, }, },
		{ name = "心灵冰冻", { 57, 47528, 5700, }, },
		{ name = "冰霜灵气", { 57, 48263, 5700, }, },
		{ name = "法术阻断符文", { 57, 54447, 5700, }, },
		{ name = "寒冰锁链", { 58, 45524, 5800, }, },
		{ name = "血液沸腾", { 58, 48721, 5800, }, { 66, 49939, 66000, }, { 72, 49940, 360000, }, { 78, 49941, 360000, }, },
		{ name = "绞袭", { 59, 47476, 5900, }, },
		{ name = "巫妖斩除符文", { 60, 53331, 6000, }, },
		{ name = "枯萎凋零", { 60, 43265, 6000, }, { 67, 49936, 68000, }, { 73, 49937, 360000, }, { 80, 49938, 360000, }, },
		{ name = "冰霜之路", { 61, 3714, 61000, }, },
		{ name = "湮没", { 61, 49020, 61000, }, { 67, 51423, 67000, }, { 73, 51424, 360000, }, { 79, 51425, 360000, }, },
		{ name = "冰封之韧", { 62, 48792, 62000, }, },
		{ name = "裂刃符文", { 63, 53323, 63000, }, },
		{ name = "破刃符文", { 63, 54446, 68000, }, },
		{ name = "活力分流", { 64, 45529, 64000, }, },
		{ name = "黑暗命令", { 65, 56222, 65000, }, },
		{ name = "寒冬号角", { 65, 57330, 65000, }, { 75, 57623, 360000, }, },
		{ name = "天灾契约", { 66, 48743, 66000, }, },
		{ name = "符文打击", { 67, 56815, 67000, }, },
		{ name = "反魔法护罩", { 68, 48707, 68000, }, },
		{ name = "邪恶灵气", { 70, 48265, 360000, }, },
		{ name = "堕落十字军符文", { 70, 53344, 360000, }, },
		{ name = "蛛魔甲壳符文", { 72, 70164, 360000, }, },
		{ name = "复活盟友", { 72, 61999, 360000, }, },
		{ name = "石肤石像鬼符文", { 72, 62158, 360000, }, },
		{ name = "符文武器增效", { 75, 47568, 360000, }, },
		{ name = "亡者大军", { 80, 42650, 360000, }, },
		{ name = "心脏打击", { -1, 55050, 0, }, { 59, 55258, 5900, }, { 64, 55259, 3200, }, { 69, 55260, 3450, }, { 74, 55261, 18000, }, { 80, 55262, 18000, }, talent = true, },
		{ name = "冰霜打击", { -1, 49143, 0, }, { 60, 51416, 6200, }, { 65, 51417, 3250, }, { 70, 51418, 18000, }, { 75, 51419, 18000, }, { 80, 55268, 18000, }, talent = true, },
		{ name = "邪爆", { -1, 49158, 0, }, { 60, 51325, 300, }, { 70, 51326, 18000, }, { 75, 51327, 18000, }, { 80, 51328, 18000, }, talent = true, },
		{ name = "天灾打击", { -1, 55090, 0, }, { 67, 55265, 18000, }, { 73, 55270, 18000, }, { 79, 55271, 18000, }, talent = true, },
		{ name = "凛风冲击", { -1, 49184, 0, }, { 70, 51409, 3350, }, { 75, 51410, 18000, }, { 80, 51411, 18000, }, talent = true, },
		{ name = "符文分流", { -1, 48982, 0, }, talent = true, },
		{ name = "巫妖之躯", { -1, 49039, 0, }, talent = true, },
		{ name = "食尸鬼狂乱", { -1, 63560, 0, }, talent = true, },
		{ name = "符文刃舞", { -1, 49028, 0, }, talent = true, },
		{ name = "饥饿之寒", { -1, 49203, 0, }, talent = true, },
		{ name = "铜墙铁壁", { -1, 51271, 0, }, talent = true, },
		{ name = "鲜血印记", { -1, 49005, 0, }, talent = true, },
		{ name = "吸血鬼之血", { -1, 55233, 0, }, talent = true, },
		{ name = "召唤石像鬼", { -1, 49206, 0, }, talent = true, },
		{ name = "白骨之盾", { -1, 49222, 0, }, talent = true, },
		{ name = "反魔法领域", { -1, 51052, 0, }, talent = true, },
		{ name = "黑锋冰寒", { -1, 49796, 0, }, talent = true, },
		{ name = "邪恶狂热", { -1, 49016, 0, }, talent = true, },
	},
	DRUID = {
		{ name = "愤怒", { 1, 5176, 0, }, { 6, 5177, 100, }, { 14, 5178, 900, }, { 22, 5179, 3000, }, { 30, 5180, 6000, }, { 38, 6780, 12000, }, { 46, 8905, 20000, }, { 54, 9912, 28000, }, { 61, 26984, 39000, }, { 69, 26985, 90000, }, { 74, 48459, 200000, }, { 79, 48461, 200000, }, },
		{ name = "治疗之触", { 1, 5185, 0, }, { 8, 5186, 200, }, { 14, 5187, 900, }, { 20, 5188, 2000, }, { 26, 5189, 4500, }, { 32, 6778, 8000, }, { 38, 8903, 12000, }, { 44, 9758, 18000, }, { 50, 9888, 23000, }, { 56, 9889, 30000, }, { 60, 25297, 34000, }, { 62, 26978, 43000, }, { 69, 26979, 90000, }, { 74, 48377, 200000, }, { 79, 48378, 200000, }, },
		{ name = "野性印记", { 1, 1126, 10, }, { 10, 5232, 300, }, { 20, 6756, 2000, }, { 30, 5234, 6000, }, { 40, 8907, 14000, }, { 50, 9884, 23000, }, { 60, 9885, 34000, }, { 70, 26990, 100000, }, { 80, 48469, 200000, }, },
		{ name = "回春术", { 4, 774, 100, }, { 10, 1058, 300, }, { 16, 1430, 1800, }, { 22, 2090, 3000, }, { 28, 2091, 5000, }, { 34, 3627, 10000, }, { 40, 8910, 14000, }, { 46, 9839, 20000, }, { 52, 9840, 26000, }, { 58, 9841, 32000, }, { 60, 25299, 34000, }, { 63, 26981, 48000, }, { 69, 26982, 90000, }, { 75, 48440, 200000, }, { 80, 48441, 200000, }, },
		{ name = "月火术", { 4, 8921, 100, }, { 10, 8924, 300, }, { 16, 8925, 1800, }, { 22, 8926, 3000, }, { 28, 8927, 5000, }, { 34, 8928, 10000, }, { 40, 8929, 14000, }, { 46, 9833, 20000, }, { 52, 9834, 26000, }, { 58, 9835, 32000, }, { 63, 26987, 48000, }, { 70, 26988, 100000, }, { 75, 48462, 200000, }, { 80, 48463, 200000, }, },
		{ name = "荆棘术", { 6, 467, 100, }, { 14, 782, 900, }, { 24, 1075, 4000, }, { 34, 8914, 10000, }, { 44, 9756, 18000, }, { 54, 9910, 28000, }, { 64, 26992, 53000, }, { 74, 53307, 200000, }, },
		{ name = "纠缠根须", { 8, 339, 200, }, { 18, 1062, 1900, }, { 28, 5195, 5000, }, { 38, 5196, 12000, }, { 48, 9852, 22000, }, { 58, 9853, 32000, }, { 68, 26989, 81000, }, { 78, 53308, 200000, }, },
		{ name = "重殴", { 10, 6807, 0, }, { 18, 6808, 1900, }, { 26, 6809, 4500, }, { 34, 8972, 10000, }, { 42, 9745, 16000, }, { 50, 9880, 23000, }, { 58, 9881, 32000, }, { 67, 26996, 73000, }, { 73, 48479, 200000, }, { 79, 48480, 200000, }, },
		{ name = "自然之握", { 10, 16689, 300, }, { 18, 16810, 1900, }, { 28, 16811, 5000, }, { 38, 16812, 12000, }, { 48, 16813, 22000, }, { 58, 17329, 32000, }, { 68, 27009, 81000, }, { 78, 53312, 200000, }, },
		{ name = "挫志咆哮", { 10, 99, 300, }, { 20, 1735, 2000, }, { 32, 9490, 8000, }, { 42, 9747, 16000, }, { 52, 9898, 26000, }, { 62, 26998, 43000, }, { 71, 48559, 200000, }, { 77, 48560, 200000, }, },
		{ name = "激怒", { 12, 5229, 800, }, },
		{ name = "愈合", { 12, 8936, 800, }, { 18, 8938, 1900, }, { 24, 8939, 4000, }, { 30, 8940, 6000, }, { 36, 8941, 11000, }, { 42, 9750, 16000, }, { 48, 9856, 22000, }, { 54, 9857, 28000, }, { 60, 9858, 34000, }, { 65, 26980, 59000, }, { 71, 48442, 200000, }, { 77, 48443, 200000, }, },
		{ name = "起死回生", { 12, 50769, 800, }, { 24, 50768, 4000, }, { 36, 50767, 11000, }, { 48, 50766, 22000, }, { 60, 50765, 34000, }, { 69, 50764, 90000, }, { 80, 50763, 200000, }, },
		{ name = "猛击", { 14, 5211, 900, }, { 30, 6798, 6000, }, { 46, 8983, 20000, }, },
		{ name = "水栖形态", { 16, 1066, 900, }, },
		{ name = "旅行形态", { 16, 783, 1800, }, },
		{ name = "横扫（熊）", { 16, 779, 1800, }, { 24, 780, 4000, }, { 34, 769, 10000, }, { 44, 9754, 18000, }, { 54, 9908, 28000, }, { 64, 26997, 53000, }, { 72, 48561, 200000, }, { 77, 48562, 200000, }, },
		{ name = "精灵之火（野性）", { 18, 16857, 1900, }, },
		{ name = "精灵之火", { 18, 770, 1900, }, },
		{ name = "休眠", { 18, 2637, 1900, }, { 38, 18657, 12000, }, { 58, 18658, 32000, }, },
		{ name = "潜行", { 20, 5215, 2000, }, },
		{ name = "猎豹形态", { 20, 768, 2000, }, },
		{ name = "星火术", { 20, 2912, 2000, }, { 26, 8949, 4500, }, { 34, 8950, 10000, }, { 42, 8951, 16000, }, { 50, 9875, 23000, }, { 58, 9876, 32000, }, { 60, 25298, 34000, }, { 67, 26986, 73000, }, { 72, 48464, 200000, }, { 78, 48465, 200000, }, },
		{ name = "割裂", { 20, 1079, 2000, }, { 28, 9492, 5000, }, { 36, 9493, 11000, }, { 44, 9752, 18000, }, { 52, 9894, 26000, }, { 60, 9896, 34000, }, { 67, 27008, 73000, }, { 71, 49799, 200000, }, { 80, 49800, 200000, }, },
		{ name = "爪击", { 20, 1082, 2000, }, { 28, 3029, 5000, }, { 38, 5201, 12000, }, { 48, 9849, 22000, }, { 58, 9850, 32000, }, { 67, 27000, 73000, }, { 73, 48569, 200000, }, { 79, 48570, 200000, }, },
		{ name = "复生", { 20, 20484, 2000, }, { 30, 20739, 6000, }, { 40, 20742, 14000, }, { 50, 20747, 23000, }, { 60, 20748, 34000, }, { 69, 26994, 90000, }, { 79, 48477, 200000, }, },
		{ name = "撕碎", { 22, 5221, 3000, }, { 30, 6800, 6000, }, { 38, 8992, 12000, }, { 46, 9829, 20000, }, { 54, 9830, 28000, }, { 61, 27001, 39000, }, { 70, 27002, 100000, }, { 75, 48571, 200000, }, { 80, 48572, 200000, }, },
		{ name = "安抚动物", { 22, 2908, 3000, }, { 38, 8955, 12000, }, { 54, 9901, 28000, }, { 70, 26995, 100000, }, },
		{ name = "解除诅咒", { 24, 2782, 4000, }, },
		{ name = "斜掠", { 24, 1822, 4000, }, { 34, 1823, 10000, }, { 44, 1824, 18000, }, { 54, 9904, 28000, }, { 64, 27003, 53000, }, { 72, 48573, 200000, }, { 78, 48574, 200000, }, },
		{ name = "猛虎之怒", { 24, 5217, 4000, }, { 36, 6793, 11000, }, { 48, 9845, 22000, }, { 60, 9846, 34000, }, { 71, 50212, 200000, }, { 79, 50213, 200000, }, },
		{ name = "驱毒术", { 26, 2893, 4500, }, },
		{ name = "急奔", { 26, 1850, 4500, }, { 46, 9821, 20000, }, { 65, 33357, 59000, }, },
		{ name = "挑战咆哮", { 28, 5209, 5000, }, },
		{ name = "畏缩", { 28, 8998, 5000, }, { 40, 9000, 14000, }, { 52, 9892, 26000, }, { 60, 31709, 34000, }, { 69, 27004, 90000, }, { 76, 48575, 200000, }, },
		{ name = "宁静", { 30, 740, 6000, }, { 40, 8918, 14000, }, { 50, 9862, 23000, }, { 60, 9863, 34000, }, { 70, 26983, 100000, }, { 75, 48446, 200000, }, { 80, 48447, 200000, }, },
		{ name = "追踪人型生物", { 32, 5225, 8000, }, },
		{ name = "凶猛撕咬", { 32, 22568, 8000, }, { 40, 22827, 14000, }, { 48, 22828, 22000, }, { 56, 22829, 30000, }, { 60, 31018, 30000, }, { 63, 24248, 48000, }, { 72, 48576, 200000, }, { 78, 48577, 200000, }, },
		{ name = "毁灭", { 32, 6785, 8000, }, { 42, 6787, 16000, }, { 50, 9866, 23000, }, { 58, 9867, 32000, }, { 66, 27005, 66000, }, { 73, 48578, 200000, }, { 79, 48579, 200000, }, },
		{ name = "狂暴回复", { 36, 22842, 11000, }, },
		{ name = "突袭", { 36, 9005, 11000, }, { 46, 9823, 20000, }, { 56, 9827, 30000, }, { 66, 27006, 66000, }, { 77, 49803, 200000, }, },
		{ name = "巨熊形态", { 40, 9634, 14000, }, },
		{ name = "野蛮防御", { 40, 62600, 4500, }, },
		{ name = "豹之优雅", { 40, 20719, 14000, }, },
		{ name = "激活", { 40, 29166, 14000, }, },
		{ name = "飓风", { 40, 16914, 14000, }, { 50, 17401, 23000, }, { 60, 17402, 34000, }, { 70, 27012, 100000, }, { 80, 48467, 200000, }, },
		{ name = "树皮术", { 44, 22812, 18000, }, },
		{ name = "野性赐福", { 50, 21849, 23000, }, { 60, 21850, 34000, }, { 70, 26991, 100000, }, { 80, 48470, 200000, }, },
		{ name = "飞行形态", { 60, 33943, 34000, }, },
		{ name = "割碎", { 62, 22570, 43000, }, { 74, 49802, 200000, }, },
		{ name = "生命绽放", { 64, 33763, 53000, }, { 72, 48450, 200000, }, { 80, 48451, 200000, }, },
		{ name = "割伤", { 66, 33745, 66000, }, { 73, 48567, 200000, }, { 80, 48568, 200000, }, },
		{ name = "旋风", { 70, 33786, 100000, }, },
		{ name = "迅捷飞行形态", { 71, 40120, 200000, }, },
		{ name = "横扫（豹）", { 71, 62078, 200000, }, },
		{ name = "野蛮咆哮", { 75, 52610, 200000, }, },
		{ name = "滋养", { 80, 50464, 200000, }, },
		{ name = "虫群", { -1, 5570, 0, }, { 30, 24974, 6000, }, { 40, 24975, 14000, }, { 50, 24976, 12000, }, { 60, 24977, 34000, }, { 70, 27013, 200000, }, { 80, 48468, 200000, }, talent = true, },
		{ name = "裂伤（熊）", { -1, 33878, 0, nil, 33917, }, { 58, 33986, 1700, }, { 68, 33987, 1900, }, { 75, 48563, 10000, }, { 80, 48564, 10000, }, talent = true, require = 33917, },
		{ name = "裂伤（豹）", { -1, 33876, 0, nil, 33917, }, { 58, 33982, 1700, }, { 68, 33983, 1700, }, { 75, 48565, 10000, }, { 80, 48566, 10000, }, talent = true, require = 33917, },
		{ name = "台风", { -1, 50516, 0, }, { 60, 53223, 600, }, { 70, 53225, 1700, }, { 75, 53226, 10000, }, { 80, 61384, 10000, }, talent = true, },
		{ name = "野性成长", { -1, 48438, 0, }, { 70, 53248, 1700, }, { 75, 53249, 10000, }, { 80, 53251, 10000, }, talent = true, },
		{ name = "星辰坠落", { -1, 48505, 0, }, { 70, 53199, 10000, }, { 75, 53200, 10000, }, { 80, 53201, 10000, }, talent = true, },
		{ name = "迅捷治愈", { -1, 18562, 0, }, talent = true, },
		{ name = "生存本能", { -1, 61336, 0, }, talent = true, },
		{ name = "裂伤", { -1, 33917, 0, }, talent = true, },
		{ name = "自然之力", { -1, 33831, 0, }, talent = true, },
		{ name = "枭兽形态", { -1, 24858, 0, }, talent = true, },
		{ name = "狂暴", { -1, 50334, 0, }, talent = true, },
		{ name = "自然迅捷", { -1, 17116, 0, }, talent = true, },
		{ name = "野性冲锋", { -1, 49377, 0, }, talent = true, },
		{ name = "生命之树", { -1, 65139, 0, }, talent = true, },
	},
	HUNTER = {
		{ name = "追踪野兽", { 1, 1494, 10, }, },
		{ name = "自动射击", { 1, 75, 0, }, },
		{ name = "猛禽一击", { 1, 2973, 0, }, { 8, 14260, 200, }, { 16, 14261, 1800, }, { 24, 14262, 7000, }, { 32, 14263, 10000, }, { 40, 14264, 18000, }, { 48, 14265, 32000, }, { 56, 14266, 46000, }, { 63, 27014, 87000, }, { 71, 48995, 300000, }, { 77, 48996, 300000, }, },
		{ name = "灵猴守护", { 4, 13163, 100, }, },
		{ name = "毒蛇钉刺", { 4, 1978, 100, }, { 10, 13549, 400, }, { 18, 13550, 2000, }, { 26, 13551, 7000, }, { 34, 13552, 12000, }, { 42, 13553, 24000, }, { 50, 13554, 36000, }, { 58, 13555, 48000, }, { 60, 25295, 50000, }, { 67, 27016, 140000, }, { 73, 49000, 300000, }, { 79, 49001, 300000, }, },
		{ name = "奥术射击", { 6, 3044, 100, }, { 12, 14281, 600, }, { 20, 14282, 2200, }, { 28, 14283, 8000, }, { 36, 14284, 14000, }, { 44, 14285, 26000, }, { 52, 14286, 40000, }, { 60, 14287, 50000, }, { 69, 27019, 170000, }, { 73, 49044, 300000, }, { 79, 49045, 300000, }, },
		{ name = "猎人印记", { 6, 1130, 100, }, { 22, 14323, 6000, }, { 40, 14324, 18000, }, { 58, 14325, 48000, }, { 76, 53338, 10000, }, },
		{ name = "招架", { 8, 3127, 200, }, },
		{ name = "震荡射击", { 8, 5116, 200, }, },
		{ name = "追踪人型生物", { 10, 19883, 400, }, },
		{ name = "雄鹰守护", { 10, 13165, 400, }, { 18, 14318, 2000, }, { 28, 14319, 8000, }, { 38, 14320, 16000, }, { 48, 14321, 32000, }, { 58, 14322, 48000, }, { 60, 25296, 50000, }, { 68, 27044, 150000, }, },
		{ name = "扰乱射击", { 12, 20736, 600, }, },
		{ name = "摔绊", { 12, 2974, 600, }, },
		{ name = "治疗宠物", { 12, 136, 600, }, { 20, 3111, 2200, }, { 28, 3661, 8000, }, { 36, 3662, 14000, }, { 44, 13542, 26000, }, { 52, 13543, 40000, }, { 60, 13544, 50000, }, { 68, 27046, 150000, }, { 74, 48989, 300000, }, { 80, 48990, 300000, }, },
		{ name = "野兽之眼", { 14, 1002, 1200, }, },
		{ name = "鹰眼术", { 14, 6197, 1200, }, },
		{ name = "恐吓野兽", { 14, 1513, 1200, }, { 30, 14326, 8000, }, { 46, 14327, 28000, }, },
		{ name = "猎豹守护", { 16, 5118, 1800, }, },
		{ name = "献祭陷阱", { 16, 13795, 1800, }, { 26, 14302, 7000, }, { 36, 14303, 14000, }, { 46, 14304, 28000, }, { 56, 14305, 46000, }, { 65, 27023, 110000, }, { 72, 49055, 300000, }, { 78, 49056, 300000, }, },
		{ name = "猫鼬撕咬", { 16, 1495, 1800, }, { 30, 14269, 8000, }, { 44, 14270, 26000, }, { 58, 14271, 48000, }, { 70, 36916, 300000, }, { 80, 53339, 300000, }, },
		{ name = "追踪亡灵", { 18, 19884, 2000, }, },
		{ name = "多重射击", { 18, 2643, 2000, }, { 30, 14288, 8000, }, { 42, 14289, 24000, }, { 54, 14290, 42000, }, { 60, 25294, 50000, }, { 67, 27021, 140000, }, { 74, 49047, 300000, }, { 80, 49048, 300000, }, },
		{ name = "蝰蛇守护", { 20, 34074, 2200, }, },
		{ name = "逃脱", { 20, 781, 2200, }, },
		{ name = "双武器", { 20, 674, 2200, }, },
		{ name = "冰冻陷阱", { 20, 1499, 2200, }, { 40, 14310, 18000, }, { 60, 14311, 50000, }, },
		{ name = "毒蝎钉刺", { 22, 3043, 6000, }, },
		{ name = "追踪隐藏生物", { 24, 19885, 7000, }, },
		{ name = "野兽知识", { 24, 1462, 7000, }, },
		{ name = "追踪元素生物", { 26, 19880, 7000, }, },
		{ name = "急速射击", { 26, 3045, 7000, }, },
		{ name = "冰霜陷阱", { 28, 13809, 8000, }, },
		{ name = "假死", { 30, 5384, 8000, }, },
		{ name = "野兽守护", { 30, 13161, 8000, }, },
		{ name = "照明弹", { 32, 1543, 10000, }, },
		{ name = "追踪恶魔", { 32, 19878, 10000, }, },
		{ name = "爆炸陷阱", { 34, 13813, 12000, }, { 44, 14316, 26000, }, { 54, 14317, 42000, }, { 61, 27025, 68000, }, { 71, 49066, 300000, }, { 77, 49067, 300000, }, },
		{ name = "蝰蛇钉刺", { 36, 3034, 14000, }, },
		{ name = "豹群守护", { 40, 13159, 18000, }, },
		{ name = "追踪巨人", { 40, 19882, 18000, }, },
		{ name = "锁甲", { 40, 8737, 18000, }, },
		{ name = "乱射", { 40, 1510, 18000, }, { 50, 14294, 36000, }, { 58, 14295, 48000, }, { 67, 27022, 140000, }, { 74, 58431, 300000, }, { 80, 58434, 300000, }, },
		{ name = "野性守护", { 46, 20043, 28000, }, { 56, 20190, 46000, }, { 68, 27045, 150000, }, { 76, 49071, 300000, }, },
		{ name = "追踪龙类", { 50, 19879, 36000, }, },
		{ name = "稳固射击", { 50, 56641, 36000, }, { 62, 34120, 70000, }, { 71, 49051, 300000, }, { 77, 49052, 300000, }, },
		{ name = "威慑", { 60, 19263, 2200, }, },
		{ name = "宁神射击", { 60, 19801, 50000, }, },
		{ name = "杀戮命令", { 66, 34026, 120000, }, },
		{ name = "毒蛇陷阱", { 68, 34600, 150000, }, },
		{ name = "误导", { 70, 34477, 190000, }, },
		{ name = "杀戮射击", { 71, 53351, 300000, }, { 75, 61005, 300000, }, { 80, 61006, 300000, }, },
		{ name = "龙鹰守护", { 74, 61846, 300000, }, { 80, 61847, 300000, }, },
		{ name = "主人的召唤", { 75, 53271, 10000, }, },
		{ name = "陷阱发射器：爆炸陷阱", { 77, 425777, 300000, }, },
		{ name = "召唤兽栏宠物", { 80, 62757, 300000, }, },
		{ name = "冰冻之箭", { 80, 60192, 100000, }, },
		{ name = "瞄准射击", { -1, 19434, 0, }, { 28, 20900, 400, }, { 36, 20901, 700, }, { 44, 20902, 1300, }, { 52, 20903, 2000, }, { 60, 20904, 2500, }, { 70, 27065, 10000, }, { 75, 49049, 10000, }, { 80, 49050, 10000, }, talent = true, },
		{ name = "反击", { -1, 19306, 0, }, { 42, 20909, 1200, }, { 54, 20910, 2100, }, { 66, 27067, 46000, }, { 72, 48998, 10000, }, { 78, 48999, 15000, }, talent = true, },
		{ name = "翼龙钉刺", { -1, 19386, 0, }, { 50, 24132, 1800, }, { 60, 24133, 2500, }, { 70, 27068, 5000, }, { 75, 49011, 100000, }, { 80, 49012, 100000, }, talent = true, },
		{ name = "黑箭", { -1, 3674, 0, }, { 57, 63668, 1800, }, { 63, 63669, 7000, }, { 69, 63670, 10000, }, { 75, 63671, 10000, }, { 80, 63672, 10000, }, talent = true, },
		{ name = "爆炸射击", { -1, 53301, 0, }, { 70, 60051, 400, }, { 75, 60052, 400, }, { 80, 60053, 100000, }, talent = true, },
		{ name = "准备就绪", { -1, 23989, 0, }, talent = true, },
		{ name = "狂野怒火", { -1, 19574, 0, }, talent = true, },
		{ name = "胁迫", { -1, 19577, 0, }, talent = true, },
		{ name = "强击光环", { -1, 19506, 0, }, talent = true, },
		{ name = "奇美拉射击", { -1, 53209, 0, }, talent = true, },
		{ name = "驱散射击", { -1, 19503, 0, }, talent = true, },
		{ name = "沉默射击", { -1, 34490, 0, }, talent = true, },
	},
	MAGE = {
		{ name = "火球术", { 1, 133, 0, }, { 6, 143, 100, }, { 12, 145, 600, }, { 18, 3140, 1800, }, { 24, 8400, 4000, }, { 30, 8401, 8000, }, { 36, 8402, 13000, }, { 42, 10148, 18000, }, { 48, 10149, 28000, }, { 54, 10150, 36000, }, { 60, 10151, 42000, }, { 62, 25306, 42000, }, { 66, 27070, 78000, }, { 70, 38692, 150000, }, { 74, 42832, 150000, }, { 78, 42833, 150000, }, },
		{ name = "霜甲术", { 1, 168, 0, }, { 10, 7300, 400, }, { 20, 7301, 2000, }, },
		{ name = "奥术智慧", { 1, 1459, 10, }, { 14, 1460, 900, }, { 28, 1461, 7000, }, { 42, 10156, 18000, }, { 56, 10157, 38000, }, { 70, 27126, 120000, }, { 80, 42995, 150000, }, },
		{ name = "寒冰箭", { 4, 116, 100, }, { 8, 205, 200, }, { 14, 837, 900, }, { 20, 7322, 2000, }, { 26, 8406, 5000, }, { 32, 8407, 10000, }, { 38, 8408, 14000, }, { 44, 10179, 23000, }, { 50, 10180, 32000, }, { 56, 10181, 38000, }, { 60, 25304, 42000, }, { 63, 27071, 57000, }, { 69, 27072, 110000, }, { 70, 38697, 150000, }, { 75, 42841, 150000, }, { 79, 42842, 150000, }, },
		{ name = "造水术", { 4, 5504, 100, }, { 10, 5505, 400, }, { 20, 5506, 2000, }, { 30, 6127, 8000, }, { 40, 10138, 15000, }, { 50, 10139, 32000, }, { 60, 10140, 42000, }, { 65, 37420, 70000, }, { 70, 27090, 150000, }, },
		{ name = "造食术", { 6, 587, 100, }, { 12, 597, 600, }, { 22, 990, 3000, }, { 32, 6129, 10000, }, { 42, 10144, 18000, }, { 52, 10145, 35000, }, { 60, 28612, 42000, }, { 70, 33717, 150000, }, },
		{ name = "火焰冲击", { 6, 2136, 100, }, { 14, 2137, 900, }, { 22, 2138, 3000, }, { 30, 8412, 8000, }, { 38, 8413, 14000, }, { 46, 10197, 26000, }, { 54, 10199, 36000, }, { 61, 27078, 46000, }, { 70, 27079, 120000, }, { 74, 42872, 150000, }, { 80, 42873, 150000, }, },
		{ name = "奥术飞弹", { 8, 5143, 200, }, { 16, 5144, 1500, }, { 24, 5145, 4000, }, { 32, 8416, 10000, }, { 40, 8417, 15000, }, { 48, 10211, 28000, }, { 56, 10212, 38000, }, { 60, 25345, 42000, }, { 63, 27075, 57000, }, { 69, 38699, 87000, }, { 70, 38704, 100000, }, { 75, 42843, 150000, }, { 79, 42846, 150000, }, },
		{ name = "变形术", { 8, 118, 200, }, { 20, 12824, 2000, }, { 40, 12825, 15000, }, { 60, 12826, 42000, }, },
		{ name = "冰霜新星", { 10, 122, 400, }, { 26, 865, 5000, }, { 40, 6131, 15000, }, { 54, 10230, 36000, }, { 67, 27088, 87000, }, { 75, 42917, 150000, }, },
		{ name = "缓落术", { 12, 130, 600, }, },
		{ name = "魔法抑制", { 12, 604, 600, }, { 24, 8450, 4000, }, { 36, 8451, 13000, }, { 48, 10173, 28000, }, { 60, 10174, 42000, }, { 67, 33944, 100000, }, { 76, 43015, 150000, }, },
		{ name = "魔爆术", { 14, 1449, 900, }, { 22, 8437, 3000, }, { 30, 8438, 8000, }, { 38, 8439, 14000, }, { 46, 10201, 26000, }, { 54, 10202, 36000, }, { 62, 27080, 51000, }, { 70, 27082, 120000, }, { 76, 42920, 150000, }, { 80, 42921, 150000, }, },
		{ name = "烈焰风暴", { 16, 2120, 1500, }, { 24, 2121, 4000, }, { 32, 8422, 10000, }, { 40, 8423, 15000, }, { 48, 10215, 28000, }, { 56, 10216, 38000, }, { 64, 27086, 63000, }, { 72, 42925, 150000, }, { 79, 42926, 150000, }, },
		{ name = "解除诅咒", { 18, 475, 1800, }, },
		{ name = "魔法增效", { 18, 1008, 1800, }, { 30, 8455, 8000, }, { 42, 10169, 18000, }, { 54, 10170, 36000, }, { 63, 27130, 57000, }, { 69, 33946, 110000, }, { 77, 43017, 150000, }, },
		{ name = "传送：暴风城", { 20, 3561, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：铁炉堡", { 20, 3562, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：埃索达", { 20, 32271, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：奥格瑞玛", { 20, 3567, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：幽暗城", { 20, 3563, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送：银月城", { 20, 32272, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "唤醒", { 20, 12051, 2000, }, },
		{ name = "闪现术", { 20, 1953, 2000, }, },
		{ name = "法力护盾", { 20, 1463, 2000, }, { 28, 8494, 7000, }, { 36, 8495, 13000, }, { 44, 10191, 23000, }, { 52, 10192, 35000, }, { 60, 10193, 42000, }, { 68, 27131, 96000, }, { 73, 43019, 150000, }, { 79, 43020, 150000, }, },
		{ name = "暴风雪", { 20, 10, 2000, }, { 28, 6141, 7000, }, { 36, 8427, 13000, }, { 44, 10185, 23000, }, { 52, 10186, 35000, }, { 60, 10187, 42000, }, { 68, 27085, 96000, }, { 74, 42939, 150000, }, { 80, 42940, 150000, }, },
		{ name = "防护火焰结界", { 20, 543, 2000, }, { 30, 8457, 8000, }, { 40, 8458, 15000, }, { 50, 10223, 32000, }, { 60, 10225, 42000, }, { 69, 27128, 110000, }, { 78, 43010, 150000, }, },
		{ name = "灼烧", { 22, 2948, 3000, }, { 28, 8444, 7000, }, { 34, 8445, 12000, }, { 40, 8446, 15000, }, { 46, 10205, 26000, }, { 52, 10206, 35000, }, { 58, 10207, 40000, }, { 65, 27073, 70000, }, { 70, 27074, 120000, }, { 73, 42858, 150000, }, { 78, 42859, 150000, }, },
		{ name = "防护冰霜结界", { 22, 6143, 3000, }, { 32, 8461, 10000, }, { 42, 8462, 18000, }, { 52, 10177, 35000, }, { 60, 28609, 42000, }, { 70, 32796, 120000, }, { 79, 43012, 150000, }, },
		{ name = "法术反制", { 24, 2139, 4000, }, },
		{ name = "冰锥术", { 26, 120, 5000, }, { 34, 8492, 12000, }, { 42, 10159, 18000, }, { 50, 10160, 32000, }, { 58, 10161, 40000, }, { 65, 27087, 70000, }, { 72, 42930, 150000, }, { 79, 42931, 150000, }, },
		{ name = "制造法力宝石", { 28, 759, 7000, }, { 38, 3552, 14000, }, { 48, 10053, 28000, }, { 58, 10054, 40000, }, { 68, 27101, 96000, }, { 77, 42985, 150000, }, },
		{ name = "传送：达纳苏斯", { 30, 3565, 8000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：雷霆崖", { 30, 3566, 8000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "寒冰屏障", { 30, 45438, 8000, }, },
		{ name = "冰甲术", { 30, 7302, 8000, }, { 40, 7320, 15000, }, { 50, 10219, 32000, }, { 60, 10220, 42000, }, { 69, 27124, 110000, }, { 79, 43008, 150000, }, },
		{ name = "法师护甲", { 34, 6117, 13000, }, { 46, 22782, 26000, }, { 58, 22783, 40000, }, { 69, 27125, 110000, }, { 71, 43023, 150000, }, { 79, 43024, 150000, }, },
		{ name = "传送：塞拉摩", { 35, 49359, 2000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：塞拉摩", { 35, 49360, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：斯通纳德", { 35, 49358, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：斯通纳德", { 35, 49361, 2000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：暴风城", { 40, 10059, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：铁炉堡", { 40, 11416, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：埃索达", { 40, 32266, 15000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：奥格瑞玛", { 40, 11417, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：银月城", { 40, 32267, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：幽暗城", { 40, 11418, 15000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "传送门：达纳苏斯", { 50, 11419, 32000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：雷霆崖", { 50, 11420, 32000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "奥术光辉", { 56, 23028, 38000, }, { 70, 27127, 100000, }, { 80, 43002, 150000, }, },
		{ name = "传送：沙塔斯", { 60, 33690, 20000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送：沙塔斯", { 60, 35715, 20000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "熔岩护甲", { 62, 30482, 51000, }, { 71, 43045, 150000, }, { 79, 43046, 150000, }, },
		{ name = "奥术冲击", { 64, 30451, 63000, }, { 71, 42894, 150000, }, { 76, 42896, 150000, }, { 80, 42897, 150000, }, },
		{ name = "传送门：沙塔斯", { 65, 33691, 150000, }, race = "HUMAN|DWARF|NIGHTELF|GNOME|DRAENEI", },
		{ name = "传送门：沙塔斯", { 65, 35717, 150000, }, race = "ORC|SCOURGE|TAUREN|TROLL|BLOODELF", },
		{ name = "冰枪术", { 66, 30455, 78000, }, { 72, 42913, 150000, }, { 78, 42914, 150000, }, },
		{ name = "隐形术", { 68, 66, 96000, }, },
		{ name = "法术吸取", { 70, 30449, 120000, }, },
		{ name = "召唤餐桌", { 70, 43987, 120000, }, { 80, 58659, 150000, }, },
		{ name = "传送：沙塔斯", { 71, 53140, 100000, }, },
		{ name = "传送门：沙塔斯", { 74, 53142, 100000, }, },
		{ name = "霜火之箭", { 75, 44614, 150000, }, { 80, 47610, 150000, }, },
		{ name = "造餐术", { 75, 42955, 150000, }, { 80, 42956, 150000, }, },
		{ name = "镜像", { 80, 55342, 150000, }, },
		{ name = "炎爆术", { -1, 11366, 0, }, { 24, 12505, 100, }, { 30, 12522, 400, }, { 36, 12523, 650, }, { 42, 12524, 900, }, { 48, 12525, 1400, }, { 54, 12526, 1800, }, { 60, 18809, 2100, }, { 66, 27132, 3900, }, { 70, 33938, 7500, }, { 73, 42890, 7500, }, { 77, 42891, 7500, }, talent = true, },
		{ name = "冲击波", { -1, 11113, 0, }, { 36, 13018, 400, }, { 44, 13019, 1150, }, { 52, 13020, 1750, }, { 60, 13021, 2100, }, { 65, 27133, 3500, }, { 70, 33933, 6000, }, { 75, 42944, 7500, }, { 80, 42945, 7500, }, talent = true, },
		{ name = "寒冰护体", { -1, 11426, 0, }, { 46, 13031, 1700, }, { 52, 13032, 1750, }, { 58, 13033, 2000, }, { 64, 27134, 2500, }, { 70, 33405, 6000, }, { 75, 43038, 7500, }, { 80, 43039, 7500, }, talent = true, },
		{ name = "龙息术", { -1, 31661, 0, }, { 56, 33041, 1900, }, { 64, 33042, 2200, }, { 70, 33043, 2500, }, { 75, 42949, 7500, }, { 80, 42950, 7500, }, talent = true, },
		{ name = "活动炸弹", { -1, 44457, 0, }, { 70, 55359, 5000, }, { 80, 55360, 7500, }, talent = true, },
		{ name = "奥术弹幕", { -1, 44425, 0, }, { 70, 44780, 10000, }, { 80, 44781, 15000, }, talent = true, },
		{ name = "急速冷却", { -1, 11958, 0, }, talent = true, },
		{ name = "奥术强化", { -1, 12042, 0, }, talent = true, },
		{ name = "召唤水元素", { -1, 31687, 0, }, talent = true, },
		{ name = "冰冷血脉", { -1, 12472, 0, }, talent = true, },
		{ name = "专注魔法", { -1, 54646, 0, }, talent = true, },
		{ name = "深度冻结", { -1, 44572, 0, }, talent = true, },
		{ name = "减速", { -1, 31589, 0, }, talent = true, },
		{ name = "气定神闲", { -1, 12043, 0, }, talent = true, },
		{ name = "燃烧", { -1, 11129, 0, }, talent = true, },
	},
	PALADIN = {
		{ name = "正义圣印", { 1, 20154, 0, }, },
		{ name = "圣光术", { 1, 635, 0, }, { 6, 639, 100, }, { 14, 647, 2000, }, { 22, 1026, 4000, }, { 30, 1042, 11000, }, { 38, 3472, 16000, }, { 46, 10328, 24000, }, { 54, 10329, 40000, }, { 60, 25292, 46000, }, { 62, 27135, 55000, }, { 70, 27136, 130000, }, { 75, 48781, 200000, }, { 80, 48782, 200000, }, },
		{ name = "虔诚光环", { 1, 465, 10, }, { 10, 10290, 300, }, { 20, 643, 4000, }, { 30, 10291, 11000, }, { 40, 1032, 20000, }, { 50, 10292, 28000, }, { 60, 10293, 46000, }, { 70, 27149, 130000, }, { 74, 48941, 200000, }, { 79, 48942, 200000, }, },
		{ name = "圣光审判", { 4, 20271, 100, }, },
		{ name = "力量祝福", { 4, 19740, 100, }, { 12, 19834, 1000, }, { 22, 19835, 4000, }, { 32, 19836, 12000, }, { 42, 19837, 21000, }, { 52, 19838, 34000, }, { 60, 25291, 50000, }, { 70, 27140, 200000, }, { 73, 48931, 200000, }, { 79, 48932, 200000, }, },
		{ name = "圣佑术", { 6, 498, 100, }, },
		{ name = "招架", { 8, 3127, 100, }, },
		{ name = "纯净术", { 8, 1152, 100, }, },
		{ name = "制裁之锤", { 8, 853, 100, }, { 24, 5588, 5000, }, { 40, 5589, 20000, }, { 54, 10308, 40000, }, },
		{ name = "保护之手", { 10, 1022, 300, }, { 24, 5599, 5000, }, { 38, 10278, 16000, }, },
		{ name = "圣疗术", { 10, 633, 300, }, { 30, 2800, 11000, }, { 50, 10310, 28000, }, { 69, 27154, 110000, }, { 78, 48788, 200000, }, },
		{ name = "智慧审判", { 12, 53408, 1000, }, },
		{ name = "救赎", { 12, 7328, 0, }, { 24, 10322, 5000, }, { 36, 10324, 14000, }, { 48, 20772, 26000, }, { 60, 20773, 46000, }, { 72, 48949, 200000, }, { 79, 48950, 200000, }, },
		{ name = "正义防御", { 14, 31789, 4000, }, },
		{ name = "智慧祝福", { 14, 19742, 2000, }, { 24, 19850, 5000, }, { 34, 19852, 13000, }, { 44, 19853, 22000, }, { 54, 19854, 40000, }, { 60, 25290, 50000, }, { 65, 27142, 75000, }, { 71, 48935, 200000, }, { 77, 48936, 200000, }, },
		{ name = "正义之怒", { 16, 25780, 3000, }, },
		{ name = "清算之手", { 16, 62124, 3000, }, },
		{ name = "惩戒光环", { 16, 7294, 3000, }, { 26, 10298, 6000, }, { 36, 10299, 14000, }, { 46, 10300, 24000, }, { 56, 10301, 42000, }, { 66, 27150, 83000, }, { 76, 54043, 200000, }, },
		{ name = "自由之手", { 18, 1044, 3500, }, },
		{ name = "王者祝福", { 20, 20217, 4000, }, },
		{ name = "感知亡灵", { 20, 5502, 4000, }, },
		{ name = "圣光闪现", { 20, 19750, 4000, }, { 26, 19939, 6000, }, { 34, 19940, 13000, }, { 42, 19941, 21000, }, { 50, 19942, 28000, }, { 58, 19943, 44000, }, { 66, 27137, 83000, }, { 74, 48784, 200000, }, { 79, 48785, 200000, }, },
		{ name = "驱邪术", { 20, 879, 4000, }, { 28, 5614, 9000, }, { 36, 5615, 14000, }, { 44, 10312, 22000, }, { 52, 10313, 34000, }, { 60, 10314, 46000, }, { 68, 27138, 100000, }, { 73, 48800, 200000, }, { 79, 48801, 200000, }, },
		{ name = "奉献", { 20, 26573, 4000, }, { 30, 20116, 11000, }, { 40, 20922, 20000, }, { 50, 20923, 28000, }, { 60, 20924, 46000, }, { 70, 27173, 130000, }, { 75, 48818, 200000, }, { 80, 48819, 200000, }, },
		{ name = "专注光环", { 22, 19746, 4000, }, },
		{ name = "公正圣印", { 22, 20164, 4000, }, },
		{ name = "超度邪恶", { 24, 10326, 5000, }, },
		{ name = "拯救之手", { 26, 1038, 6000, }, },
		{ name = "公正审判", { 28, 53407, 9000, }, },
		{ name = "暗影抗性光环", { 28, 19876, 9000, }, { 40, 19895, 20000, }, { 52, 19896, 34000, }, { 63, 27151, 61000, }, { 76, 48943, 200000, }, },
		{ name = "神圣干涉", { 30, 19752, 11000, }, },
		{ name = "光明圣印", { 30, 20165, 11000, }, },
		{ name = "冰霜抗性光环", { 32, 19888, 12000, }, { 44, 19897, 22000, }, { 56, 19898, 42000, }, { 68, 27152, 100000, }, { 77, 48945, 200000, }, },
		{ name = "圣盾术", { 34, 642, 13000, }, },
		{ name = "火焰抗性光环", { 36, 19891, 14000, }, { 48, 19899, 26000, }, { 60, 19900, 46000, }, { 70, 27153, 130000, }, { 78, 48947, 200000, }, },
		{ name = "智慧圣印", { 38, 20166, 16000, }, },
		{ name = "战马", { 40, 23214, 20000, }, },
		{ name = "板甲", { 40, 750, 20000, }, },
		{ name = "清洁术", { 42, 4987, 21000, }, },
		{ name = "愤怒之锤", { 44, 24275, 22000, }, { 52, 24274, 34000, }, { 60, 24239, 46000, }, { 68, 27180, 100000, }, { 74, 48805, 200000, }, { 80, 48806, 200000, }, },
		{ name = "牺牲之手", { 46, 6940, 24000, }, },
		{ name = "神圣愤怒", { 50, 2812, 28000, }, { 60, 10318, 46000, }, { 69, 27139, 110000, }, { 72, 48816, 200000, }, { 78, 48817, 200000, }, },
		{ name = "强效力量祝福", { 52, 25782, 46000, }, { 60, 25916, 46000, }, { 70, 27141, 100000, }, { 73, 48933, 200000, }, { 79, 48934, 200000, }, },
		{ name = "强效智慧祝福", { 54, 25894, 46000, }, { 60, 25918, 46000, }, { 65, 27143, 75000, }, { 71, 48937, 200000, }, { 77, 48938, 200000, }, },
		{ name = "强效王者祝福", { 60, 25898, 2300, }, },
		{ name = "强效庇护祝福", { 60, 25899, 2300, }, },
		{ name = "十字军光环", { 62, 32223, 55000, }, },
		{ name = "复仇圣印", { 64, 31801, 67000, }, },
		{ name = "复仇之怒", { 70, 31884, 130000, }, },
		{ name = "神圣恳求", { 71, 54428, 100000, }, },
		{ name = "正义盾击", { 75, 53600, 200000, }, { 80, 61411, 200000, }, },
		{ name = "圣洁护盾", { 80, 53601, 100000, }, },
		{ name = "神圣震击", { -1, 20473, 0, }, { 48, 20929, 1300, }, { 56, 20930, 2100, }, { 64, 27174, 3350, }, { 70, 33072, 6500, }, { 75, 48824, 10000, }, { 80, 48825, 10000, }, talent = true, },
		{ name = "神圣之盾", { -1, 20925, 0, }, { 50, 20927, 1400, }, { 60, 20928, 2300, }, { 70, 27179, 6500, }, { 75, 48951, 10000, }, { 80, 48952, 10000, }, talent = true, },
		{ name = "复仇者之盾", { -1, 31935, 0, }, { 60, 32699, 2300, }, { 70, 32700, 5000, }, { 75, 48826, 10000, }, { 80, 48827, 10000, }, talent = true, },
		{ name = "正义之锤", { -1, 53595, 0, }, talent = true, },
		{ name = "忏悔", { -1, 20066, 0, }, talent = true, },
		{ name = "庇护祝福", { -1, 20911, 0, }, talent = true, },
		{ name = "圣光道标", { -1, 53563, 0, }, talent = true, },
		{ name = "光环掌握", { -1, 31821, 0, }, talent = true, },
		{ name = "神恩术", { -1, 20216, 0, }, talent = true, },
		{ name = "十字军打击", { -1, 35395, 0, }, talent = true, },
		{ name = "命令圣印", { -1, 20375, 0, }, talent = true, },
		{ name = "神启", { -1, 31842, 0, }, talent = true, },
		{ name = "神圣风暴", { -1, 53385, 0, }, talent = true, },
		{ name = "神圣牺牲", { -1, 64205, 0, }, talent = true, },
	},
	PRIEST = {
		{ name = "次级治疗术", { 1, 2050, 0, }, { 4, 2052, 100, }, { 10, 2053, 300, }, },
		{ name = "惩击", { 1, 585, 0, }, { 6, 591, 100, }, { 14, 598, 1200, }, { 22, 984, 4000, }, { 30, 1004, 10000, }, { 38, 6060, 16000, }, { 46, 10933, 26000, }, { 54, 10934, 40000, }, { 61, 25363, 53000, }, { 69, 25364, 65000, }, { 74, 48122, 180000, }, { 79, 48123, 180000, }, },
		{ name = "真言术：韧", { 1, 1243, 10, }, { 12, 1244, 800, }, { 24, 1245, 5000, }, { 36, 2791, 14000, }, { 48, 10937, 28000, }, { 60, 10938, 46000, }, { 70, 25389, 65000, }, { 80, 48161, 180000, }, },
		{ name = "暗言术：痛", { 4, 589, 100, }, { 10, 594, 300, }, { 18, 970, 2000, }, { 26, 992, 6000, }, { 34, 2767, 12000, }, { 42, 10892, 22000, }, { 50, 10893, 30000, }, { 58, 10894, 44000, }, { 65, 25367, 80000, }, { 70, 25368, 140000, }, { 75, 48124, 180000, }, { 80, 48125, 180000, }, },
		{ name = "真言术：盾", { 6, 17, 100, }, { 12, 592, 800, }, { 18, 600, 2000, }, { 24, 3747, 5000, }, { 30, 6065, 10000, }, { 36, 6066, 14000, }, { 42, 10898, 22000, }, { 48, 10899, 28000, }, { 54, 10900, 40000, }, { 60, 10901, 46000, }, { 65, 25217, 80000, }, { 70, 25218, 140000, }, { 75, 48065, 180000, }, { 80, 48066, 180000, }, },
		{ name = "渐隐术", { 8, 586, 200, }, },
		{ name = "恢复", { 8, 139, 200, }, { 14, 6074, 1200, }, { 20, 6075, 3000, }, { 26, 6076, 6000, }, { 32, 6077, 11000, }, { 38, 6078, 16000, }, { 44, 10927, 24000, }, { 50, 10928, 30000, }, { 56, 10929, 42000, }, { 60, 25315, 6500, }, { 65, 25221, 80000, }, { 70, 25222, 140000, }, { 75, 48067, 180000, }, { 80, 48068, 180000, }, },
		{ name = "心灵震爆", { 10, 8092, 300, }, { 16, 8102, 1600, }, { 22, 8103, 4000, }, { 28, 8104, 8000, }, { 34, 8105, 12000, }, { 40, 8106, 18000, }, { 46, 10945, 26000, }, { 52, 10946, 38000, }, { 58, 10947, 44000, }, { 63, 25372, 65000, }, { 69, 25375, 65000, }, { 74, 48126, 180000, }, { 79, 48127, 180000, }, },
		{ name = "复活术", { 10, 2006, 300, }, { 22, 2010, 4000, }, { 34, 10880, 12000, }, { 46, 10881, 26000, }, { 58, 20770, 44000, }, { 68, 25435, 110000, }, { 78, 48171, 180000, }, },
		{ name = "心灵之火", { 12, 588, 800, }, { 20, 7128, 3000, }, { 30, 602, 10000, }, { 40, 1006, 18000, }, { 50, 10951, 30000, }, { 60, 10952, 46000, }, { 69, 25431, 65000, }, { 71, 48040, 180000, }, { 77, 48168, 180000, }, },
		{ name = "祛病术", { 14, 528, 1200, }, },
		{ name = "心灵尖啸", { 14, 8122, 1200, }, { 28, 8124, 8000, }, { 42, 10888, 22000, }, { 56, 10890, 42000, }, },
		{ name = "治疗术", { 16, 2054, 1600, }, { 22, 2055, 4000, }, { 28, 6063, 8000, }, { 34, 6064, 12000, }, },
		{ name = "驱散魔法", { 18, 527, 2000, }, { 36, 988, 14000, }, },
		{ name = "安抚心灵", { 20, 453, 3000, }, },
		{ name = "防护恐惧结界", { 20, 6346, 800, }, },
		{ name = "神圣之火", { 20, 14914, 3000, }, { 24, 15262, 5000, }, { 30, 15263, 10000, }, { 36, 15264, 14000, }, { 42, 15265, 22000, }, { 48, 15266, 28000, }, { 54, 15267, 40000, }, { 60, 15261, 46000, }, { 66, 25384, 65000, }, { 72, 48134, 180000, }, { 78, 48135, 180000, }, },
		{ name = "快速治疗", { 20, 2061, 3000, }, { 26, 9472, 6000, }, { 32, 9473, 11000, }, { 38, 9474, 16000, }, { 44, 10915, 24000, }, { 50, 10916, 30000, }, { 56, 10917, 42000, }, { 61, 25233, 53000, }, { 67, 25235, 99000, }, { 73, 48070, 180000, }, { 79, 48071, 180000, }, },
		{ name = "噬灵疫病", { 20, 2944, 3000, }, { 28, 19276, 8000, }, { 36, 19277, 14000, }, { 44, 19278, 24000, }, { 52, 19279, 38000, }, { 60, 19280, 46000, }, { 68, 25467, 110000, }, { 73, 48299, 180000, }, { 79, 48300, 180000, }, },
		{ name = "神圣新星", { 20, 15237, 3000, }, { 28, 15430, 8000, }, { 36, 15431, 14000, }, { 44, 27799, 24000, }, { 52, 27800, 38000, }, { 60, 27801, 46000, }, { 68, 25331, 110000, }, { 75, 48077, 180000, }, { 80, 48078, 180000, }, },
		{ name = "束缚亡灵", { 20, 9484, 3000, }, { 40, 9485, 18000, }, { 60, 10955, 46000, }, },
		{ name = "心灵视界", { 22, 2096, 4000, }, { 44, 10909, 24000, }, },
		{ name = "法力燃烧", { 24, 8129, 5000, }, },
		{ name = "精神控制", { 30, 605, 10000, }, },
		{ name = "治疗祷言", { 30, 596, 10000, }, { 40, 996, 18000, }, { 50, 10960, 30000, }, { 60, 10961, 46000, }, { 60, 25316, 6500, }, { 68, 25308, 110000, }, { 76, 48072, 180000, }, },
		{ name = "神圣之灵", { 30, 14752, 600, }, { 40, 14818, 900, }, { 50, 14819, 1500, }, { 60, 27841, 2300, }, { 70, 25312, 2300, }, { 80, 48073, 9000, }, },
		{ name = "暗影防护", { 30, 976, 10000, }, { 42, 10957, 22000, }, { 56, 10958, 42000, }, { 68, 25433, 110000, }, { 76, 48169, 180000, }, },
		{ name = "驱除疾病", { 32, 552, 11000, }, },
		{ name = "漂浮术", { 34, 1706, 12000, }, },
		{ name = "强效治疗术", { 40, 2060, 18000, }, { 46, 10963, 26000, }, { 52, 10964, 38000, }, { 58, 10965, 44000, }, { 60, 25314, 65000, }, { 63, 25210, 65000, }, { 68, 25213, 110000, }, { 73, 48062, 180000, }, { 78, 48063, 180000, }, },
		{ name = "坚韧祷言", { 48, 21562, 28000, }, { 60, 21564, 46000, }, { 70, 25392, 100000, }, { 80, 48162, 180000, }, },
		{ name = "暗影防护祷言", { 56, 27683, 42000, }, { 70, 39374, 100000, }, { 77, 48170, 180000, }, },
		{ name = "精神祷言", { 60, 27681, 2300, }, { 70, 32999, 3400, }, { 80, 48074, 9000, }, },
		{ name = "暗言术：灭", { 62, 32379, 59000, }, { 70, 32996, 110000, }, { 75, 48157, 180000, }, { 80, 48158, 180000, }, },
		{ name = "联结治疗", { 64, 32546, 72000, }, { 72, 48119, 180000, }, { 78, 48120, 180000, }, },
		{ name = "暗影魔", { 66, 34433, 89000, }, },
		{ name = "愈合祷言", { 68, 33076, 110000, }, { 74, 48112, 100000, }, { 79, 48113, 180000, }, },
		{ name = "群体驱散", { 70, 32375, 110000, }, },
		{ name = "精神灼烧", { 75, 48045, 10000, }, { 80, 53023, 100000, }, },
		{ name = "神圣赞美诗", { 80, 64843, 180000, }, },
		{ name = "希望圣歌", { 80, 64901, 65000, }, },
		{ name = "绝望祷言", { -1, 19236, 0, }, { 26, 19238, 60, }, { 34, 19240, 300, }, { 42, 19241, 600, }, { 50, 19242, 1100, }, { 58, 19243, 1500, }, { 66, 25437, 2200, }, { 73, 48172, 3250, }, { 80, 48173, 9000, }, talent = true, },
		{ name = "精神鞭笞", { -1, 15407, 0, }, { 28, 17311, 400, }, { 36, 17312, 700, }, { 44, 17313, 1200, }, { 52, 17314, 1900, }, { 60, 18807, 2300, }, { 68, 25387, 6500, }, { 74, 48155, 9000, }, { 80, 48156, 9000, }, talent = true, },
		{ name = "光明之泉", { -1, 724, 0, }, { 50, 27870, 1200, }, { 60, 27871, 1500, }, { 70, 28275, 1500, }, { 75, 48086, 9000, }, { 80, 48087, 9000, }, talent = true, },
		{ name = "治疗之环", { -1, 34861, 0, }, { 56, 34863, 2100, }, { 60, 34864, 2300, }, { 65, 34865, 4000, }, { 70, 34866, 7000, }, { 75, 48088, 9000, }, { 80, 48089, 9000, }, talent = true, },
		{ name = "吸血鬼之触", { -1, 34914, 0, }, { 60, 34916, 2300, }, { 70, 34917, 2300, }, { 75, 48159, 9000, }, { 80, 48160, 9000, }, talent = true, },
		{ name = "苦修", { -1, 47540, 0, }, { 70, 53005, 5000, }, { 75, 53006, 9000, }, { 80, 53007, 9000, }, talent = true, },
		{ name = "痛苦压制", { -1, 33206, 0, }, talent = true, },
		{ name = "能量灌注", { -1, 10060, 0, }, talent = true, },
		{ name = "守护之魂", { -1, 47788, 0, }, talent = true, },
		{ name = "沉默", { -1, 15487, 0, }, talent = true, },
		{ name = "消散", { -1, 47585, 0, }, talent = true, },
		{ name = "暗影形态", { -1, 15473, 0, }, talent = true, },
		{ name = "心灵专注", { -1, 14751, 0, }, talent = true, },
		{ name = "吸血鬼的拥抱", { -1, 15286, 0, }, talent = true, },
		{ name = "心灵惊骇", { -1, 64044, 0, }, talent = true, },
	},
	ROGUE = {
		{ name = "潜行", { 1, 1784, 10, }, },
		{ name = "双武器", { 1, 674, 300, }, },
		{ name = "影袭", { 1, 1752, 0, }, { 6, 1757, 100, }, { 14, 1758, 1200, }, { 22, 1759, 4000, }, { 30, 1760, 10000, }, { 38, 8621, 18000, }, { 46, 11293, 31000, }, { 54, 11294, 48000, }, { 62, 26861, 50000, }, { 70, 26862, 100000, }, { 76, 48637, 300000, }, { 80, 48638, 300000, }, },
		{ name = "刺骨", { 1, 2098, 0, }, { 8, 6760, 200, }, { 16, 6761, 1800, }, { 24, 6762, 5000, }, { 32, 8623, 12000, }, { 40, 8624, 20000, }, { 48, 11299, 33000, }, { 56, 11300, 50000, }, { 60, 31016, 65000, }, { 64, 26865, 140000, }, { 73, 48667, 300000, }, { 79, 48668, 300000, }, },
		{ name = "搜索", { 4, 921, 100, }, },
		{ name = "背刺", { 4, 53, 100, }, { 12, 2589, 800, }, { 20, 2590, 3000, }, { 28, 2591, 8000, }, { 36, 8721, 16000, }, { 44, 11279, 29000, }, { 52, 11280, 46000, }, { 60, 11281, 54000, }, { 60, 25300, 72000, }, { 68, 26863, 110000, }, { 74, 48656, 300000, }, { 80, 48657, 300000, }, },
		{ name = "凿击", { 6, 1776, 100, }, },
		{ name = "闪避", { 8, 5277, 200, }, { 50, 26669, 35000, }, },
		{ name = "闷棍", { 10, 6770, 300, }, { 28, 2070, 8000, }, { 48, 11297, 33000, }, { 71, 51724, 300000, }, },
		{ name = "疾跑", { 10, 2983, 300, }, { 34, 8696, 14000, }, { 58, 11305, 52000, }, },
		{ name = "切割", { 10, 5171, 300, }, { 42, 6774, 27000, }, },
		{ name = "脚踢", { 12, 1766, 800, }, },
		{ name = "招架", { 12, 3127, 800, }, },
		{ name = "破甲", { 14, 8647, 1200, }, },
		{ name = "锁喉", { 14, 703, 1200, }, { 22, 8631, 4000, }, { 30, 8632, 10000, }, { 38, 8633, 18000, }, { 46, 11289, 31000, }, { 54, 11290, 48000, }, { 61, 26839, 50000, }, { 70, 26884, 100000, }, { 75, 48675, 300000, }, { 80, 48676, 300000, }, },
		{ name = "开锁", { 16, 1804, 1800, }, },
		{ name = "佯攻", { 16, 1966, 1800, }, { 28, 6768, 8000, }, { 40, 8637, 20000, }, { 52, 11303, 46000, }, { 60, 25302, 50000, }, { 64, 27448, 72000, }, { 72, 48658, 300000, }, { 78, 48659, 300000, }, },
		{ name = "伏击", { 18, 8676, 2900, }, { 26, 8724, 6000, }, { 34, 8725, 14000, }, { 42, 11267, 27000, }, { 50, 11268, 35000, }, { 58, 11269, 52000, }, { 66, 27441, 80000, }, { 70, 48689, 140000, }, { 75, 48690, 300000, }, { 80, 48691, 300000, }, },
		{ name = "拆卸", { 20, 51722, 3000, }, },
		{ name = "割裂", { 20, 1943, 3000, }, { 28, 8639, 8000, }, { 36, 8640, 16000, }, { 44, 11273, 29000, }, { 52, 11274, 46000, }, { 60, 11275, 54000, }, { 68, 26867, 120000, }, { 74, 48671, 300000, }, { 79, 48672, 300000, }, },
		{ name = "扰乱", { 22, 1725, 4000, }, },
		{ name = "消失", { 22, 1856, 4000, }, { 42, 1857, 27000, }, { 62, 26889, 59000, }, },
		{ name = "侦测陷阱", { 24, 2836, 5000, }, },
		{ name = "偷袭", { 26, 1833, 6000, }, },
		{ name = "解除陷阱", { 30, 1842, 10000, }, },
		{ name = "肾击", { 30, 408, 10000, }, { 50, 8643, 35000, }, },
		{ name = "致盲", { 34, 2094, 14000, }, },
		{ name = "安全降落", { 40, 1860, 20000, }, },
		{ name = "毒伤", { 62, 32645, 59000, }, { 69, 32684, 100000, }, { 74, 57992, 300000, }, { 80, 57993, 300000, }, },
		{ name = "致命投掷", { 64, 26679, 72000, }, { 70, 48673, 100000, }, { 76, 48674, 300000, }, },
		{ name = "暗影斗篷", { 66, 31224, 89000, }, },
		{ name = "毒刃", { 70, 5938, 100000, }, },
		{ name = "嫁祸诀窍", { 75, 57934, 300000, }, },
		{ name = "刀扇", { 80, 51723, 300000, }, },
		{ name = "出血", { -1, 16511, 0, }, { 46, 17347, 385, }, { 58, 17348, 650, }, { 70, 26864, 2700, }, { 80, 48660, 15000, }, talent = true, },
		{ name = "毁伤", { -1, 1329, 0, }, { 50, 34411, 5500, }, { 60, 34412, 6500, }, { 70, 34413, 7500, }, { 75, 48663, 15000, }, { 80, 48666, 15000, }, talent = true, },
		{ name = "暗影步", { -1, 36554, 0, }, talent = true, },
		{ name = "伺机待发", { -1, 14185, 0, }, talent = true, },
		{ name = "杀戮盛筵", { -1, 51690, 0, }, talent = true, },
		{ name = "鬼魅攻击", { -1, 14278, 0, }, talent = true, },
		{ name = "血之饥渴", { -1, 51662, 0, }, talent = true, },
		{ name = "预谋", { -1, 14183, 0, }, talent = true, },
		{ name = "剑刃乱舞", { -1, 13877, 0, }, talent = true, },
		{ name = "冲动", { -1, 13750, 0, }, talent = true, },
		{ name = "暗影之舞", { -1, 51713, 0, }, talent = true, },
		{ name = "还击", { -1, 14251, 0, }, talent = true, },
		{ name = "冷血", { -1, 14177, 0, }, talent = true, },
	},
	SHAMAN = {
		{ name = "治疗波", { 1, 331, 0, }, { 6, 332, 100, }, { 12, 547, 800, }, { 18, 913, 2000, }, { 24, 939, 3500, }, { 32, 959, 8000, }, { 40, 8005, 12000, }, { 48, 10395, 22000, }, { 56, 10396, 30000, }, { 60, 25357, 6500, }, { 63, 25391, 42000, }, { 70, 25396, 88000, }, { 75, 49272, 180000, }, { 80, 49273, 180000, }, },
		{ name = "闪电箭", { 1, 403, 0, }, { 8, 529, 100, }, { 14, 548, 900, }, { 20, 915, 2200, }, { 26, 943, 4000, }, { 32, 6041, 8000, }, { 38, 10391, 11000, }, { 44, 10392, 18000, }, { 50, 15207, 24000, }, { 56, 15208, 30000, }, { 62, 25448, 38000, }, { 67, 25449, 64000, }, { 73, 49237, 180000, }, { 79, 49238, 180000, }, },
		{ name = "石化武器", { 1, 8017, 10, }, { 8, 8018, 100, }, { 16, 8019, 1800, }, { 24, 10399, 3500, }, },
		{ name = "大地震击", { 4, 8042, 100, }, { 8, 8044, 100, }, { 14, 8045, 900, }, { 24, 8046, 3500, }, { 36, 10412, 10000, }, { 48, 10413, 22000, }, { 60, 10414, 34000, }, { 69, 25454, 79000, }, { 74, 49230, 180000, }, { 79, 49231, 180000, }, },
		{ name = "石肤图腾", { 4, 8071, 0, }, { 14, 8154, 900, }, { 24, 8155, 3500, }, { 34, 10406, 9000, }, { 44, 10407, 18000, }, { 54, 10408, 29000, }, { 63, 25508, 42000, }, { 70, 25509, 88000, }, { 73, 58751, 180000, }, { 78, 58753, 180000, }, },
		{ name = "地缚图腾", { 6, 2484, 100, }, },
		{ name = "闪电之盾", { 8, 324, 100, }, { 16, 325, 1800, }, { 24, 905, 3500, }, { 32, 945, 8000, }, { 40, 8134, 12000, }, { 48, 10431, 22000, }, { 56, 10432, 30000, }, { 63, 25469, 42000, }, { 70, 25472, 88000, }, { 75, 49280, 180000, }, { 80, 49281, 180000, }, },
		{ name = "石爪图腾", { 8, 5730, 100, }, { 18, 6390, 2000, }, { 28, 6391, 6000, }, { 38, 6392, 11000, }, { 48, 10427, 22000, }, { 58, 10428, 32000, }, { 67, 25525, 64000, }, { 71, 58580, 180000, }, { 75, 58581, 180000, }, { 78, 58582, 180000, }, },
		{ name = "火舌武器", { 10, 8024, 400, }, { 18, 8027, 2000, }, { 26, 8030, 4000, }, { 36, 16339, 10000, }, { 46, 16341, 20000, }, { 56, 16342, 30000, }, { 64, 25489, 47000, }, { 71, 58785, 180000, }, { 76, 58789, 180000, }, { 80, 58790, 180000, }, },
		{ name = "烈焰震击", { 10, 8050, 400, }, { 18, 8052, 2000, }, { 28, 8053, 6000, }, { 40, 10447, 12000, }, { 52, 10448, 27000, }, { 60, 29228, 65000, }, { 70, 25457, 88000, }, { 75, 49232, 180000, }, { 80, 49233, 180000, }, },
		{ name = "灼热图腾", { 10, 3599, 0, }, { 20, 6363, 2200, }, { 30, 6364, 7000, }, { 40, 6365, 12000, }, { 50, 10437, 24000, }, { 60, 10438, 34000, }, { 69, 25533, 79000, }, { 71, 58699, 180000, }, { 75, 58703, 180000, }, { 80, 58704, 180000, }, },
		{ name = "大地之力图腾", { 10, 8075, 400, }, { 24, 8160, 3500, }, { 38, 8161, 11000, }, { 52, 10442, 27000, }, { 60, 25361, 34000, }, { 65, 25528, 52000, }, { 75, 57622, 180000, }, { 80, 58643, 180000, }, },
		{ name = "火焰新星", { 12, 1535, 800, }, { 22, 8498, 3000, }, { 32, 8499, 8000, }, { 42, 11314, 16000, }, { 52, 11315, 27000, }, { 61, 25546, 34000, }, { 70, 25547, 88000, }, { 75, 61649, 180000, }, { 80, 61657, 180000, }, },
		{ name = "先祖之魂", { 12, 2008, 800, }, { 24, 20609, 3500, }, { 36, 20610, 10000, }, { 48, 20776, 22000, }, { 60, 20777, 34000, }, { 69, 25590, 79000, }, { 80, 49277, 180000, }, },
		{ name = "净化术", { 12, 370, 800, }, { 32, 8012, 8000, }, },
		{ name = "驱毒术", { 16, 526, 1800, }, },
		{ name = "风剪", { 16, 57994, 2500, }, },
		{ name = "幽灵狼", { 16, 2645, 1800, }, },
		{ name = "战栗图腾", { 18, 8143, 2000, }, },
		{ name = "水之护盾", { 20, 52127, 2200, }, { 28, 52129, 6000, }, { 34, 52131, 9000, }, { 41, 52134, 12000, }, { 48, 52136, 22000, }, { 55, 52138, 29000, }, { 62, 24398, 38000, }, { 69, 33736, 79000, }, { 76, 57960, 180000, }, },
		{ name = "次级治疗波", { 20, 8004, 2200, }, { 28, 8008, 6000, }, { 36, 8010, 10000, }, { 44, 10466, 18000, }, { 52, 10467, 27000, }, { 60, 10468, 34000, }, { 66, 25420, 58000, }, { 72, 49275, 180000, }, { 77, 49276, 180000, }, },
		{ name = "冰封武器", { 20, 8033, 2200, }, { 28, 8038, 6000, }, { 38, 10456, 11000, }, { 48, 16355, 22000, }, { 58, 16356, 32000, }, { 66, 25500, 58000, }, { 71, 58794, 180000, }, { 76, 58795, 180000, }, { 80, 58796, 180000, }, },
		{ name = "治疗之泉图腾", { 20, 5394, 0, }, { 30, 6375, 7000, }, { 40, 6377, 12000, }, { 50, 10462, 24000, }, { 60, 10463, 34000, }, { 69, 25567, 79000, }, { 71, 58755, 180000, }, { 76, 58756, 180000, }, { 80, 58757, 180000, }, },
		{ name = "冰霜震击", { 20, 8056, 2200, }, { 34, 8058, 9000, }, { 46, 10472, 20000, }, { 58, 10473, 32000, }, { 68, 25464, 71000, }, { 73, 49235, 180000, }, { 78, 49236, 180000, }, },
		{ name = "水下呼吸", { 22, 131, 3000, }, },
		{ name = "抗寒图腾", { 24, 8181, 3500, }, { 38, 10478, 11000, }, { 54, 10479, 29000, }, { 67, 25560, 64000, }, { 75, 58741, 180000, }, { 80, 58745, 180000, }, },
		{ name = "视界术", { 26, 6196, 4000, }, },
		{ name = "法力之泉图腾", { 26, 5675, 4000, }, { 36, 10495, 10000, }, { 46, 10496, 20000, }, { 56, 10497, 30000, }, { 65, 25570, 52000, }, { 71, 58771, 180000, }, { 76, 58773, 180000, }, { 80, 58774, 180000, }, },
		{ name = "熔岩图腾", { 26, 8190, 4000, }, { 36, 10585, 10000, }, { 46, 10586, 20000, }, { 56, 10587, 30000, }, { 65, 25552, 52000, }, { 73, 58731, 180000, }, { 78, 58734, 180000, }, },
		{ name = "水上行走", { 28, 546, 6000, }, },
		{ name = "火舌图腾", { 28, 8227, 6000, }, { 38, 8249, 11000, }, { 48, 10526, 22000, }, { 58, 16387, 32000, }, { 67, 25557, 64000, }, { 71, 58649, 180000, }, { 75, 58652, 180000, }, { 80, 58656, 180000, }, },
		{ name = "抗火图腾", { 28, 8184, 6000, }, { 42, 10537, 16000, }, { 58, 10538, 32000, }, { 68, 25563, 71000, }, { 75, 58737, 180000, }, { 80, 58739, 180000, }, },
		{ name = "收回图腾", { 30, 36936, 7000, }, },
		{ name = "复生", { 30, 20608, 7000, }, },
		{ name = "元素的召唤", { 30, 66842, 7000, }, },
		{ name = "根基图腾", { 30, 8177, 7000, }, },
		{ name = "星界传送", { 30, 556, 7000, }, },
		{ name = "风怒武器", { 30, 8232, 7000, }, { 40, 8235, 12000, }, { 50, 10486, 24000, }, { 60, 16362, 34000, }, { 68, 25505, 71000, }, { 71, 58801, 180000, }, { 76, 58803, 180000, }, { 80, 58804, 180000, }, },
		{ name = "大地生命武器", { 30, 51730, 7000, }, { 40, 51988, 12000, }, { 50, 51991, 24000, }, { 60, 51992, 34000, }, { 70, 51993, 71000, }, { 80, 51994, 180000, }, },
		{ name = "自然抗性图腾", { 30, 10595, 7000, }, { 44, 10600, 18000, }, { 60, 10601, 34000, }, { 69, 25574, 79000, }, { 75, 58746, 180000, }, { 80, 58749, 180000, }, },
		{ name = "风怒图腾", { 32, 8512, 8000, }, },
		{ name = "闪电链", { 32, 421, 8000, }, { 40, 930, 12000, }, { 48, 2860, 22000, }, { 56, 10605, 30000, }, { 63, 25439, 42000, }, { 70, 25442, 88000, }, { 74, 49270, 180000, }, { 80, 49271, 180000, }, },
		{ name = "岗哨图腾", { 34, 6495, 9000, }, },
		{ name = "净化图腾", { 38, 8170, 11000, }, },
		{ name = "锁甲", { 40, 8737, 12000, }, },
		{ name = "先祖的召唤", { 40, 66843, 7000, }, },
		{ name = "治疗链", { 40, 1064, 12000, }, { 46, 10622, 20000, }, { 54, 10623, 29000, }, { 61, 25422, 34000, }, { 68, 25423, 71000, }, { 74, 55458, 180000, }, { 80, 55459, 180000, }, },
		{ name = "灵魂的召唤", { 50, 66844, 7000, }, },
		{ name = "空气之怒图腾", { 64, 3738, 47000, }, },
		{ name = "土元素图腾", { 66, 2062, 58000, }, },
		{ name = "火元素图腾", { 68, 2894, 71000, }, },
		{ name = "英勇", { 70, 32182, 88000, }, },
		{ name = "熔岩爆裂", { 75, 51505, 180000, }, { 80, 60043, 180000, }, },
		{ name = "妖术", { 80, 51514, 180000, }, },
		{ name = "大地之盾", { -1, 974, 0, }, { 60, 32593, 1700, }, { 70, 32594, 5000, }, { 75, 49283, 9000, }, { 80, 49284, 9000, }, talent = true, },
		{ name = "天怒图腾",{ -1, 30706, 0, }, { 60, 57720, 3400, }, { 70, 57721, 5200, }, { 80, 57722, 10000, }, talent = true, },
		{ name = "激流", { -1, 61295, 0, }, { 70, 61299, 9000, }, { 75, 61300, 9000, }, { 80, 61301, 9000, }, talent = true, },
		{ name = "雷霆风暴", { -1, 51490, 0, }, { 70, 59156, 88000, }, { 75, 59158, 180000, }, { 80, 59159, 180000, }, talent = true, },
		{ name = "潮汐之力", { -1, 55198, 0, }, talent = true, },
		{ name = "野性狼魂", { -1, 51533, 0, }, talent = true, },
		{ name = "灵魂武器", { -1, 16268, 0, }, talent = true, },
		{ name = "元素掌握", { -1, 16166, 0, }, talent = true, },
		{ name = "风暴打击", { -1, 17364, 0, }, talent = true, },
		{ name = "净化灵魂", { -1, 51886, 0, }, talent = true, },
		{ name = "熔岩猛击", { -1, 60103, 0, }, talent = true, },
		{ name = "自然迅捷", { -1, 16188, 0, }, talent = true, },
		{ name = "双武器", { -1, 30798, 0, }, talent = true, },
		{ name = "法力之潮图腾", { -1, 16190, 0, }, talent = true, },
		{ name = "萨满之怒", { -1, 30823, 0, }, talent = true, },
	},
	WARLOCK = {
		{ name = "召唤小鬼", { 1, 688, 100, }, },
		{ name = "暗影箭", { 1, 686, 0, }, { 6, 695, 100, }, { 12, 705, 600, }, { 20, 1088, 2000, }, { 28, 1106, 5000, }, { 36, 7641, 9000, }, { 44, 11659, 12000, }, { 52, 11660, 18000, }, { 60, 11661, 26000, }, { 62, 25307, 26000, }, { 69, 27209, 70000, }, { 74, 47808, 160000, }, { 79, 47809, 160000, }, },
		{ name = "恶魔皮肤", { 1, 687, 0, }, { 10, 696, 300, }, },
		{ name = "献祭", { 1, 348, 10, }, { 10, 707, 300, }, { 20, 1094, 2000, }, { 30, 2941, 6000, }, { 40, 11665, 11000, }, { 50, 11667, 15000, }, { 60, 11668, 26000, }, { 60, 25309, 26000, }, { 69, 27215, 70000, }, { 75, 47810, 160000, }, { 80, 47811, 160000, }, },
		{ name = "虚弱诅咒", { 4, 702, 100, }, { 12, 1108, 600, }, { 22, 6205, 2500, }, { 32, 7646, 7000, }, { 42, 11707, 11000, }, { 52, 11708, 18000, }, { 61, 27224, 30000, }, { 69, 30909, 70000, }, { 71, 50511, 160000, }, },
		{ name = "腐蚀术", { 4, 172, 100, }, { 14, 6222, 900, }, { 24, 6223, 3000, }, { 34, 7648, 8000, }, { 44, 11671, 12000, }, { 54, 11672, 20000, }, { 60, 25311, 26000, }, { 65, 27216, 46000, }, { 71, 47812, 160000, }, { 77, 47813, 160000, }, },
		{ name = "生命分流", { 6, 1454, 100, }, { 16, 1455, 1080, }, { 26, 1456, 3600, }, { 36, 11687, 8100, }, { 46, 11688, 11700, }, { 56, 11689, 19800, }, { 68, 27222, 56700, }, { 80, 57946, 160000, }, },
		{ name = "痛苦诅咒", { 8, 980, 200, }, { 18, 1014, 1500, }, { 28, 6217, 5000, }, { 38, 11711, 10000, }, { 48, 11712, 14000, }, { 58, 11713, 24000, }, { 67, 27218, 57000, }, { 73, 47863, 160000, }, { 79, 47864, 160000, }, },
		{ name = "恐惧", { 8, 5782, 200, }, { 32, 6213, 7000, }, { 56, 6215, 22000, }, },
		{ name = "制造治疗石", { 10, 6201, 300, }, { 22, 6202, 2500, }, { 34, 5699, 8000, }, { 46, 11729, 13000, }, { 58, 11730, 24000, }, { 68, 27230, 63000, }, { 73, 47871, 160000, }, { 79, 47878, 160000, }, },
		{ name = "吸取灵魂", { 10, 1120, 300, }, { 24, 8288, 3000, }, { 38, 8289, 10000, }, { 52, 11675, 18000, }, { 67, 27217, 57000, }, { 77, 47855, 160000, }, },
		{ name = "生命通道", { 12, 755, 600, }, { 20, 3698, 2000, }, { 28, 3699, 5000, }, { 36, 3700, 9000, }, { 44, 11693, 12000, }, { 52, 11694, 18000, }, { 60, 11695, 26000, }, { 67, 27259, 57000, }, { 76, 47856, 160000, }, },
		{ name = "吸取生命", { 14, 689, 900, }, { 22, 699, 2500, }, { 30, 709, 6000, }, { 38, 7651, 10000, }, { 46, 11699, 13000, }, { 54, 11700, 20000, }, { 62, 27219, 30000, }, { 69, 27220, 70000, }, { 78, 47857, 160000, }, },
		{ name = "魔息术", { 16, 5697, 1200, }, },
		{ name = "灼热之痛", { 18, 5676, 1500, }, { 26, 17919, 4000, }, { 34, 17920, 8000, }, { 42, 17921, 11000, }, { 50, 17922, 15000, }, { 58, 17923, 24000, }, { 65, 27210, 46000, }, { 70, 30459, 78000, }, { 74, 47814, 160000, }, { 79, 47815, 160000, }, },
		{ name = "制造灵魂石", { 18, 693, 1500, }, { 30, 20752, 6000, }, { 40, 20755, 11000, }, { 50, 20756, 15000, }, { 60, 20757, 26000, }, { 70, 27238, 78000, }, { 76, 47884, 160000, }, },
		{ name = "召唤仪式", { 20, 698, 2000, }, },
		{ name = "魔甲术", { 20, 706, 2000, }, { 30, 1086, 6000, }, { 40, 11733, 11000, }, { 50, 11734, 15000, }, { 60, 11735, 26000, }, { 70, 27260, 78000, }, { 76, 47793, 160000, }, { 80, 47889, 160000, }, },
		{ name = "火焰之雨", { 20, 5740, 2000, }, { 34, 6219, 8000, }, { 46, 11677, 13000, }, { 58, 11678, 24000, }, { 69, 27212, 70000, }, { 72, 47819, 160000, }, { 79, 47820, 160000, }, },
		{ name = "基尔罗格之眼", { 22, 126, 2500, }, },
		{ name = "吸取法力", { 24, 5138, 3000, }, },
		{ name = "感知恶魔", { 24, 5500, 3000, }, },
		{ name = "侦测隐形", { 26, 132, 4000, }, },
		{ name = "语言诅咒", { 26, 1714, 4000, }, { 50, 11719, 15000, }, },
		{ name = "制造火焰石", { 28, 6366, 5000, }, { 36, 17951, 9000, }, { 46, 17952, 13000, }, { 56, 17953, 22000, }, { 66, 27250, 51000, }, { 74, 60219, 160000, }, { 80, 60220, 160000, }, },
		{ name = "放逐术", { 28, 710, 5000, }, { 48, 18647, 14000, }, },
		{ name = "地狱烈焰", { 30, 1949, 6000, }, { 42, 11683, 11000, }, { 54, 11684, 20000, }, { 68, 27213, 63000, }, { 78, 47823, 160000, }, },
		{ name = "征服恶魔", { 30, 1098, 6000, }, { 44, 11725, 12000, }, { 58, 11726, 24000, }, { 72, 61191, 70000, }, },
		{ name = "暗影防护结界", { 32, 6229, 7000, }, { 42, 11739, 11000, }, { 52, 11740, 18000, }, { 60, 28610, 34000, }, { 72, 47890, 160000, }, { 78, 47891, 160000, }, },
		{ name = "元素诅咒", { 32, 1490, 7000, }, { 46, 11721, 13000, }, { 60, 11722, 26000, }, { 69, 27228, 70000, }, { 78, 47865, 160000, }, },
		{ name = "制造法术石", { 36, 2362, 9000, }, { 48, 17727, 14000, }, { 60, 17728, 26000, }, { 66, 28172, 51000, }, { 72, 47886, 160000, }, { 78, 47888, 160000, }, },
		{ name = "恐惧战马", { 40, 23161, 20000, }, },
		{ name = "恐惧嚎叫", { 40, 5484, 11000, }, { 54, 17928, 20000, }, },
		{ name = "死亡缠绕", { 42, 6789, 11000, }, { 50, 17925, 15000, }, { 58, 17926, 24000, }, { 68, 27223, 63000, }, { 73, 47859, 160000, }, { 78, 47860, 160000, }, },
		{ name = "灵魂之火", { 48, 6353, 14000, }, { 56, 17924, 22000, }, { 64, 27211, 42000, }, { 70, 30545, 78000, }, { 75, 47824, 160000, }, { 80, 47825, 160000, }, },
		{ name = "厄运诅咒", { 60, 603, 26000, }, { 70, 30910, 78000, }, { 80, 47867, 160000, }, },
		{ name = "邪甲术", { 62, 28176, 34000, }, { 69, 28189, 70000, }, { 74, 47892, 160000, }, { 79, 47893, 160000, }, },
		{ name = "烧尽", { 64, 29722, 42000, }, { 70, 32231, 78000, }, { 74, 47837, 100000, }, { 80, 47838, 100000, }, },
		{ name = "灵魂碎裂", { 66, 29858, 51000, }, },
		{ name = "灵魂仪式", { 68, 29893, 63000, }, { 80, 58887, 160000, }, },
		{ name = "腐蚀之种", { 70, 27243, 78000, }, { 75, 47835, 160000, }, { 80, 47836, 160000, }, },
		{ name = "暗影烈焰", { 75, 47897, 10000, }, { 80, 61290, 10000, }, },
		{ name = "恶魔法阵：传送", { 80, 48020, 160000, }, },
		{ name = "恶魔法阵：召唤", { 80, 48018, 160000, }, },
		{ name = "暗影灼烧", { -1, 17877, 0, }, { 24, 18867, 150, }, { 32, 18868, 350, }, { 40, 18869, 550, }, { 48, 18870, 700, }, { 56, 18871, 1100, }, { 63, 27263, 1300, }, { 70, 30546, 3900, }, { 75, 47826, 8000, }, { 80, 47827, 8000, }, talent = true, },
		{ name = "黑暗契约", { -1, 18220, 0, }, { 50, 18937, 750, }, { 60, 18938, 1300, }, { 70, 27265, 1300, }, { 80, 59092, 160000, }, talent = true, },
		{ name = "痛苦无常", { -1, 30108, 0, }, { 60, 30404, 2500, }, { 70, 30405, 2500, }, { 75, 47841, 8000, }, { 80, 47843, 8000, }, talent = true, },
		{ name = "暗影之怒", { -1, 30283, 0, }, { 60, 30413, 2500, }, { 70, 30414, 2500, }, { 75, 47846, 8000, }, { 80, 47847, 8000, }, talent = true, },
		{ name = "混乱之箭", { -1, 50796, 0, }, { 70, 59170, 2500, }, { 75, 59171, 8000, }, { 80, 59172, 8000, }, talent = true, },
		{ name = "鬼影缠身", { -1, 48181, 0, }, { 70, 59161, 2500, }, { 75, 59163, 8000, }, { 80, 59164, 8000, }, talent = true, },
		{ name = "燃烧", { -1, 17962, 0, }, talent = true, },
		{ name = "恶魔增效", { -1, 47193, 0, }, talent = true, },
		{ name = "恶魔变形", { -1, 59672, 0, }, talent = true, },
		{ name = "恶魔支配", { -1, 18708, 0, }, talent = true, },
		{ name = "灵魂链接", { -1, 19028, 0, }, talent = true, },
		{ name = "疲劳诅咒", { -1, 18223, 0, }, talent = true, },
		{ name = "召唤恶魔卫士", { -1, 30146, 0, }, talent = true, },
	},
	WARRIOR = {
		{ name = "战斗姿态", { 1, 2457, 0, }, },
		{ name = "英勇打击", { 1, 78, 0, }, { 8, 284, 200, }, { 16, 285, 2000, }, { 24, 1608, 8000, }, { 32, 11564, 14000, }, { 40, 11565, 22000, }, { 48, 11566, 40000, }, { 56, 11567, 58000, }, { 60, 25286, 60000, }, { 66, 29707, 65000, }, { 70, 30324, 100000, }, { 72, 47449, 260000, }, { 76, 47450, 260000, }, },
		{ name = "战斗怒吼", { 1, 6673, 10, }, { 12, 5242, 1000, }, { 22, 6192, 6000, }, { 32, 11549, 14000, }, { 42, 11550, 32000, }, { 52, 11551, 54000, }, { 60, 25289, 65000, }, { 69, 2048, 71000, }, { 78, 47436, 260000, }, },
		{ name = "撕裂", { 4, 772, 100, }, { 10, 6546, 600, }, { 20, 6547, 4000, }, { 30, 6548, 12000, }, { 40, 11572, 22000, }, { 50, 11573, 42000, }, { 60, 11574, 62000, }, { 68, 25208, 65000, }, { 71, 46845, 260000, }, { 76, 47465, 260000, }, },
		{ name = "冲锋", { 4, 100, 100, }, { 26, 6178, 10000, }, { 46, 11578, 36000, }, },
		{ name = "乘胜追击", { 6, 34428, 100, }, },
		{ name = "招架", { 6, 3127, 100, }, },
		{ name = "雷霆一击", { 6, 6343, 100, }, { 18, 8198, 3000, }, { 28, 8204, 11000, }, { 38, 8205, 20000, }, { 48, 11580, 40000, }, { 58, 11581, 60000, }, { 67, 25264, 65000, }, { 73, 47501, 260000, }, { 78, 47502, 260000, }, },
		{ name = "断筋", { 8, 1715, 200, }, },
		{ name = "血性狂暴", { 10, 2687, 600, }, },
		{ name = "盾击", { 12, 72, 1000, }, },
		{ name = "压制", { 12, 7384, 1000, }, },
		{ name = "复仇", { 14, 6572, 1500, }, { 24, 6574, 8000, }, { 34, 7379, 16000, }, { 44, 11600, 34000, }, { 54, 11601, 56000, }, { 60, 25288, 60000, }, { 63, 25269, 65000, }, { 70, 30357, 260000, }, { 80, 57823, 260000, }, },
		{ name = "挫志怒吼", { 14, 1160, 1500, }, { 24, 6190, 8000, }, { 34, 11554, 16000, }, { 44, 11555, 34000, }, { 54, 11556, 56000, }, { 62, 25202, 65000, }, { 70, 25203, 71000, }, { 79, 47437, 260000, }, },
		{ name = "惩戒痛击", { 16, 694, 2000, }, },
		{ name = "盾牌格挡", { 16, 2565, 2000, }, },
		{ name = "缴械", { 18, 676, 3000, }, },
		{ name = "双武器", { 20, 674, 4000, }, },
		{ name = "反击风暴", { 20, 20230, 4000, }, },
		{ name = "姿态掌握", { 20, 12678, 4000, }, },
		{ name = "顺劈斩", { 20, 845, 4000, }, { 30, 7369, 12000, }, { 40, 11608, 22000, }, { 50, 11609, 42000, }, { 60, 20569, 62000, }, { 68, 25231, 65000, }, { 72, 47519, 260000, }, { 77, 47520, 260000, }, },
		{ name = "破胆怒吼", { 22, 5246, 6000, }, },
		{ name = "斩杀", { 24, 5308, 8000, }, { 32, 20658, 14000, }, { 40, 20660, 22000, }, { 48, 20661, 40000, }, { 56, 20662, 58000, }, { 65, 25234, 65000, }, { 70, 25236, 71000, }, { 73, 47470, 260000, }, { 80, 47471, 260000, }, },
		{ name = "挑战怒吼", { 26, 1161, 10000, }, },
		{ name = "盾墙", { 28, 871, 11000, }, },
		{ name = "拦截", { 30, 20252, 12000, }, },
		{ name = "猛击", { 30, 1464, 12000, }, { 38, 8820, 20000, }, { 46, 11604, 36000, }, { 54, 11605, 56000, }, { 61, 25241, 65000, }, { 69, 25242, 71000, }, { 74, 47474, 260000, }, { 79, 47475, 260000, }, },
		{ name = "狂暴之怒", { 32, 18499, 14000, }, },
		{ name = "旋风斩", { 36, 1680, 18000, }, },
		{ name = "拳击", { 38, 6552, 20000, }, },
		{ name = "板甲", { 40, 750, 22000, }, },
		{ name = "盾牌猛击", { 40, 23922, 22000, }, { 48, 23923, 40000, }, { 54, 23924, 56000, }, { 60, 23925, 62000, }, { 66, 25258, 65000, }, { 70, 30356, 71000, }, { 75, 47487, 260000, }, { 80, 47488, 260000, }, },
		{ name = "鲁莽", { 50, 1719, 42000, }, },
		{ name = "法术反射", { 64, 23920, 65000, }, },
		{ name = "命令怒吼", { 68, 469, 65000, }, { 74, 47439, 100000, }, { 80, 47440, 260000, }, },
		{ name = "援护", { 70, 3411, 65000, }, },
		{ name = "碎裂投掷", { 71, 64382, 260000, }, },
		{ name = "狂怒回复", { 75, 55694, 100000, }, },
		{ name = "英勇投掷", { 80, 57755, 100000, }, },
		{ name = "致死打击", { -1, 12294, 0, }, { 48, 21551, 2000, }, { 54, 21552, 2800, }, { 60, 21553, 3100, }, { 66, 25248, 3250, }, { 70, 30330, 3500, }, { 75, 47485, 13000, }, { 80, 47486, 13000, }, talent = true, },
		{ name = "毁灭打击", { -1, 20243, 0, }, { 60, 30016, 3100, }, { 70, 30022, 3250, }, { 75, 47497, 5000, }, { 80, 47498, 5000, }, talent = true, },
		{ name = "震荡波", { -1, 46968, 0, }, talent = true, },
		{ name = "警戒", { -1, 50720, 0, }, talent = true, },
		{ name = "震荡猛击", { -1, 12809, 0, }, talent = true, },
		{ name = "英勇之怒", { -1, 60970, 0, }, talent = true, },
		{ name = "嗜血", { -1, 23881, 0, }, talent = true, },
		{ name = "破釜沉舟", { -1, 12975, 0, }, talent = true, },
		{ name = "利刃风暴", { -1, 46924, 0, }, talent = true, },
		{ name = "横扫攻击", { -1, 12328, 0, }, talent = true, },
		{ name = "死亡之愿", { -1, 12292, 0, }, talent = true, },
		{ name = "刺耳怒吼", { -1, 12323, 0, }, talent = true, },
	},
};

DT.TalentSpecIcon = {
	[41] = "Interface\\Icons\\spell_fire_firebolt02",
	[61] = "Interface\\Icons\\spell_frost_frostbolt02",
	[81] = "Interface\\Icons\\inv_misc_rune_03",
	[161] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[163] = "Interface\\Icons\\ability_warrior_defensivestance",
	[164] = "Interface\\Icons\\ability_warrior_innerrage",
	[181] = "Interface\\Icons\\ability_backstab",
	[182] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[183] = "Interface\\Icons\\Ability_Ambush",
	[201] = "Interface\\Icons\\spell_holy_wordfortitude",
	[202] = "Interface\\Icons\\spell_holy_holybolt",
	[203] = "Interface\\Icons\\spell_shadow_shadowwordpain",
	[261] = "Interface\\Icons\\spell_nature_lightning",
	[262] = "Interface\\Icons\\Spell_Nature_HealingWaveGreater",
	[263] = "Interface\\Icons\\spell_nature_lightningshield",
	[281] = "Interface\\Icons\\ability_racial_bearform",
	[282] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[283] = "Interface\\Icons\\spell_nature_starfall",
	[301] = "Interface\\Icons\\spell_shadow_rainoffire",
	[302] = "Interface\\Icons\\spell_shadow_deathcoil",
	[303] = "Interface\\Icons\\spell_shadow_metamorphosis",
	[361] = "Interface\\Icons\\Ability_Hunter_BeastTaming",
	[362] = "Interface\\Icons\\Ability_Hunter_SwiftStrike",
	[363] = "Interface\\Icons\\Ability_Marksmanship",
	[381] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[382] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[383] = "Interface\\Icons\\Spell_Holy_DevotionAura",

	[398] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[399] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[400] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[409] = "Interface\\Icons\\Ability_Hunter_Pet_Bear",
	[410] = "Interface\\Icons\\Ability_Druid_Swipe",
	[411] = "Interface\\Icons\\Ability_Hunter_CombatExperience",
};

DT.ClassBackground = {
	DEATHKNIGHT = {
		"Interface\\TalentFrame\\bg-deathknight-blood",
		"Interface\\TalentFrame\\bg-deathknight-frost",
		"Interface\\TalentFrame\\bg-deathknight-unholy",
	},
	DRUID = {
		"Interface\\TalentFrame\\bg-druid-balance",
		"Interface\\TalentFrame\\bg-druid-bear",
		"Interface\\TalentFrame\\bg-druid-cat",
		"Interface\\TalentFrame\\bg-druid-restoration",
	},
	HUNTER = {
		"Interface\\TalentFrame\\bg-hunter-beastmaster",
		"Interface\\TalentFrame\\bg-hunter-marksman",
		"Interface\\TalentFrame\\bg-hunter-survival",
	},
	MAGE = {
		"Interface\\TalentFrame\\bg-mage-arcane",
		"Interface\\TalentFrame\\bg-mage-fire",
		"Interface\\TalentFrame\\bg-mage-frost",
	},
	MONK = {
		"Interface\\TalentFrame\\bg-monk-battledancer",
		"Interface\\TalentFrame\\bg-monk-brewmaster",
		"Interface\\TalentFrame\\bg-monk-mistweaver",
	},
	PALADIN = {
		"Interface\\TalentFrame\\bg-paladin-holy",
		"Interface\\TalentFrame\\bg-paladin-protection",
		"Interface\\TalentFrame\\bg-paladin-retribution",
	},
	PRIEST = {
		"Interface\\TalentFrame\\bg-priest-discipline",
		"Interface\\TalentFrame\\bg-priest-holy",
		"Interface\\TalentFrame\\bg-priest-shadow",
	},
	ROGUE = {
		"Interface\\TalentFrame\\bg-rogue-assassination",
		"Interface\\TalentFrame\\bg-rogue-combat",
		"Interface\\TalentFrame\\bg-rogue-subtlety",
	},
	SHAMAN = {
		"Interface\\TalentFrame\\bg-shaman-elemental",
		"Interface\\TalentFrame\\bg-shaman-enhancement",
		"Interface\\TalentFrame\\bg-shaman-restoration",
	},
	WARLOCK = {
		"Interface\\TalentFrame\\bg-warlock-affliction",
		"Interface\\TalentFrame\\bg-warlock-demonology",
		"Interface\\TalentFrame\\bg-warlock-destruction",
	},
	WARRIOR = {
		"Interface\\TalentFrame\\bg-warrior-arms",
		"Interface\\TalentFrame\\bg-warrior-fury",
		"Interface\\TalentFrame\\bg-warrior-protection",
	},
};

DT.SpecBackground = {
		[283] = "Interface\\TalentFrame\\DruidBalance-TopLeft",
		[281] = "Interface\\TalentFrame\\DruidFeralCombat-TopLeft",
		[282] = "Interface\\TalentFrame\\DruidRestoration-TopLeft",
		[361] = "Interface\\TalentFrame\\HunterBeastMastery-TopLeft",
		[363] = "Interface\\TalentFrame\\HunterMarksmanship-TopLeft",
		[362] = "Interface\\TalentFrame\\HunterSurvival-TopLeft",
		[81] = "Interface\\TalentFrame\\MageArcane-TopLeft",
		[41] = "Interface\\TalentFrame\\MageFire-TopLeft",
		[61] = "Interface\\TalentFrame\\MageFrost-TopLeft",
		[382] = "Interface\\TalentFrame\\PaladinHoly-TopLeft",
		[383] = "Interface\\TalentFrame\\PaladinProtection-TopLeft",
		[381] = "Interface\\TalentFrame\\PaladinCombat-TopLeft",
		[201] = "Interface\\TalentFrame\\PriestDiscipline-TopLeft",
		[202] = "Interface\\TalentFrame\\PriestHoly-TopLeft",
		[203] = "Interface\\TalentFrame\\PriestShadow-TopLeft",
		[182] = "Interface\\TalentFrame\\RogueAssassination-TopLeft",
		[181] = "Interface\\TalentFrame\\RogueCombat-TopLeft",
		[183] = "Interface\\TalentFrame\\RogueSubtlety-TopLeft",
		[261] = "Interface\\TalentFrame\\ShamanElementalCombat-TopLeft",
		[263] = "Interface\\TalentFrame\\ShamanEnhancement-TopLeft",
		[262] = "Interface\\TalentFrame\\ShamanRestoration-TopLeft",
		[302] = "Interface\\TalentFrame\\WarlockCurses-TopLeft",
		[303] = "Interface\\TalentFrame\\WarlockSummoning-TopLeft",
		[301] = "Interface\\TalentFrame\\WarlockDestruction-TopLeft",
		[161] = "Interface\\TalentFrame\\WarriorArms-TopLeft",
		[164] = "Interface\\TalentFrame\\WarriorFury-TopLeft",
		[163] = "Interface\\TalentFrame\\WarriorProtection-TopLeft",
};

DT.PresetTalents = {
};

DT.TalentMap = {
	DEATHKNIGHT = {
		RMap = {
			{
				[1] = 20,
				[2] = 4,
				[3] = 1,
				[4] = 7,
				[5] = 10,
				[6] = 8,
				[7] = 16,
				[8] = 2,
				[9] = 5,
				[10] = 15,
				[11] = 14,
				[12] = 12,
				[13] = 19,
				[14] = 22,
				[15] = 25,
				[16] = 26,
				[17] = 24,
				[18] = 18,
				[19] = 28,
				[20] = 13,
				[21] = 3,
				[22] = 11,
				[23] = 23,
				[24] = 27,
				[25] = 9,
				[26] = 17,
				[27] = 6,
				[28] = 21,
			},
			{
				[1] = 3,
				[2] = 12,
				[3] = 5,
				[4] = 26,
				[5] = 24,
				[6] = 15,
				[7] = 11,
				[8] = 29,
				[9] = 13,
				[10] = 18,
				[11] = 17,
				[12] = 25,
				[13] = 28,
				[14] = 20,
				[15] = 2,
				[16] = 6,
				[17] = 21,
				[18] = 14,
				[19] = 1,
				[20] = 4,
				[21] = 27,
				[22] = 7,
				[23] = 10,
				[24] = 9,
				[25] = 23,
				[26] = 8,
				[27] = 16,
				[28] = 19,
				[29] = 22,
			},
			{
				[1] = 2,
				[2] = 5,
				[3] = 7,
				[4] = 25,
				[5] = 4,
				[6] = 20,
				[7] = 10,
				[8] = 14,
				[9] = 31,
				[10] = 19,
				[11] = 27,
				[12] = 12,
				[13] = 15,
				[14] = 26,
				[15] = 8,
				[16] = 18,
				[17] = 16,
				[18] = 23,
				[19] = 6,
				[20] = 30,
				[21] = 11,
				[22] = 28,
				[23] = 9,
				[24] = 1,
				[25] = 24,
				[26] = 29,
				[27] = 3,
				[28] = 22,
				[29] = 13,
				[30] = 17,
				[31] = 21,
			},
		},
		VMap = {
			{
				[1] = 3,
				[2] = 8,
				[3] = 21,
				[4] = 2,
				[5] = 9,
				[6] = 27,
				[7] = 4,
				[8] = 6,
				[9] = 25,
				[10] = 5,
				[11] = 22,
				[12] = 12,
				[13] = 20,
				[14] = 11,
				[15] = 10,
				[16] = 7,
				[17] = 26,
				[18] = 18,
				[19] = 13,
				[20] = 1,
				[21] = 28,
				[22] = 14,
				[23] = 23,
				[24] = 17,
				[25] = 15,
				[26] = 16,
				[27] = 24,
				[28] = 19,
			},
			{
				[1] = 19,
				[2] = 15,
				[3] = 1,
				[4] = 20,
				[5] = 3,
				[6] = 16,
				[7] = 22,
				[8] = 26,
				[9] = 24,
				[10] = 23,
				[11] = 7,
				[12] = 2,
				[13] = 9,
				[14] = 18,
				[15] = 6,
				[16] = 27,
				[17] = 11,
				[18] = 10,
				[19] = 28,
				[20] = 14,
				[21] = 17,
				[22] = 29,
				[23] = 25,
				[24] = 5,
				[25] = 12,
				[26] = 4,
				[27] = 21,
				[28] = 13,
				[29] = 8,
			},
			{
				[1] = 24,
				[2] = 1,
				[3] = 27,
				[4] = 5,
				[5] = 2,
				[6] = 19,
				[7] = 3,
				[8] = 15,
				[9] = 23,
				[10] = 7,
				[11] = 21,
				[12] = 12,
				[13] = 29,
				[14] = 8,
				[15] = 13,
				[16] = 17,
				[17] = 30,
				[18] = 16,
				[19] = 10,
				[20] = 6,
				[21] = 31,
				[22] = 28,
				[23] = 18,
				[24] = 25,
				[25] = 4,
				[26] = 14,
				[27] = 11,
				[28] = 22,
				[29] = 26,
				[30] = 20,
				[31] = 9,
			},
		},
	},
	DRUID = {
		VMap = {
			{
				[1] = 1,
				[2] = 26,
				[3] = 5,
				[4] = 18,
				[5] = 2,
				[6] = 4,
				[7] = 8,
				[8] = 28,
				[9] = 3,
				[10] = 10,
				[11] = 6,
				[12] = 12,
				[13] = 7,
				[14] = 27,
				[15] = 14,
				[16] = 9,
				[17] = 13,
				[18] = 11,
				[19] = 19,
				[20] = 15,
				[21] = 20,
				[22] = 16,
				[23] = 22,
				[24] = 21,
				[25] = 17,
				[26] = 23,
				[27] = 25,
				[28] = 24,
			},
			{
				[1] = 3,
				[2] = 2,
				[3] = 6,
				[4] = 11,
				[5] = 1,
				[6] = 12,
				[7] = 15,
				[8] = 5,
				[9] = 8,
				[10] = 9,
				[11] = 7,
				[12] = 22,
				[13] = 4,
				[14] = 10,
				[15] = 16,
				[16] = 29,
				[17] = 13,
				[18] = 18,
				[19] = 14,
				[20] = 21,
				[21] = 17,
				[22] = 28,
				[23] = 19,
				[24] = 24,
				[25] = 26,
				[26] = 20,
				[27] = 25,
				[28] = 23,
				[29] = 30,
				[30] = 27,
			},
			{
				[1] = 1,
				[2] = 3,
				[3] = 2,
				[4] = 4,
				[5] = 12,
				[6] = 6,
				[7] = 9,
				[8] = 7,
				[9] = 21,
				[10] = 14,
				[11] = 10,
				[12] = 11,
				[13] = 8,
				[14] = 13,
				[15] = 16,
				[16] = 5,
				[17] = 20,
				[18] = 15,
				[19] = 18,
				[20] = 17,
				[21] = 24,
				[22] = 25,
				[23] = 19,
				[24] = 26,
				[25] = 27,
				[26] = 22,
				[27] = 23,
			},
		},
		RMap = {
			{
				[1] = 1,
				[2] = 5,
				[3] = 9,
				[4] = 6,
				[5] = 3,
				[6] = 11,
				[7] = 13,
				[8] = 7,
				[9] = 16,
				[10] = 10,
				[11] = 18,
				[12] = 12,
				[13] = 17,
				[14] = 15,
				[15] = 20,
				[16] = 22,
				[17] = 25,
				[18] = 4,
				[19] = 19,
				[20] = 21,
				[21] = 24,
				[22] = 23,
				[23] = 26,
				[24] = 28,
				[25] = 27,
				[26] = 2,
				[27] = 14,
				[28] = 8,
			},
			{
				[1] = 5,
				[2] = 2,
				[3] = 1,
				[4] = 13,
				[5] = 8,
				[6] = 3,
				[7] = 11,
				[8] = 9,
				[9] = 10,
				[10] = 14,
				[11] = 4,
				[12] = 6,
				[13] = 17,
				[14] = 19,
				[15] = 7,
				[16] = 15,
				[17] = 21,
				[18] = 18,
				[19] = 23,
				[20] = 26,
				[21] = 20,
				[22] = 12,
				[23] = 28,
				[24] = 24,
				[25] = 27,
				[26] = 25,
				[27] = 30,
				[28] = 22,
				[29] = 16,
				[30] = 29,
			},
			{
				[1] = 1,
				[2] = 3,
				[3] = 2,
				[4] = 4,
				[5] = 16,
				[6] = 6,
				[7] = 8,
				[8] = 13,
				[9] = 7,
				[10] = 11,
				[11] = 12,
				[12] = 5,
				[13] = 14,
				[14] = 10,
				[15] = 18,
				[16] = 15,
				[17] = 20,
				[18] = 19,
				[19] = 23,
				[20] = 17,
				[21] = 9,
				[22] = 26,
				[23] = 27,
				[24] = 21,
				[25] = 22,
				[26] = 24,
				[27] = 25,
			},
		},
	},
	WARRIOR = {
		RMap = {
			{
				[1] = 10,
				[2] = 16,
				[3] = 1,
				[4] = 15,
				[5] = 4,
				[6] = 3,
				[7] = 6,
				[8] = 18,
				[9] = 2,
				[10] = 7,
				[11] = 13,
				[12] = 14,
				[13] = 17,
				[14] = 21,
				[15] = 11,
				[16] = 8,
				[17] = 5,
				[18] = 9,
				[19] = 28,
				[20] = 27,
				[21] = 20,
				[22] = 29,
				[23] = 25,
				[24] = 19,
				[25] = 26,
				[26] = 22,
				[27] = 31,
				[28] = 30,
				[29] = 12,
				[30] = 23,
				[31] = 24,
			},
			{
				[1] = 9,
				[2] = 12,
				[3] = 17,
				[4] = 3,
				[5] = 2,
				[6] = 5,
				[7] = 7,
				[8] = 4,
				[9] = 14,
				[10] = 6,
				[11] = 19,
				[12] = 8,
				[13] = 16,
				[14] = 11,
				[15] = 15,
				[16] = 10,
				[17] = 20,
				[18] = 13,
				[19] = 22,
				[20] = 24,
				[21] = 18,
				[22] = 21,
				[23] = 25,
				[24] = 27,
				[25] = 23,
				[26] = 26,
				[27] = 1,
			},
			{
				[1] = 5,
				[2] = 9,
				[3] = 3,
				[4] = 1,
				[5] = 4,
				[6] = 12,
				[7] = 7,
				[8] = 18,
				[9] = 15,
				[10] = 13,
				[11] = 11,
				[12] = 14,
				[13] = 6,
				[14] = 16,
				[15] = 2,
				[16] = 17,
				[17] = 20,
				[18] = 8,
				[19] = 19,
				[20] = 23,
				[21] = 21,
				[22] = 25,
				[23] = 27,
				[24] = 24,
				[25] = 22,
				[26] = 26,
				[27] = 10,
			},
		},
		VMap = {
			{
				[1] = 3,
				[2] = 9,
				[3] = 6,
				[4] = 5,
				[5] = 17,
				[6] = 7,
				[7] = 10,
				[8] = 16,
				[9] = 18,
				[10] = 1,
				[11] = 15,
				[12] = 29,
				[13] = 11,
				[14] = 12,
				[15] = 4,
				[16] = 2,
				[17] = 13,
				[18] = 8,
				[19] = 24,
				[20] = 21,
				[21] = 14,
				[22] = 26,
				[23] = 30,
				[24] = 31,
				[25] = 23,
				[26] = 25,
				[27] = 20,
				[28] = 19,
				[29] = 22,
				[30] = 28,
				[31] = 27,
			},
			{
				[1] = 27,
				[2] = 5,
				[3] = 4,
				[4] = 8,
				[5] = 6,
				[6] = 10,
				[7] = 7,
				[8] = 12,
				[9] = 1,
				[10] = 16,
				[11] = 14,
				[12] = 2,
				[13] = 18,
				[14] = 9,
				[15] = 15,
				[16] = 13,
				[17] = 3,
				[18] = 21,
				[19] = 11,
				[20] = 17,
				[21] = 22,
				[22] = 19,
				[23] = 25,
				[24] = 20,
				[25] = 23,
				[26] = 26,
				[27] = 24,
			},
			{
				[1] = 4,
				[2] = 15,
				[3] = 3,
				[4] = 5,
				[5] = 1,
				[6] = 13,
				[7] = 7,
				[8] = 18,
				[9] = 2,
				[10] = 27,
				[11] = 11,
				[12] = 6,
				[13] = 10,
				[14] = 12,
				[15] = 9,
				[16] = 14,
				[17] = 16,
				[18] = 8,
				[19] = 19,
				[20] = 17,
				[21] = 21,
				[22] = 25,
				[23] = 20,
				[24] = 24,
				[25] = 22,
				[26] = 26,
				[27] = 23,
			},
		},
	},
	SHAMAN = {
		RMap = {
			{
				[1] = 3,
				[2] = 12,
				[3] = 2,
				[4] = 1,
				[5] = 8,
				[6] = 9,
				[7] = 16,
				[8] = 7,
				[9] = 6,
				[10] = 15,
				[11] = 4,
				[12] = 11,
				[13] = 10,
				[14] = 5,
				[15] = 13,
				[16] = 14,
				[17] = 20,
				[18] = 22,
				[19] = 19,
				[20] = 21,
				[21] = 23,
				[22] = 17,
				[23] = 25,
				[24] = 24,
				[25] = 18,
			},
			{
				[1] = 10,
				[2] = 11,
				[3] = 6,
				[4] = 7,
				[5] = 4,
				[6] = 1,
				[7] = 8,
				[8] = 5,
				[9] = 3,
				[10] = 12,
				[11] = 14,
				[12] = 9,
				[13] = 21,
				[14] = 17,
				[15] = 13,
				[16] = 16,
				[17] = 20,
				[18] = 25,
				[19] = 19,
				[20] = 26,
				[21] = 24,
				[22] = 22,
				[23] = 27,
				[24] = 28,
				[25] = 29,
				[26] = 15,
				[27] = 2,
				[28] = 23,
				[29] = 18,
			},
			{
				[1] = 9,
				[2] = 8,
				[3] = 6,
				[4] = 1,
				[5] = 7,
				[6] = 10,
				[7] = 3,
				[8] = 17,
				[9] = 13,
				[10] = 15,
				[11] = 5,
				[12] = 11,
				[13] = 2,
				[14] = 4,
				[15] = 12,
				[16] = 14,
				[17] = 21,
				[18] = 20,
				[19] = 23,
				[20] = 16,
				[21] = 24,
				[22] = 19,
				[23] = 22,
				[24] = 25,
				[25] = 26,
				[26] = 18,
			},
		},
		VMap = {
			{
				[1] = 4,
				[2] = 3,
				[3] = 1,
				[4] = 11,
				[5] = 14,
				[6] = 9,
				[7] = 8,
				[8] = 5,
				[9] = 6,
				[10] = 13,
				[11] = 12,
				[12] = 2,
				[13] = 15,
				[14] = 16,
				[15] = 10,
				[16] = 7,
				[17] = 22,
				[18] = 25,
				[19] = 19,
				[20] = 17,
				[21] = 20,
				[22] = 18,
				[23] = 21,
				[24] = 24,
				[25] = 23,
			},
			{
				[1] = 6,
				[2] = 27,
				[3] = 9,
				[4] = 5,
				[5] = 8,
				[6] = 3,
				[7] = 4,
				[8] = 7,
				[9] = 12,
				[10] = 1,
				[11] = 2,
				[12] = 10,
				[13] = 15,
				[14] = 11,
				[15] = 26,
				[16] = 16,
				[17] = 14,
				[18] = 29,
				[19] = 19,
				[20] = 17,
				[21] = 13,
				[22] = 22,
				[23] = 28,
				[24] = 21,
				[25] = 18,
				[26] = 20,
				[27] = 23,
				[28] = 24,
				[29] = 25,
			},
			{
				[1] = 4,
				[2] = 13,
				[3] = 7,
				[4] = 14,
				[5] = 11,
				[6] = 3,
				[7] = 5,
				[8] = 2,
				[9] = 1,
				[10] = 6,
				[11] = 12,
				[12] = 15,
				[13] = 9,
				[14] = 16,
				[15] = 10,
				[16] = 20,
				[17] = 8,
				[18] = 26,
				[19] = 22,
				[20] = 18,
				[21] = 17,
				[22] = 23,
				[23] = 19,
				[24] = 21,
				[25] = 24,
				[26] = 25,
			},
		},
	},
	MAGE = {
		RMap = {
			{
				[1] = 1,
				[2] = 6,
				[3] = 2,
				[4] = 17,
				[5] = 3,
				[6] = 8,
				[7] = 7,
				[8] = 11,
				[9] = 4,
				[10] = 16,
				[11] = 22,
				[12] = 12,
				[13] = 19,
				[14] = 13,
				[15] = 5,
				[16] = 15,
				[17] = 20,
				[18] = 18,
				[19] = 21,
				[20] = 25,
				[21] = 26,
				[22] = 29,
				[23] = 24,
				[24] = 23,
				[25] = 9,
				[26] = 28,
				[27] = 30,
				[28] = 27,
				[29] = 10,
				[30] = 14,
			},
			{
				[1] = 10,
				[2] = 12,
				[3] = 11,
				[4] = 3,
				[5] = 1,
				[6] = 7,
				[7] = 9,
				[8] = 8,
				[9] = 6,
				[10] = 16,
				[11] = 15,
				[12] = 4,
				[13] = 18,
				[14] = 20,
				[15] = 2,
				[16] = 13,
				[17] = 14,
				[18] = 17,
				[19] = 21,
				[20] = 19,
				[21] = 23,
				[22] = 25,
				[23] = 22,
				[24] = 24,
				[25] = 26,
				[26] = 27,
				[27] = 28,
				[28] = 5,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 8,
				[4] = 3,
				[5] = 10,
				[6] = 15,
				[7] = 7,
				[8] = 12,
				[9] = 13,
				[10] = 18,
				[11] = 9,
				[12] = 5,
				[13] = 20,
				[14] = 14,
				[15] = 4,
				[16] = 11,
				[17] = 6,
				[18] = 16,
				[19] = 17,
				[20] = 21,
				[21] = 22,
				[22] = 25,
				[23] = 23,
				[24] = 24,
				[25] = 26,
				[26] = 27,
				[27] = 28,
				[28] = 19,
			},
		},
		VMap = {
			{
				[1] = 1,
				[2] = 3,
				[3] = 5,
				[4] = 9,
				[5] = 15,
				[6] = 2,
				[7] = 7,
				[8] = 6,
				[9] = 25,
				[10] = 29,
				[11] = 8,
				[12] = 12,
				[13] = 14,
				[14] = 30,
				[15] = 16,
				[16] = 10,
				[17] = 4,
				[18] = 18,
				[19] = 13,
				[20] = 17,
				[21] = 19,
				[22] = 11,
				[23] = 24,
				[24] = 23,
				[25] = 20,
				[26] = 21,
				[27] = 28,
				[28] = 26,
				[29] = 22,
				[30] = 27,
			},
			{
				[1] = 5,
				[2] = 15,
				[3] = 4,
				[4] = 12,
				[5] = 28,
				[6] = 9,
				[7] = 6,
				[8] = 8,
				[9] = 7,
				[10] = 1,
				[11] = 3,
				[12] = 2,
				[13] = 16,
				[14] = 17,
				[15] = 11,
				[16] = 10,
				[17] = 18,
				[18] = 13,
				[19] = 20,
				[20] = 14,
				[21] = 19,
				[22] = 23,
				[23] = 21,
				[24] = 24,
				[25] = 22,
				[26] = 25,
				[27] = 26,
				[28] = 27,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 4,
				[4] = 15,
				[5] = 12,
				[6] = 17,
				[7] = 7,
				[8] = 3,
				[9] = 11,
				[10] = 5,
				[11] = 16,
				[12] = 8,
				[13] = 9,
				[14] = 14,
				[15] = 6,
				[16] = 18,
				[17] = 19,
				[18] = 10,
				[19] = 28,
				[20] = 13,
				[21] = 20,
				[22] = 21,
				[23] = 23,
				[24] = 24,
				[25] = 22,
				[26] = 25,
				[27] = 26,
				[28] = 27,
			},
		},
	},
	PRIEST = {
		RMap = {
			{
				[1] = 6,
				[2] = 19,
				[3] = 11,
				[4] = 1,
				[5] = 9,
				[6] = 5,
				[7] = 4,
				[8] = 7,
				[9] = 8,
				[10] = 12,
				[11] = 15,
				[12] = 3,
				[13] = 14,
				[14] = 27,
				[15] = 10,
				[16] = 16,
				[17] = 17,
				[18] = 20,
				[19] = 25,
				[20] = 18,
				[21] = 23,
				[22] = 24,
				[23] = 22,
				[24] = 28,
				[25] = 2,
				[26] = 26,
				[27] = 21,
				[28] = 13,
			},
			{
				[1] = 8,
				[2] = 3,
				[3] = 14,
				[4] = 11,
				[5] = 16,
				[6] = 2,
				[7] = 10,
				[8] = 1,
				[9] = 4,
				[10] = 12,
				[11] = 6,
				[12] = 5,
				[13] = 13,
				[14] = 9,
				[15] = 7,
				[16] = 18,
				[17] = 19,
				[18] = 15,
				[19] = 21,
				[20] = 17,
				[21] = 24,
				[22] = 23,
				[23] = 25,
				[24] = 22,
				[25] = 26,
				[26] = 27,
				[27] = 20,
			},
			{
				[1] = 12,
				[2] = 3,
				[3] = 6,
				[4] = 1,
				[5] = 4,
				[6] = 8,
				[7] = 5,
				[8] = 10,
				[9] = 14,
				[10] = 9,
				[11] = 19,
				[12] = 13,
				[13] = 7,
				[14] = 11,
				[15] = 15,
				[16] = 16,
				[17] = 20,
				[18] = 24,
				[19] = 17,
				[20] = 22,
				[21] = 21,
				[22] = 26,
				[23] = 23,
				[24] = 25,
				[25] = 27,
				[26] = 2,
				[27] = 18,
			},
		},
		VMap = {
			{
				[1] = 4,
				[2] = 25,
				[3] = 12,
				[4] = 7,
				[5] = 6,
				[6] = 1,
				[7] = 8,
				[8] = 9,
				[9] = 5,
				[10] = 15,
				[11] = 3,
				[12] = 10,
				[13] = 28,
				[14] = 13,
				[15] = 11,
				[16] = 16,
				[17] = 17,
				[18] = 20,
				[19] = 2,
				[20] = 18,
				[21] = 27,
				[22] = 23,
				[23] = 21,
				[24] = 22,
				[25] = 19,
				[26] = 26,
				[27] = 14,
				[28] = 24,
			},
			{
				[1] = 8,
				[2] = 6,
				[3] = 2,
				[4] = 9,
				[5] = 12,
				[6] = 11,
				[7] = 15,
				[8] = 1,
				[9] = 14,
				[10] = 7,
				[11] = 4,
				[12] = 10,
				[13] = 13,
				[14] = 3,
				[15] = 18,
				[16] = 5,
				[17] = 20,
				[18] = 16,
				[19] = 17,
				[20] = 27,
				[21] = 19,
				[22] = 24,
				[23] = 22,
				[24] = 21,
				[25] = 23,
				[26] = 25,
				[27] = 26,
			},
			{
				[1] = 4,
				[2] = 26,
				[3] = 2,
				[4] = 5,
				[5] = 7,
				[6] = 3,
				[7] = 13,
				[8] = 6,
				[9] = 10,
				[10] = 8,
				[11] = 14,
				[12] = 1,
				[13] = 12,
				[14] = 9,
				[15] = 15,
				[16] = 16,
				[17] = 19,
				[18] = 27,
				[19] = 11,
				[20] = 17,
				[21] = 21,
				[22] = 20,
				[23] = 23,
				[24] = 18,
				[25] = 24,
				[26] = 22,
				[27] = 25,
			},
		},
	},
	WARLOCK = {
		VMap = {
			{
				[1] = 15,
				[2] = 5,
				[3] = 3,
				[4] = 6,
				[5] = 14,
				[6] = 7,
				[7] = 4,
				[8] = 27,
				[9] = 1,
				[10] = 12,
				[11] = 8,
				[12] = 2,
				[13] = 21,
				[14] = 20,
				[15] = 10,
				[16] = 13,
				[17] = 22,
				[18] = 11,
				[19] = 25,
				[20] = 18,
				[21] = 9,
				[22] = 17,
				[23] = 16,
				[24] = 23,
				[25] = 19,
				[26] = 28,
				[27] = 24,
				[28] = 26,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 3,
				[4] = 23,
				[5] = 4,
				[6] = 5,
				[7] = 8,
				[8] = 9,
				[9] = 15,
				[10] = 6,
				[11] = 17,
				[12] = 12,
				[13] = 7,
				[14] = 14,
				[15] = 11,
				[16] = 10,
				[17] = 16,
				[18] = 20,
				[19] = 21,
				[20] = 13,
				[21] = 19,
				[22] = 27,
				[23] = 22,
				[24] = 18,
				[25] = 24,
				[26] = 25,
				[27] = 26,
			},
			{
				[1] = 3,
				[2] = 2,
				[3] = 12,
				[4] = 21,
				[5] = 1,
				[6] = 13,
				[7] = 5,
				[8] = 9,
				[9] = 14,
				[10] = 6,
				[11] = 7,
				[12] = 20,
				[13] = 4,
				[14] = 11,
				[15] = 19,
				[16] = 8,
				[17] = 10,
				[18] = 18,
				[19] = 15,
				[20] = 17,
				[21] = 23,
				[22] = 22,
				[23] = 16,
				[24] = 26,
				[25] = 24,
				[26] = 25,
			},
		},
		RMap = {
			{
				[1] = 9,
				[2] = 12,
				[3] = 3,
				[4] = 7,
				[5] = 2,
				[6] = 4,
				[7] = 6,
				[8] = 11,
				[9] = 21,
				[10] = 15,
				[11] = 18,
				[12] = 10,
				[13] = 16,
				[14] = 5,
				[15] = 1,
				[16] = 23,
				[17] = 22,
				[18] = 20,
				[19] = 25,
				[20] = 14,
				[21] = 13,
				[22] = 17,
				[23] = 24,
				[24] = 27,
				[25] = 19,
				[26] = 28,
				[27] = 8,
				[28] = 26,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 3,
				[4] = 5,
				[5] = 6,
				[6] = 10,
				[7] = 13,
				[8] = 7,
				[9] = 8,
				[10] = 16,
				[11] = 15,
				[12] = 12,
				[13] = 20,
				[14] = 14,
				[15] = 9,
				[16] = 17,
				[17] = 11,
				[18] = 24,
				[19] = 21,
				[20] = 18,
				[21] = 19,
				[22] = 23,
				[23] = 4,
				[24] = 25,
				[25] = 26,
				[26] = 27,
				[27] = 22,
			},
			{
				[1] = 5,
				[2] = 2,
				[3] = 1,
				[4] = 13,
				[5] = 7,
				[6] = 10,
				[7] = 11,
				[8] = 16,
				[9] = 8,
				[10] = 17,
				[11] = 14,
				[12] = 3,
				[13] = 6,
				[14] = 9,
				[15] = 19,
				[16] = 23,
				[17] = 20,
				[18] = 18,
				[19] = 15,
				[20] = 12,
				[21] = 4,
				[22] = 22,
				[23] = 21,
				[24] = 25,
				[25] = 26,
				[26] = 24,
			},
		},
	},
	HUNTER = {
		VMap = {
			{
				[1] = 2,
				[2] = 8,
				[3] = 14,
				[4] = 1,
				[5] = 11,
				[6] = 15,
				[7] = 3,
				[8] = 23,
				[9] = 12,
				[10] = 4,
				[11] = 10,
				[12] = 7,
				[13] = 6,
				[14] = 9,
				[15] = 16,
				[16] = 13,
				[17] = 17,
				[18] = 5,
				[19] = 18,
				[20] = 21,
				[21] = 19,
				[22] = 25,
				[23] = 20,
				[24] = 22,
				[25] = 26,
				[26] = 24,
			},
			{
				[1] = 1,
				[2] = 27,
				[3] = 4,
				[4] = 15,
				[5] = 3,
				[6] = 9,
				[7] = 18,
				[8] = 6,
				[9] = 5,
				[10] = 19,
				[11] = 8,
				[12] = 2,
				[13] = 10,
				[14] = 11,
				[15] = 7,
				[16] = 14,
				[17] = 13,
				[18] = 21,
				[19] = 12,
				[20] = 20,
				[21] = 16,
				[22] = 22,
				[23] = 23,
				[24] = 17,
				[25] = 24,
				[26] = 25,
				[27] = 26,
			},
			{
				[1] = 14,
				[2] = 21,
				[3] = 12,
				[4] = 6,
				[5] = 2,
				[6] = 3,
				[7] = 16,
				[8] = 13,
				[9] = 20,
				[10] = 7,
				[11] = 5,
				[12] = 28,
				[13] = 4,
				[14] = 27,
				[15] = 9,
				[16] = 8,
				[17] = 1,
				[18] = 15,
				[19] = 18,
				[20] = 11,
				[21] = 17,
				[22] = 19,
				[23] = 22,
				[24] = 23,
				[25] = 10,
				[26] = 24,
				[27] = 25,
				[28] = 26,
			},
		},
		RMap = {
			{
				[1] = 4,
				[2] = 1,
				[3] = 7,
				[4] = 10,
				[5] = 18,
				[6] = 13,
				[7] = 12,
				[8] = 2,
				[9] = 14,
				[10] = 11,
				[11] = 5,
				[12] = 9,
				[13] = 16,
				[14] = 3,
				[15] = 6,
				[16] = 15,
				[17] = 17,
				[18] = 19,
				[19] = 21,
				[20] = 23,
				[21] = 20,
				[22] = 24,
				[23] = 8,
				[24] = 26,
				[25] = 22,
				[26] = 25,
			},
			{
				[1] = 1,
				[2] = 12,
				[3] = 5,
				[4] = 3,
				[5] = 9,
				[6] = 8,
				[7] = 15,
				[8] = 11,
				[9] = 6,
				[10] = 13,
				[11] = 14,
				[12] = 19,
				[13] = 17,
				[14] = 16,
				[15] = 4,
				[16] = 21,
				[17] = 24,
				[18] = 7,
				[19] = 10,
				[20] = 20,
				[21] = 18,
				[22] = 22,
				[23] = 23,
				[24] = 25,
				[25] = 26,
				[26] = 27,
				[27] = 2,
			},
			{
				[1] = 17,
				[2] = 5,
				[3] = 6,
				[4] = 13,
				[5] = 11,
				[6] = 4,
				[7] = 10,
				[8] = 16,
				[9] = 15,
				[10] = 25,
				[11] = 20,
				[12] = 3,
				[13] = 8,
				[14] = 1,
				[15] = 18,
				[16] = 7,
				[17] = 21,
				[18] = 19,
				[19] = 22,
				[20] = 9,
				[21] = 2,
				[22] = 23,
				[23] = 24,
				[24] = 26,
				[25] = 27,
				[26] = 28,
				[27] = 14,
				[28] = 12,
			},
		},
	},
	PALADIN = {
		VMap = {
			{
				[1] = 1,
				[2] = 10,
				[3] = 5,
				[4] = 7,
				[5] = 14,
				[6] = 3,
				[7] = 9,
				[8] = 4,
				[9] = 8,
				[10] = 6,
				[11] = 25,
				[12] = 15,
				[13] = 2,
				[14] = 11,
				[15] = 16,
				[16] = 13,
				[17] = 18,
				[18] = 12,
				[19] = 17,
				[20] = 21,
				[21] = 19,
				[22] = 20,
				[23] = 26,
				[24] = 24,
				[25] = 22,
				[26] = 23,
			},
			{
				[1] = 9,
				[2] = 18,
				[3] = 13,
				[4] = 4,
				[5] = 12,
				[6] = 24,
				[7] = 10,
				[8] = 3,
				[9] = 25,
				[10] = 11,
				[11] = 2,
				[12] = 8,
				[13] = 5,
				[14] = 14,
				[15] = 6,
				[16] = 26,
				[17] = 7,
				[18] = 15,
				[19] = 1,
				[20] = 16,
				[21] = 20,
				[22] = 17,
				[23] = 19,
				[24] = 23,
				[25] = 22,
				[26] = 21,
			},
			{
				[1] = 3,
				[2] = 4,
				[3] = 10,
				[4] = 8,
				[5] = 1,
				[6] = 12,
				[7] = 6,
				[8] = 9,
				[9] = 13,
				[10] = 11,
				[11] = 19,
				[12] = 14,
				[13] = 5,
				[14] = 15,
				[15] = 2,
				[16] = 16,
				[17] = 25,
				[18] = 7,
				[19] = 17,
				[20] = 18,
				[21] = 21,
				[22] = 22,
				[23] = 20,
				[24] = 26,
				[25] = 23,
				[26] = 24,
			},
		},
		RMap = {
			{
				[1] = 1,
				[2] = 13,
				[3] = 6,
				[4] = 8,
				[5] = 3,
				[6] = 10,
				[7] = 4,
				[8] = 9,
				[9] = 7,
				[10] = 2,
				[11] = 14,
				[12] = 18,
				[13] = 16,
				[14] = 5,
				[15] = 12,
				[16] = 15,
				[17] = 19,
				[18] = 17,
				[19] = 21,
				[20] = 22,
				[21] = 20,
				[22] = 25,
				[23] = 26,
				[24] = 24,
				[25] = 11,
				[26] = 23,
			},
			{
				[1] = 19,
				[2] = 11,
				[3] = 8,
				[4] = 4,
				[5] = 13,
				[6] = 15,
				[7] = 17,
				[8] = 12,
				[9] = 1,
				[10] = 7,
				[11] = 10,
				[12] = 5,
				[13] = 3,
				[14] = 14,
				[15] = 18,
				[16] = 20,
				[17] = 22,
				[18] = 2,
				[19] = 23,
				[20] = 21,
				[21] = 26,
				[22] = 25,
				[23] = 24,
				[24] = 6,
				[25] = 9,
				[26] = 16,
			},
			{
				[1] = 5,
				[2] = 15,
				[3] = 1,
				[4] = 2,
				[5] = 13,
				[6] = 7,
				[7] = 18,
				[8] = 4,
				[9] = 8,
				[10] = 3,
				[11] = 10,
				[12] = 6,
				[13] = 9,
				[14] = 12,
				[15] = 14,
				[16] = 16,
				[17] = 19,
				[18] = 20,
				[19] = 11,
				[20] = 23,
				[21] = 21,
				[22] = 22,
				[23] = 25,
				[24] = 26,
				[25] = 17,
				[26] = 24,
			},
		},
	},
	ROGUE = {
		VMap = {
			{
				[1] = 7,
				[2] = 4,
				[3] = 3,
				[4] = 5,
				[5] = 24,
				[6] = 8,
				[7] = 14,
				[8] = 9,
				[9] = 2,
				[10] = 15,
				[11] = 1,
				[12] = 19,
				[13] = 11,
				[14] = 10,
				[15] = 21,
				[16] = 13,
				[17] = 6,
				[18] = 22,
				[19] = 12,
				[20] = 20,
				[21] = 25,
				[22] = 17,
				[23] = 16,
				[24] = 18,
				[25] = 23,
				[26] = 26,
				[27] = 27,
			},
			{
				[1] = 7,
				[2] = 6,
				[3] = 11,
				[4] = 23,
				[5] = 5,
				[6] = 1,
				[7] = 8,
				[8] = 15,
				[9] = 2,
				[10] = 10,
				[11] = 12,
				[12] = 4,
				[13] = 16,
				[14] = 3,
				[15] = 13,
				[16] = 14,
				[17] = 17,
				[18] = 19,
				[19] = 18,
				[20] = 9,
				[21] = 20,
				[22] = 24,
				[23] = 22,
				[24] = 25,
				[25] = 21,
				[26] = 26,
				[27] = 27,
				[28] = 28,
			},
			{
				[1] = 28,
				[2] = 1,
				[3] = 6,
				[4] = 15,
				[5] = 7,
				[6] = 2,
				[7] = 5,
				[8] = 11,
				[9] = 14,
				[10] = 4,
				[11] = 3,
				[12] = 8,
				[13] = 16,
				[14] = 10,
				[15] = 9,
				[16] = 13,
				[17] = 20,
				[18] = 17,
				[19] = 18,
				[20] = 12,
				[21] = 22,
				[22] = 19,
				[23] = 23,
				[24] = 24,
				[25] = 21,
				[26] = 25,
				[27] = 26,
				[28] = 27,
			},
		},
		RMap = {
			{
				[1] = 11,
				[2] = 9,
				[3] = 3,
				[4] = 2,
				[5] = 4,
				[6] = 17,
				[7] = 1,
				[8] = 6,
				[9] = 8,
				[10] = 14,
				[11] = 13,
				[12] = 19,
				[13] = 16,
				[14] = 7,
				[15] = 10,
				[16] = 23,
				[17] = 22,
				[18] = 24,
				[19] = 12,
				[20] = 20,
				[21] = 15,
				[22] = 18,
				[23] = 25,
				[24] = 5,
				[25] = 21,
				[26] = 26,
				[27] = 27,
			},
			{
				[1] = 6,
				[2] = 9,
				[3] = 14,
				[4] = 12,
				[5] = 5,
				[6] = 2,
				[7] = 1,
				[8] = 7,
				[9] = 20,
				[10] = 10,
				[11] = 3,
				[12] = 11,
				[13] = 15,
				[14] = 16,
				[15] = 8,
				[16] = 13,
				[17] = 17,
				[18] = 19,
				[19] = 18,
				[20] = 21,
				[21] = 25,
				[22] = 23,
				[23] = 4,
				[24] = 22,
				[25] = 24,
				[26] = 26,
				[27] = 27,
				[28] = 28,
			},
			{
				[1] = 2,
				[2] = 6,
				[3] = 11,
				[4] = 10,
				[5] = 7,
				[6] = 3,
				[7] = 5,
				[8] = 12,
				[9] = 15,
				[10] = 14,
				[11] = 8,
				[12] = 20,
				[13] = 16,
				[14] = 9,
				[15] = 4,
				[16] = 13,
				[17] = 18,
				[18] = 19,
				[19] = 22,
				[20] = 17,
				[21] = 25,
				[22] = 21,
				[23] = 23,
				[24] = 24,
				[25] = 26,
				[26] = 27,
				[27] = 28,
				[28] = 1,
			},
		},
	},
};

DT.LevelAvailablePointsTable = {  };
for i = 1, 9 do DT.LevelAvailablePointsTable[i] = 0; end
for i = 10, DT.MAX_LEVEL do DT.LevelAvailablePointsTable[i] = i - 9; end

DT.LevelAvailablePointsTableClass = {  };
local DK = {  };
for i = 1, 54 do DK[i] = 0; end
for i = 55, DT.MAX_LEVEL do DK[i] = i - 9; end
DT.LevelAvailablePointsTableClass.DEATHKNIGHT = DK;

DT.ItemLevelColor = {
	--	NAXX/EOE/OS	200/213/226
	--	ULD			225/232, 239/245/252
	--	TOC/ONY		232/245/252, 245/258/272
	--	ICC			251/258/264/271, 264/271/277/284
	--	RS			258/271, 271/284
	step = {
		164,	--	灰色
		187,	--	白色
		200,	--	绿色
		226,	--	蓝色
		239,	--	紫色
		252,	--	橙色
	},
	list = {
		{ 0.5, 0.5, 0.5, },	--	灰色
		{ 1.0, 1.0, 1.0, },	--	白色
		{ 0.0, 1.0, 0.0, },	--	绿色
		{ 0.0, 0.5, 1.0, },	--	蓝色
		{ 0.6, 0.2, 1.0, },	--	紫色
		{ 1.0, 0.5, 0.0, },	--	橙色
	},
};

--	enchantID, spellID, itemID, classID, subClassMask, invTypeMask
local RawEnchantDB = {
	{ 15, 2831, 2304, 4, 30, 1050016, },
	{ 16, 2832, 2313, 4, 30, 1050016, },
	{ 17, 2833, 4265, 4, 30, 1050016, },
	{ 18, 10344, 8173, 4, 30, 1050016, },
	{ 24, 7443, 38769, 4, 31, 1048608, },
	{ 30, 3974, 4405, 2, 262156, nil, },
	{ 32, 3975, 4406, 2, 262156, nil, },
	{ 33, 3976, 4407, 2, 262156, nil, },
	{ 34, 7218, 6043, 2, 354, nil, },
	{ 36, 6296, 5421, 2, 189939, nil, },
	{ 37, 7220, 6041, 2, 173555, nil, },
	{ 41, 7418, 38679, 4, 31, 512, },
	{ 41, 7420, 38766, 4, 31, 1048608, },
	{ 43, 7216, 6042, 4, 96, nil, },
	{ 44, 7426, 38767, 4, 31, 1048608, },
	{ 63, 13538, 38798, 4, 31, 1048608, },
	{ 65, 7454, 38770, 4, 31, 65536, },
	{ 66, 7457, 38771, 4, 31, 512, },
	{ 66, 7863, 38785, 4, 31, 256, },
	{ 66, 13378, 38787, 4, 64, nil, },
	{ 241, 7745, 38772, 2, 1378, nil, },
	{ 241, 13503, 38794, 2, 189939, nil, },
	{ 242, 7748, 38773, 4, 31, 1048608, },
	{ 243, 7766, 38774, 4, 31, 512, },
	{ 246, 7776, 38776, 4, 31, 1048608, },
	{ 247, 7779, 38777, 4, 31, 512, },
	{ 247, 7867, 38786, 4, 31, 256, },
	{ 247, 13419, 38789, 4, 30, 65536, },
	{ 248, 7782, 38778, 4, 31, 512, },
	{ 249, 7786, 38779, 2, 189939, nil, },
	{ 250, 7788, 38780, 2, 189939, nil, },
	{ 254, 7857, 38782, 4, 31, 1048608, },
	{ 255, 7859, 38783, 4, 31, 512, },
	{ 255, 13380, 38788, 2, 1378, nil, },
	{ 255, 13485, 38792, 4, 64, nil, },
	{ 255, 13687, 38819, 4, 30, 256, },
	{ 256, 7861, 38784, 4, 31, 65536, },
	{ 368, 34004, 35432, 4, 30, 65536, },
	{ 369, 34001, 35423, 4, 30, 512, },
	{ 463, 9781, 7967, 4, 96, nil, },
	{ 464, 9783, 7969, 4, nil, 256, },
	{ 663, 12459, 10546, 2, 262156, nil, },
	{ 664, 12460, 10548, 2, 262156, nil, },
	{ 684, 33995, 35442, 4, 31, 1024, },
	{ 723, 7793, 38781, 2, 1378, nil, },
	{ 723, 13622, 38803, 4, 31, 512, },
	{ 724, 13501, 38793, 4, 31, 512, },
	{ 724, 13631, 38805, 4, 64, nil, },
	{ 724, 13644, 38810, 4, 30, 256, },
	{ 744, 13421, 38790, 4, nil, 65536, },
	{ 783, 7771, 38775, 4, 31, 65536, },
	{ 803, 13898, 38838, 2, 189939, nil, },
	{ 804, 13522, 38795, 4, 31, 65536, },
	{ 805, 13943, 38848, 2, 189939, nil, },
	{ 823, 13536, 38797, 4, 31, 512, },
	{ 843, 13607, 38799, 4, 31, 1048608, },
	{ 844, 13612, 38800, 4, 31, 1024, },
	{ 845, 13617, 38801, 4, 31, 1024, },
	{ 846, 24302, 19971, 2, 1048576, nil, },
	{ 846, 71692, 50816, 4, 31, 1024, },
	{ 847, 13626, 38804, 4, 31, 1048608, },
	{ 848, 13464, 38791, 4, 64, nil, },
	{ 848, 13635, 38806, 4, 30, 65536, },
	{ 849, 13637, 38807, 4, 31, 256, },
	{ 849, 13882, 38835, 4, 30, 65536, },
	{ 850, 13640, 38808, 4, 30, 1048608, },
	{ 851, 13642, 38809, 4, 30, 512, },
	{ 851, 13659, 38816, 4, 64, nil, },
	{ 851, 20024, 38864, 4, 30, 256, },
	{ 852, 13648, 38812, 4, 30, 512, },
	{ 852, 13817, 38828, 4, 64, nil, },
	{ 852, 13836, 38830, 4, 30, 256, },
	{ 853, 13653, 38813, 2, 189939, nil, },
	{ 854, 13655, 38814, 2, 189939, nil, },
	{ 856, 13661, 38817, 4, 30, 512, },
	{ 856, 13887, 38836, 4, 31, 1024, },
	{ 857, 13663, 38818, 4, 30, 1048608, },
	{ 863, 13689, 38820, 4, 64, nil, },
	{ 865, 13698, 38823, 4, 31, 1024, },
	{ 866, 13700, 38824, 4, 31, 1048608, },
	{ 884, 13746, 38825, 4, 30, 65536, },
	{ 903, 13794, 38826, 4, 30, 65536, },
	{ 904, 13815, 38827, 4, 31, 1024, },
	{ 904, 13935, 38844, 4, 30, 256, },
	{ 905, 13822, 38829, 4, 30, 512, },
	{ 906, 13841, 38831, 4, 31, 1024, },
	{ 907, 13846, 38832, 4, 30, 512, },
	{ 907, 13905, 38839, 4, 64, nil, },
	{ 908, 13858, 38833, 4, 31, 1048608, },
	{ 909, 13868, 38834, 4, 31, 1024, },
	{ 910, 25083, 38893, 4, 31, 65536, },
	{ 910, 359640, 187738, 4, 30, 65536, },
	{ 911, 13890, 38837, 4, 30, 256, },
	{ 912, 13915, 38840, 2, 189939, nil, },
	{ 913, 13917, 38841, 4, 31, 1048608, },
	{ 923, 13931, 38842, 4, 30, 512, },
	{ 924, 7428, 38768, 4, 31, 512, },
	{ 925, 13646, 38811, 4, 30, 512, },
	{ 926, 13933, 38843, 4, 64, nil, },
	{ 926, 359895, 187814, 4, 64, nil, },
	{ 927, 13939, 38846, 4, 30, 512, },
	{ 927, 20013, 38857, 4, 31, 1024, },
	{ 928, 13941, 38847, 4, 31, 1048608, },
	{ 929, 13945, 38849, 4, 30, 512, },
	{ 929, 20017, 38861, 4, 64, nil, },
	{ 929, 20020, 38862, 4, 30, 256, },
	{ 930, 13947, 38850, 4, 31, 1024, },
	{ 931, 13948, 38851, 4, 31, 1024, },
	{ 943, 13529, 38796, 2, 1378, nil, },
	{ 943, 13693, 38821, 2, 189939, nil, },
	{ 963, 13937, 38845, 2, 1378, nil, },
	{ 963, 27967, 35457, 2, 189939, nil, },
	{ 983, 44500, 38959, 4, 30, 65536, },
	{ 983, 44589, 38976, 4, 30, 256, },
	{ 1071, 34009, 35449, 4, 64, nil, },
	{ 1075, 44528, 38966, 4, 30, 256, },
	{ 1099, 60663, 44457, 4, 30, 65536, },
	{ 1103, 44633, 38995, 2, 177651, nil, },
	{ 1119, 44555, 38968, 4, 30, 512, },
	{ 1119, 47715, nil, 4, 30, 512, },
	{ 1128, 60653, 44455, 4, 64, nil, },
	{ 1144, 33990, 35431, 4, 31, 1048608, },
	{ 1147, 44508, 38961, 4, 30, 256, },
	{ 1147, 44593, 38980, 4, 30, 512, },
	{ 1257, 34005, 35433, 4, 30, 65536, },
	{ 1262, 44596, 38982, 4, 30, 65536, },
	{ 1354, 44556, 38969, 4, 30, 65536, },
	{ 1400, 44494, 38956, 4, 30, 65536, },
	{ 1441, 34006, 35434, 4, 30, 65536, },
	{ 1446, 44590, 38977, 4, 30, 65536, },
	{ 1483, 15340, 11622, 4, 31, 130, },
	{ 1503, 15389, 11642, 4, 31, 130, },
	{ 1504, 15391, 11643, 4, 31, 130, },
	{ 1505, 15394, 11644, 4, 31, 130, },
	{ 1506, 15397, 11645, 4, 31, 130, },
	{ 1507, 15400, 11646, 4, 31, 130, },
	{ 1508, 15402, 11647, 4, 31, 130, },
	{ 1509, 15404, 11648, 4, 31, 130, },
	{ 1510, 15406, 11649, 4, 31, 130, },
	{ 1593, 34002, 38938, 4, 30, 512, },
	{ 1593, 359639, 187737, 4, 30, 512, },
	{ 1594, 33996, 35438, 4, 31, 1024, },
	{ 1597, 60763, 44469, 4, 30, 256, },
	{ 1600, 60616, 38971, 4, 30, 512, },
	{ 1603, 60668, 44458, 4, 30, 1024, },
	{ 1606, 60621, 44453, 2, 189939, nil, },
	{ 1704, 16623, 12645, 4, 96, nil, },
	{ 1843, 19057, 15564, 4, 30, 1050016, },
	{ 1883, 20008, 38852, 4, 30, 512, },
	{ 1884, 20009, 38853, 4, 30, 512, },
	{ 1885, 20010, 38854, 4, 30, 512, },
	{ 1886, 20011, 38855, 4, 30, 512, },
	{ 1887, 20012, 38856, 4, 31, 1024, },
	{ 1887, 20023, 38863, 4, 30, 256, },
	{ 1888, 20014, 38858, 4, 30, 65536, },
	{ 1888, 27947, 35450, 4, 64, nil, },
	{ 1889, 20015, 38859, 4, 30, 65536, },
	{ 1890, 20016, 38860, 4, 64, nil, },
	{ 1891, 20025, 38865, 4, 31, 1048608, },
	{ 1891, 27905, 35426, 4, 30, 512, },
	{ 1892, 20026, 38866, 4, 31, 1048608, },
	{ 1893, 20028, 38867, 4, 31, 1048608, },
	{ 1894, 20029, 38868, 2, 189939, nil, },
	{ 1896, 20030, 38869, 2, 1378, nil, },
	{ 1897, 13695, 38822, 2, 1378, nil, },
	{ 1897, 20031, 38870, 2, 189939, nil, },
	{ 1898, 20032, 38871, 2, 189939, nil, },
	{ 1898, 27964, 38916, 2, 189939, nil, },
	{ 1899, 20033, 38872, 2, 189939, nil, },
	{ 1900, 20034, 38873, 2, 189939, nil, },
	{ 1903, 20035, 38874, 2, 1378, nil, },
	{ 1904, 20036, 38875, 2, 1378, nil, },
	{ 1951, 44591, 38978, 4, 30, 65536, },
	{ 1951, 46594, 38999, 4, 31, 1048608, },
	{ 1952, 44489, 38954, 4, 64, nil, },
	{ 1953, 47766, 39002, 4, 31, 1048608, },
	{ 2322, 33999, 35440, 4, 31, 1024, },
	{ 2326, 44635, 38997, 4, 30, 512, },
	{ 2332, 60767, 44470, 4, 30, 512, },
	{ 2381, 44509, 38962, 4, 30, 1048608, },
	{ 2443, 21931, 38876, 2, 196083, nil, },
	{ 2463, 13657, 38815, 4, 30, 65536, },
	{ 2483, 22593, 18169, 4, 30, 8, },
	{ 2484, 22594, 18170, 4, 30, 8, },
	{ 2485, 22598, 18171, 4, 30, 8, },
	{ 2486, 22597, 18172, 4, 30, 8, },
	{ 2487, 22596, 18173, 4, 30, 8, },
	{ 2488, 22599, 18182, 4, 30, 8, },
	{ 2503, 22725, 18251, 4, 30, 1050016, },
	{ 2504, 22749, 38877, 2, 58867, nil, },
	{ 2505, 22750, 38878, 2, 58867, nil, },
	{ 2523, 22779, 18283, 2, 262156, nil, },
	{ 2523, 30255, nil, 2, 262156, nil, },
	{ 2543, 22840, 18329, 4, 31, 130, },
	{ 2544, 22844, 18330, 4, 31, 130, },
	{ 2545, 22846, 18331, 4, 31, 130, },
	{ 2563, 23799, 38879, 2, 58867, nil, },
	{ 2564, 23800, 38880, 2, 58867, nil, },
	{ 2564, 25080, 38890, 4, 31, 1024, },
	{ 2564, 359641, 187739, 4, 30, 1024, },
	{ 2565, 23801, 38881, 4, 30, 512, },
	{ 2567, 23803, 38883, 2, 58867, nil, },
	{ 2567, 359642, 187740, 2, 58867, nil, },
	{ 2568, 23804, 38884, 2, 58867, nil, },
	{ 2583, 24149, 19782, 4, 31, 130, },
	{ 2584, 24160, 19783, 4, 31, 130, },
	{ 2587, 24163, 19786, 4, 31, 130, },
	{ 2588, 24164, 19787, 4, 31, 130, },
	{ 2589, 24165, 19788, 4, 31, 130, },
	{ 2590, 24167, 19789, 4, 31, 130, },
	{ 2591, 24168, 19790, 4, 31, 130, },
	{ 2603, 13620, 38802, 4, 31, 1024, },
	{ 2604, 24420, 20078, 4, 30, 8, },
	{ 2605, 24421, 20076, 4, 30, 8, },
	{ 2606, 24422, 20077, 4, 30, 8, },
	{ 2613, 25072, 38885, 4, 31, 1024, },
	{ 2613, 359858, 187801, 4, 31, 1024, },
	{ 2614, 25073, 38886, 4, 31, 1024, },
	{ 2615, 25074, 38887, 4, 31, 1024, },
	{ 2616, 25078, 38888, 4, 31, 1024, },
	{ 2617, 25079, 38889, 4, 31, 1024, },
	{ 2619, 25081, 38891, 4, 31, 65536, },
	{ 2619, 359950, 187815, 4, 30, 65536, },
	{ 2620, 25082, 38892, 4, 31, 65536, },
	{ 2620, 359949, 187807, 4, 30, 65536, },
	{ 2621, 25084, 38894, 4, 31, 65536, },
	{ 2621, 359847, 187800, 4, 30, 65536, },
	{ 2622, 25086, 38895, 4, 31, 65536, },
	{ 2646, 27837, 38896, 2, 1378, nil, },
	{ 2647, 27899, 35420, 4, 30, 512, },
	{ 2648, 27906, 35422, 4, 30, 512, },
	{ 2648, 47051, 39000, 4, 31, 65536, },
	{ 2649, 27914, 35421, 4, 30, 512, },
	{ 2649, 27950, 35417, 4, 30, 256, },
	{ 2650, 23802, 38882, 4, 30, 512, },
	{ 2650, 27911, 35427, 4, 30, 512, },
	{ 2650, 27917, 35425, 4, 30, 512, },
	{ 2653, 27944, 38904, 4, 64, nil, },
	{ 2654, 27945, 35448, 4, 64, nil, },
	{ 2655, 27946, 35451, 4, 64, nil, },
	{ 2656, 27948, 35419, 4, 30, 256, },
	{ 2657, 27951, 35400, 4, 30, 256, },
	{ 2658, 27954, 35418, 4, 30, 256, },
	{ 2659, 27957, 35428, 4, 31, 1048608, },
	{ 2661, 27960, 35429, 4, 31, 1048608, },
	{ 2661, 44616, 38987, 4, 30, 512, },
	{ 2662, 27961, 35437, 4, 30, 65536, },
	{ 2664, 27962, 35435, 4, 30, 65536, },
	{ 2666, 27968, 35455, 2, 58867, nil, },
	{ 2667, 27971, 35397, 2, 132450, nil, },
	{ 2668, 27972, 35459, 2, 189939, nil, },
	{ 2669, 27975, 35456, 2, 173555, nil, },
	{ 2670, 27977, 35396, 2, 132450, nil, },
	{ 2671, 27981, 35462, 2, 189939, nil, },
	{ 2672, 27982, 35460, 2, 189939, nil, },
	{ 2673, 27984, 35458, 2, 189939, nil, },
	{ 2674, 28003, 35461, 2, 189939, nil, },
	{ 2675, 28004, 35452, 2, 189939, nil, },
	{ 2679, 27913, 35424, 4, 30, 512, },
	{ 2681, 28161, 22635, 4, 31, 130, },
	{ 2682, 28163, 22636, 4, 31, 130, },
	{ 2683, 28165, 22638, 4, 31, 130, },
	{ 2714, 29454, 23530, 4, 96, nil, },
	{ 2715, 29475, 23547, 4, 30, 8, },
	{ 2716, 29480, 23549, 4, 30, 8, },
	{ 2717, 29483, 23548, 4, 30, 8, },
	{ 2721, 29467, 23545, 4, 30, 8, },
	{ 2722, 30250, 23764, 2, 262156, nil, },
	{ 2723, 30252, 23765, 2, 262156, nil, },
	{ 2724, 30258, nil, 2, 262156, nil, },
	{ 2724, 30260, 23766, 2, 262156, nil, },
	{ 2745, 31369, 24275, 4, 31, 128, },
	{ 2746, 31370, 24276, 4, 31, 128, },
	{ 2747, 31371, 24273, 4, 31, 128, },
	{ 2748, 31372, 24274, 4, 31, 128, },
	{ 2792, 32397, 25650, 4, 30, 1050016, },
	{ 2793, 32398, 25651, 4, 30, 1050016, },
	{ 2794, 32399, 25652, 4, 30, 1050016, },
	{ 2841, 44968, 34330, 4, 30, 1050026, },
	{ 2928, 27924, 35445, 4, nil, 2048, },
	{ 2929, 27920, 35447, 4, nil, 2048, },
	{ 2930, 27926, 35444, 4, nil, 2048, },
	{ 2931, 27927, 35446, 4, nil, 2048, },
	{ 2933, 33992, 35430, 4, 31, 1048608, },
	{ 2934, 33993, 35439, 4, 31, 1024, },
	{ 2935, 33994, 35443, 4, 31, 1024, },
	{ 2937, 33997, 35441, 4, 31, 1024, },
	{ 2938, 34003, 35436, 4, 30, 65536, },
	{ 2939, 34007, 35399, 4, 30, 256, },
	{ 2940, 34008, 35398, 4, 30, 256, },
	{ 2977, 35355, 28882, 4, 31, 8, },
	{ 2978, 35402, 28889, 4, 31, 8, },
	{ 2979, 35403, 28878, 4, 31, 8, },
	{ 2980, 35404, 28887, 4, 31, 8, },
	{ 2981, 35405, 28881, 4, 31, 8, },
	{ 2982, 35406, 28886, 4, 31, 8, },
	{ 2983, 35407, 28885, 4, 31, 8, },
	{ 2984, 35415, 29483, 4, 30, 1050016, },
	{ 2985, 35416, 29485, 4, 30, 1050016, },
	{ 2986, 35417, 28888, 4, 31, 8, },
	{ 2987, 35418, 29486, 4, 30, 1050016, },
	{ 2988, 35419, 29487, 4, 30, 1050016, },
	{ 2989, 35420, 29488, 4, 30, 1050016, },
	{ 2990, 35432, 28908, 4, 31, 8, },
	{ 2991, 35433, 28911, 4, 31, 8, },
	{ 2992, 35434, 28904, 4, 31, 8, },
	{ 2993, 35435, 28912, 4, 31, 8, },
	{ 2994, 35436, 28903, 4, 31, 8, },
	{ 2995, 35437, 28909, 4, 31, 8, },
	{ 2996, 35438, 28907, 4, 31, 8, },
	{ 2997, 35439, 28910, 4, 31, 8, },
	{ 2998, 35441, 29187, 4, 30, 8, },
	{ 2999, 35443, 29186, 4, 31, 2, },
	{ 3001, 35445, 29189, 4, 31, 2, },
	{ 3002, 35447, 29191, 4, 31, 2, },
	{ 3003, 35452, 29192, 4, 31, 2, },
	{ 3004, 35453, 29193, 4, 31, 2, },
	{ 3005, 35454, 29194, 4, 31, 2, },
	{ 3006, 35455, 29195, 4, 31, 2, },
	{ 3007, 35456, 29196, 4, 31, 2, },
	{ 3008, 35457, 29198, 4, 31, 2, },
	{ 3009, 35458, 29199, 4, 31, 2, },
	{ 3010, 35488, 29533, 4, 31, 128, },
	{ 3011, 35489, 29534, 4, 31, 128, },
	{ 3012, 35490, 29535, 4, 31, 128, },
	{ 3013, 35495, 29536, 4, 31, 128, },
	{ 3095, 37889, 30845, 4, 31, 2, },
	{ 3096, 37891, 30846, 4, 31, 2, },
	{ 3150, 33991, 38929, 4, 31, 1048608, },
	{ 3222, 42620, 35453, 2, 189939, nil, },
	{ 3222, 44529, 38967, 4, 30, 1024, },
	{ 3223, 42687, 33185, 2, 173555, nil, },
	{ 3225, 42974, 38948, 2, 189939, nil, },
	{ 3228, 44119, nil, 4, 30, 512, },
	{ 3229, 44383, 38949, 4, 64, nil, },
	{ 3229, 359685, 187783, 4, 64, nil, },
	{ 3230, 44483, 38950, 4, 30, 65536, },
	{ 3231, 44484, 38951, 4, 30, 1024, },
	{ 3231, 44598, 38984, 4, 30, 512, },
	{ 3232, 47901, 39006, 4, 30, 256, },
	{ 3233, 27958, 38912, 4, 31, 1048608, },
	{ 3234, 44488, 38953, 4, 31, 1024, },
	{ 3236, 44492, 38955, 4, 30, 1048608, },
	{ 3238, 44506, 38960, 4, 30, 1024, },
	{ 3239, 44524, 38965, 2, 177651, nil, },
	{ 3241, 44576, 38972, 2, 173555, nil, },
	{ 3243, 44582, 38973, 4, 30, 65536, },
	{ 3244, 44584, 38974, 4, 30, 256, },
	{ 3245, 44588, 38975, 4, 30, 1048608, },
	{ 3246, 44592, 38979, 4, 30, 1024, },
	{ 3247, 44595, 38981, 2, 132450, nil, },
	{ 3249, 44612, 38985, 4, 30, 1024, },
	{ 3251, 44621, 38988, 2, 173555, nil, },
	{ 3252, 44623, 38989, 4, 30, 1048608, },
	{ 3253, 44625, 38990, 4, 31, 1024, },
	{ 3256, 44631, 38993, 4, 30, 65536, },
	{ 3260, 44769, 34207, 4, 30, 1024, },
	{ 3269, 45697, 34836, 2, 1048576, nil, },
	{ 3273, 46578, 38998, 2, 189939, nil, },
	{ 3290, 52639, 39300, 4, nil, 65536, },
	{ 3294, 47672, 39001, 4, 30, 65536, },
	{ 3296, 47899, 39004, 4, 30, 65536, },
	{ 3297, 47900, 39005, 4, 30, 1048608, },
	{ 3297, 48036, nil, 4, 30, 1048608, },
	{ 3319, 50465, nil, 2, 41105, nil, },
	{ 3325, 50901, 38371, 4, 31, 128, },
	{ 3326, 50902, 38372, 4, 31, 128, },
	{ 3327, 50903, nil, 4, 31, 128, },
	{ 3327, 60583, nil, 4, 30, 128, },
	{ 3328, 50904, nil, 4, 31, 128, },
	{ 3328, 60584, nil, 4, 30, 128, },
	{ 3329, 50906, 38375, 4, 30, 1050026, },
	{ 3330, 50909, 38376, 4, 30, 1050026, },
	{ 3331, 50911, 38377, 4, 31, 128, },
	{ 3332, 50913, 38378, 4, 31, 128, },
	{ 3365, 53323, nil, 2, 1378, nil, },
	{ 3366, 53331, nil, 2, 189939, nil, },
	{ 3367, 53342, nil, 2, 1378, nil, },
	{ 3368, 53344, nil, 2, 189939, nil, },
	{ 3369, 53341, nil, 2, 189939, nil, },
	{ 3370, 53343, nil, 2, 189939, nil, },
	{ 3594, 54446, nil, 2, 32913, nil, },
	{ 3595, 54447, nil, 2, 32913, nil, },
	{ 3599, 54736, 40776, 4, 30, 64, },
	{ 3601, 54793, 40800, 4, 30, 64, },
	{ 3603, 54998, 41091, 4, 30, 1024, },
	{ 3604, 54999, nil, 4, 30, 1024, },
	{ 3605, 55002, 41111, 4, 30, 65536, },
	{ 3606, 55016, 41118, 4, 30, 256, },
	{ 3607, 55076, 41146, 2, 262156, nil, },
	{ 3608, 55135, 41167, 2, 262156, nil, },
	{ 3718, 55630, 41601, 4, 31, 128, },
	{ 3719, 55631, 41602, 4, 31, 128, },
	{ 3720, 55632, 41603, 4, 31, 128, },
	{ 3721, 55634, 41604, 4, 31, 128, },
	{ 3722, 55642, nil, 4, 30, 65536, },
	{ 3728, 55769, nil, 4, 30, 65536, },
	{ 3730, 55777, nil, 4, 30, 65536, },
	{ 3731, 55836, 41976, 2, 173555, nil, },
	{ 3748, 56353, 42500, 4, 96, nil, },
	{ 3754, 24162, 19785, 4, 31, 130, },
	{ 3755, 24161, 19784, 4, 31, 130, },
	{ 3756, 57683, 43097, 4, 30, 512, },
	{ 3757, 57690, nil, 4, 30, 512, },
	{ 3758, 57691, nil, 4, 30, 512, },
	{ 3759, 57692, 44559, 4, 30, 512, },
	{ 3760, 57694, 44560, 4, 30, 512, },
	{ 3761, 57696, 44561, 4, 30, 512, },
	{ 3762, 57699, 44562, 4, 30, 512, },
	{ 3763, 57701, 44563, 4, 30, 512, },
	{ 3775, 58126, 43302, 4, 31, 8, },
	{ 3776, 58128, 43303, 4, 31, 8, },
	{ 3777, 58129, 43304, 4, 31, 8, },
	{ 3788, 59619, 44497, 2, 177651, nil, },
	{ 3789, 59621, 44493, 2, 173555, nil, },
	{ 3790, 59625, 43987, 2, 173555, nil, },
	{ 3791, 59636, nil, 4, nil, 2048, },
	{ 3793, 59771, 44067, 4, 31, 8, },
	{ 3794, 59773, 44068, 4, 31, 8, },
	{ 3795, 59777, 44069, 4, 31, 2, },
	{ 3796, 59778, nil, 4, 31, 2, },
	{ 3797, 59784, 44075, 4, 31, 2, },
	{ 3806, 59927, 44129, 4, 31, 8, },
	{ 3807, 59928, 44130, 4, 31, 8, },
	{ 3808, 59934, 44133, 4, 31, 8, },
	{ 3809, 59936, 44134, 4, 31, 8, },
	{ 3810, 59937, 44135, 4, 31, 8, },
	{ 3811, 59941, 44136, 4, 31, 8, },
	{ 3812, 59944, 44137, 4, 31, 2, },
	{ 3813, 59945, 44138, 4, 31, 2, },
	{ 3814, 59946, 44139, 4, 31, 2, },
	{ 3815, 59947, 44140, 4, 31, 2, },
	{ 3816, 59948, 44141, 4, 31, 2, },
	{ 3817, 59954, 44149, 4, 31, 2, },
	{ 3818, 59955, 44150, 4, 31, 2, },
	{ 3819, 59960, 44152, 4, 31, 2, },
	{ 3820, 59970, 44159, 4, 31, 2, },
	{ 3822, 60581, 38373, 4, 31, 128, },
	{ 3823, 60582, 38374, 4, 31, 128, },
	{ 3824, 60606, 44449, 4, 30, 256, },
	{ 3825, 60609, 44456, 4, 30, 65536, },
	{ 3826, 60623, 38986, 4, 30, 256, },
	{ 3827, 60691, 44463, 2, 136546, nil, },
	{ 3828, 44630, 38992, 2, 132450, nil, },
	{ 3829, 44513, 38964, 4, 30, 1024, },
	{ 3830, 44629, 38991, 2, 177651, nil, },
	{ 3831, 47898, 39003, 4, 30, 65536, },
	{ 3832, 60692, 44465, 4, 30, 1048608, },
	{ 3833, 60707, 44466, 2, 189939, nil, },
	{ 3834, 60714, 44467, 2, 177651, nil, },
	{ 3835, 61117, nil, 4, 31, 8, },
	{ 3836, 61118, nil, 4, 31, 8, },
	{ 3837, 61119, nil, 4, 31, 8, },
	{ 3838, 61120, nil, 4, 31, 8, },
	{ 3839, 44645, nil, 4, nil, 2048, },
	{ 3840, 44636, nil, 4, nil, 2048, },
	{ 3842, 61271, 44701, 4, 31, 2, },
	{ 3843, 61468, 44739, 2, 262156, nil, },
	{ 3844, 44510, 38963, 2, 177651, nil, },
	{ 3845, 44575, 44815, 4, 30, 512, },
	{ 3846, 34010, 35454, 2, 189939, nil, },
	{ 3847, 62158, nil, 2, 1378, nil, },
	{ 3849, 62201, 44936, 4, 64, nil, },
	{ 3850, 62256, 44947, 4, 30, 512, },
	{ 3851, 62257, 44946, 2, 189939, nil, },
	{ 3852, 62384, 44957, 4, 31, 8, },
	{ 3853, 62447, 44963, 4, 31, 128, },
	{ 3854, 62948, 45056, 2, 1024, nil, },
	{ 3855, 62959, 45060, 2, 1024, nil, },
	{ 3858, 63746, 45628, 4, 30, 256, },
	{ 3859, 63765, nil, 4, 30, 65536, },
	{ 3860, 63770, nil, 4, 30, 1024, },
	{ 3869, 64441, 46026, 2, 189939, nil, },
	{ 3870, 64579, 46098, 2, 189939, nil, },
	{ 3872, 56039, nil, 4, 31, 128, },
	{ 3873, 56034, nil, 4, 31, 128, },
	{ 3875, 59929, 44131, 4, 31, 8, },
	{ 3876, 59932, 44132, 4, 31, 8, },
	{ 3878, 67839, nil, 4, nil, 2, },
	{ 3883, 70164, nil, 2, 32913, nil, },
};
--	[classID][enchantID] = { subClassMask, invTypeMask, spellID, itemID, }
local EnchantDB = {  };
for _, info in next, RawEnchantDB do
	local classID = info[4];
	if classID then
		local TO = EnchantDB[classID];
		if TO == nil then
			TO = {  };
			EnchantDB[classID] = TO;
		end
		local enchantID = info[1];
		local to = TO[enchantID];
		if to == nil then
			to = {  };
			TO[enchantID] = to;
		end
		to[#to + 1] = { info[5], info[6], info[2], info[3], };
	end
end
DT.EnchantDB = EnchantDB;
DT.EnchantableByLoc = {
	INVTYPE_HEAD = 1,
	INVTYPE_SHOULDER = 1,
	INVTYPE_CHEST = 1,
	INVTYPE_LEGS = 1,
	INVTYPE_FEET = 1,
	INVTYPE_WRIST = 1,
	INVTYPE_HAND = 1,
	INVTYPE_CLOAK = 1,
	INVTYPE_WEAPON = 1,
	INVTYPE_2HWEAPON = 1,
	INVTYPE_SHIELD = 1,
	INVTYPE_RANGED = 1,
	INVTYPE_ROBE = 1,
	INVTYPE_WEAPONMAINHAND = 1,
	INVTYPE_WEAPONOFFHAND = 1,
	INVTYPE_RANGEDRIGHT = 1,
};
local EnumItemClass = Enum and Enum.ItemClass or {
	Weapon = 2,
};
local EnumWSubClass = Enum and Enum.ItemWeaponSubclass or {
	Axe1H = 0,
	Axe2H = 1,
	Bows = 2,
	Guns = 3,
	Mace1H = 4,
	Mace2H = 5,
	Polearm = 6,
	Sword1H = 7,
	Sword2H = 8,
	Warglaive = 9,
	Staff = 10,
	Bearclaw = 11,
	Catclaw = 12,
	Unarmed = 13,
	Generic = 14,
	Dagger = 15,
	Thrown = 16,
	Obsolete3 = 17,
	Crossbow = 18,
	Wand = 19,
	Fishingpole = 20,
};
DT.UnenchantableByType = {
	[EnumItemClass.Weapon] = {
		[EnumWSubClass.Generic] = 1,
		[EnumWSubClass.Thrown] = 1,
		[EnumWSubClass.Wand] = 1,
		[EnumWSubClass.Fishingpole] = 1,
		[EnumWSubClass.Bows] = 'HUNTER',
		[EnumWSubClass.Guns] = 'HUNTER',
		[EnumWSubClass.Crossbow] = 'HUNTER',
	},
};

DT.ItemSet = {
	[1] = { 11729, 11726, 11728, 11731, 11730, },
	[41] = { 12940, 12939, },
	[65] = { 13218, 13183, },
	[81] = { 13390, 13388, 13391, 13392, 13389, },
	[121] = { 14637, 14636, 14640, 14638, 14641, },
	[122] = { 14631, 14629, 14632, 14633, 14626, },
	[123] = { 14614, 14616, 14615, 14611, 14612, },
	[124] = { 14624, 14622, 14620, 14623, 14621, },
	[141] = { 15053, 15054, 15055, },
	[142] = { 15056, 15057, 15058, 21278, },
	[143] = { 15062, 15063, },
	[144] = { 15066, 15067, },
	[161] = { 10399, 10403, 10402, 10401, 10400, },
	[162] = { 10412, 10411, 10413, 10410, 6473, },
	[163] = { 10329, 10332, 10328, 10331, 10330, 10333, },
	[181] = { 16685, 16683, 16686, 16684, 16687, 16689, 16688, 16682, },
	[182] = { 16696, 16691, 16697, 16693, 16692, 16695, 16694, 16690, },
	[183] = { 16702, 16703, 16699, 16701, 16700, 16704, 16698, 16705, },
	[184] = { 16713, 16711, 16710, 16721, 16708, 16709, 16712, 16707, },
	[185] = { 16716, 16715, 16714, 16720, 16706, 16718, 16719, 16717, },
	[186] = { 16680, 16675, 16681, 16677, 16674, 16678, 16679, 16676, },
	[187] = { 16673, 16670, 16671, 16667, 16672, 16668, 16669, 16666, },
	[188] = { 16723, 16725, 16722, 16726, 16724, 16728, 16729, 16727, },
	[189] = { 16736, 16734, 16735, 16730, 16737, 16731, 16732, 16733, },
	[201] = { 16802, 16799, 16795, 16800, 16801, 16796, 16797, 16798, },
	[202] = { 16811, 16813, 16817, 16812, 16814, 16816, 16815, 16819, },
	[203] = { 16806, 16804, 16805, 16810, 16809, 16807, 16808, 16803, },
	[204] = { 16827, 16824, 16825, 16820, 16821, 16826, 16822, 16823, },
	[205] = { 16828, 16829, 16830, 16833, 16831, 16834, 16835, 16836, },
	[206] = { 16851, 16849, 16850, 16845, 16848, 16852, 16846, 16847, },
	[207] = { 16838, 16837, 16840, 16841, 16844, 16839, 16842, 16843, },
	[208] = { 16858, 16859, 16857, 16853, 16860, 16854, 16855, 16856, },
	[209] = { 16864, 16861, 16865, 16863, 16866, 16867, 16868, 16862, },
	[210] = { 16818, 16918, 16912, 16914, 16917, 16913, 16915, 16916, },
	[211] = { 16925, 16926, 16919, 16921, 16920, 16922, 16924, 16923, },
	[212] = { 16933, 16927, 16934, 16928, 16930, 16931, 16929, 16932, },
	[213] = { 16910, 16906, 16911, 16905, 16907, 16908, 16909, 16832, },
	[214] = { 16903, 16898, 16904, 16897, 16900, 16899, 16901, 16902, },
	[215] = { 16936, 16935, 16942, 16940, 16941, 16939, 16938, 16937, },
	[216] = { 16944, 16943, 16950, 16945, 16948, 16949, 16947, 16946, },
	[217] = { 16952, 16951, 16958, 16955, 16956, 16954, 16957, 16953, },
	[218] = { 16959, 16966, 16964, 16963, 16962, 16961, 16965, 16960, },
	[221] = { 7950, 7948, 7952, 7951, 7953, 7949, },
	[241] = { 17082, 17064, },
	[261] = { 18203, 18202, },
	[281] = { 16509, 16510, 16513, 16515, 16514, 16516, },
	[282] = { 16405, 16406, 16430, 16431, 16429, 16432, },
	[301] = { 16519, 16518, 16522, 16523, 16521, 16524, },
	[321] = { 12424, 12426, 12425, 12422, 12427, 12429, 12428, },
	[341] = { 16485, 16487, 16491, 16490, 16489, 16492, },
	[342] = { 17616, 17617, 17612, 17611, 17613, 17610, },
	[343] = { 16369, 16391, 16413, 16414, 16416, 16415, },
	[344] = { 17594, 17596, 17600, 17599, 17598, 17601, },
	[345] = { 17576, 17577, 17572, 17571, 17570, 17573, },
	[346] = { 17562, 17564, 17568, 17567, 17569, 17566, },
	[347] = { 16498, 16499, 16505, 16508, 16506, 16507, },
	[348] = { 16392, 16396, 16417, 16419, 16420, 16418, },
	[361] = { 16531, 16530, 16525, 16527, 16526, 16528, },
	[362] = { 16425, 16426, 16401, 16403, 16428, 16427, },
	[381] = { 16423, 16424, 16422, 16421, 16393, 16397, },
	[382] = { 16494, 16496, 16504, 16502, 16503, 16501, },
	[383] = { 16541, 16542, 16544, 16545, 16548, 16543, },
	[384] = { 16477, 16478, 16480, 16483, 16484, 16479, },
	[386] = { 16577, 16578, 16580, 16573, 16574, 16579, },
	[387] = { 16536, 16533, 16535, 16539, 16540, 16534, },
	[388] = { 16441, 16444, 16443, 16437, 16440, 16442, },
	[389] = { 17604, 17603, 17605, 17608, 17607, 17602, },
	[390] = { 17623, 17625, 17622, 17624, 17618, 17620, },
	[391] = { 17586, 17588, 17593, 17591, 17590, 17592, },
	[392] = { 17581, 17580, 17583, 17584, 17579, 17578, },
	[393] = { 16563, 16561, 16562, 16564, 16560, 16558, },
	[394] = { 16453, 16457, 16455, 16446, 16454, 16456, },
	[395] = { 16466, 16465, 16468, 16462, 16463, 16467, },
	[396] = { 16569, 16571, 16567, 16565, 16566, 16568, },
	[397] = { 16452, 16451, 16449, 16459, 16448, 16450, },
	[398] = { 16554, 16555, 16552, 16551, 16549, 16550, },
	[401] = { 16410, 16409, 16433, 16435, 16434, 16436, },
	[402] = { 16473, 16474, 16476, 16472, 16471, 16475, },
	[421] = { 19682, 19683, 19684, },
	[441] = { 19685, 19687, 19686, },
	[442] = { 19688, 19689, },
	[443] = { 19690, 19691, 19692, },
	[444] = { 19693, 19694, 19695, },
	[461] = { 19865, 19866, },
	[462] = { 19893, 19905, },
	[463] = { 19896, 19910, },
	[464] = { 19873, 19912, },
	[465] = { 19863, 19920, },
	[466] = { 19898, 19925, },
	[467] = { 20041, 20048, 20057, },
	[468] = { 20042, 20049, 20058, },
	[469] = { 20043, 20050, 20055, },
	[470] = { 20044, 20051, 20056, },
	[471] = { 20052, 20045, 20059, },
	[472] = { 20053, 20046, 20060, },
	[473] = { 20054, 20047, 20061, },
	[474] = { 19951, 19577, 19824, 19823, 19822, },
	[475] = { 19952, 19588, 19827, 19826, 19825, },
	[476] = { 19609, 19956, 19830, 19829, 19828, },
	[477] = { 19621, 19953, 19833, 19832, 19831, },
	[478] = { 19617, 19954, 19836, 19835, 19834, },
	[479] = { 19613, 19955, 19840, 19839, 19838, },
	[480] = { 19594, 19958, 19843, 19842, 19841, },
	[481] = { 19605, 19957, 19848, 19849, 20033, },
	[482] = { 19601, 19959, 19846, 19845, 20034, },
	[483] = { 20158, 20154, 20150, },
	[484] = { 20195, 20199, 20203, },
	[485] = { 20176, 20159, 20163, },
	[486] = { 20186, 20190, 20194, },
	[487] = { 20204, 20208, 20212, },
	[488] = { 20167, 20171, 20175, },
	[489] = { 16984, 15050, 15052, 15051, },
	[490] = { 15045, 15046, 20296, },
	[491] = { 15048, 20295, 15049, },
	[492] = { 20406, 20408, 20407, },
	[493] = { 21355, 21353, 21354, 21356, 21357, },
	[494] = { 21408, 21409, 21407, },
	[495] = { 21394, 21392, 21393, },
	[496] = { 21331, 21329, 21333, 21332, 21330, },
	[497] = { 21359, 21360, 21361, 21362, 21364, },
	[498] = { 21405, 21406, 21404, },
	[499] = { 21337, 21338, 21335, 21334, 21336, },
	[500] = { 21416, 21417, 21418, },
	[501] = { 21372, 21373, 21374, 21375, 21376, },
	[502] = { 21400, 21398, 21399, },
	[503] = { 21344, 21347, 21346, 21343, 21345, },
	[504] = { 21414, 21413, 21415, },
	[505] = { 21389, 21387, 21388, 21390, 21391, },
	[506] = { 21397, 21395, 21396, },
	[507] = { 21349, 21350, 21348, 21352, 21351, },
	[508] = { 21410, 21411, 21412, },
	[509] = { 21366, 21365, 21370, 21368, 21367, },
	[510] = { 21403, 21401, 21402, },
	[511] = { 21994, 21995, 21996, 21997, 21998, 21999, 22000, 22001, },
	[512] = { 22002, 22003, 22004, 22005, 22006, 22007, 22008, 22009, },
	[513] = { 22106, 22107, 22108, 22109, 22110, 22111, 22112, 22113, },
	[514] = { 22078, 22079, 22080, 22081, 22082, 22083, 22084, 22085, },
	[515] = { 22010, 22011, 22061, 22013, 22015, 22016, 22017, 22060, },
	[516] = { 22086, 22087, 22088, 22089, 22090, 22091, 22092, 22093, },
	[517] = { 22062, 22063, 22064, 22065, 22066, 22067, 22068, 22069, },
	[518] = { 22070, 22071, 22072, 22073, 22074, 22075, 22076, 22077, },
	[519] = { 22095, 22096, 22097, 22098, 22099, 22100, 22101, 22102, },
	[520] = { 22306, 22311, 22313, 22302, 22304, 22305, 22303, 22301, },
	[521] = { 22492, 22494, 22493, 22490, 22489, 22491, 22488, 22495, 23064, },
	[522] = { 22864, 22856, 22879, 22880, 23257, 23258, },
	[523] = { 22423, 22416, 22421, 22422, 22418, 22417, 22419, 22420, 23059, },
	[524] = { 22483, 22476, 22481, 22478, 22477, 22479, 22480, 22482, 23060, },
	[525] = { 22518, 22519, 22514, 22517, 22513, 22512, 22516, 22515, 23061, },
	[526] = { 22502, 22503, 22498, 22501, 22497, 22496, 22500, 22499, 23062, },
	[527] = { 22468, 22470, 22469, 22466, 22465, 22467, 22464, 22471, 23065, },
	[528] = { 22430, 22431, 22426, 22428, 22427, 22429, 22425, 22424, 23066, },
	[529] = { 22510, 22511, 22506, 22509, 22505, 22504, 22508, 22507, 23063, },
	[530] = { 22440, 22442, 22441, 22438, 22437, 22439, 22436, 22443, 23067, },
	[533] = { 23090, 23087, 23078, },
	[534] = { 23081, 23089, 23093, },
	[535] = { 23088, 23082, 23092, },
	[536] = { 23091, 23084, 23085, },
	[537] = { 22868, 22858, 22872, 22873, 23244, 23243, },
	[538] = { 22857, 22867, 22876, 22887, 23259, 23260, },
	[539] = { 22863, 22852, 22877, 22878, 23253, 23254, },
	[540] = { 22869, 22859, 22882, 22885, 23261, 23262, },
	[541] = { 22865, 22855, 23255, 23256, 22881, 22884, },
	[542] = { 22870, 22860, 23263, 23264, 22883, 22886, },
	[543] = { 22843, 22862, 23251, 23252, 22874, 22875, },
	[544] = { 23272, 23273, 23274, 23275, 23276, 23277, },
	[545] = { 23300, 23301, 23286, 23287, 23314, 23315, },
	[546] = { 23304, 23305, 23290, 23291, 23318, 23319, },
	[547] = { 23296, 23297, 23282, 23283, 23310, 23311, },
	[548] = { 23298, 23299, 23284, 23285, 23312, 23313, },
	[549] = { 23302, 23303, 23288, 23289, 23316, 23317, },
	[550] = { 23292, 23293, 23278, 23279, 23306, 23307, },
	[551] = { 23294, 23295, 23280, 23281, 23308, 23309, },
	[552] = { 21848, 21847, 21846, },
	[553] = { 21871, 21869, 21870, },
	[554] = { 21875, 21874, 21873, },
	[555] = { 21855, 21854, 21852, 21851, 21849, 21853, 21850, },
	[556] = { 21862, 21861, 21859, 21860, },
	[557] = { 21865, 21864, 21863, },
	[558] = { 21868, 21866, 21867, },
	[559] = { 24266, 24262, },
	[560] = { 23489, 23488, 23487, 23482, 23484, },
	[561] = { 23490, 23491, 23493, 23494, },
	[562] = { 23507, 23508, 23506, },
	[563] = { 23509, 23512, 23511, 23510, },
	[564] = { 23513, 23516, 23514, 23515, },
	[565] = { 23523, 23525, 23524, },
	[566] = { 23522, 23521, 23520, 33173, },
	[567] = { 24544, 24549, 24545, 24547, 24546, },
	[568] = { 24556, 24553, 24555, 24554, 24552, },
	[569] = { 23519, 23518, 23517, },
	[570] = { 24255, 24249, },
	[571] = { 24264, 24261, },
	[572] = { 24267, 24263, },
	[573] = { 25685, 25686, 25687, },
	[574] = { 25691, 25690, 25689, },
	[575] = { 25695, 25697, 25696, },
	[576] = { 25694, 25693, 25692, },
	[577] = { 25834, 25833, 25830, 25832, 25831, },
	[578] = { 25997, 26000, 25998, 26001, 25999, },
	[579] = { 25854, 25855, 25857, 25856, 25858, },
	[580] = { 27469, 27470, 27471, 27472, 27473, },
	[581] = { 27707, 27708, 27709, 27710, 27711, },
	[582] = { 27702, 27703, 27704, 27705, 27706, },
	[583] = { 27879, 27880, 27881, 27882, 27883, },
	[584] = { 28126, 28127, 28128, 28129, 28130, },
	[585] = { 28136, 28137, 28138, 28139, 28140, },
	[586] = { 28334, 28335, 28331, 28332, 28333, },
	[587] = { 28831, 28832, 28833, 28834, 28835, },
	[588] = { 28851, 28852, 28853, 28854, 28855, },
	[589] = { 28679, 28680, 28681, 28724, 28683, },
	[590] = { 28699, 28700, 28701, 28702, 28703, },
	[591] = { 28624, 28625, 28626, 28627, 28628, },
	[592] = { 28817, 28818, 28819, 28820, 28821, },
	[593] = { 28689, 28690, 28691, 28692, 28693, },
	[594] = { 28841, 28842, 28843, 28844, 28845, },
	[595] = { 28613, 28614, 28615, 28616, 28617, },
	[596] = { 28805, 28806, 28807, 28808, 28809, },
	[597] = { 28704, 28705, 28706, 28707, 28708, },
	[598] = { 28856, 28857, 28858, 28859, 28860, },
	[599] = { 28714, 28715, 28716, 28717, 28718, },
	[600] = { 28866, 28867, 28868, 28869, 28870, },
	[601] = { 28618, 28619, 28620, 28622, 28623, },
	[602] = { 28811, 28812, 28813, 28814, 28815, },
	[603] = { 28694, 28695, 28696, 28697, 28698, },
	[604] = { 28846, 28847, 28848, 28849, 28850, },
	[605] = { 28684, 28685, 28686, 28687, 28688, },
	[606] = { 28836, 28837, 28838, 28839, 28840, },
	[607] = { 28709, 28710, 28711, 28712, 28713, },
	[608] = { 28861, 28862, 28863, 28864, 28865, },
	[609] = { 28719, 28720, 28721, 28722, 28723, },
	[610] = { 28871, 28872, 28873, 28874, 28875, },
	[611] = { 25657, 25656, 25655, 25654, },
	[612] = { 25661, 25659, 25662, 25660, },
	[613] = { 25668, 25669, 25670, 25671, },
	[614] = { 25673, 25674, 25675, 25676, },
	[615] = { 30186, 30187, 30188, 30200, 30201, },
	[616] = { 29516, 29517, 29515, },
	[617] = { 29521, 29520, 29519, },
	[618] = { 29523, 29524, 29522, },
	[619] = { 29527, 29526, 29525, },
	[620] = { 27509, 28414, 27908, 27776, 28204, },
	[621] = { 29046, 29045, 29044, 29048, 29047, },
	[622] = { 30144, 30145, 30146, 30148, 30149, },
	[623] = { 28203, 27535, 28285, 27839, 27739, },
	[624] = { 29062, 29061, 29065, 29063, 29064, },
	[625] = { 29066, 29068, 29067, 29069, 29070, },
	[626] = { 29071, 29073, 29072, 29074, 29075, },
	[627] = { 30134, 30135, 30136, 30137, 30138, },
	[628] = { 30123, 30125, 30124, 30126, 30127, },
	[629] = { 30129, 30130, 30132, 30133, 30131, },
	[630] = { 28231, 27510, 28349, 27909, 27802, },
	[631] = { 29032, 29029, 29028, 29030, 29031, },
	[632] = { 29033, 29035, 29034, 29036, 29037, },
	[633] = { 29038, 29039, 29040, 29043, 29042, },
	[634] = { 30164, 30165, 30166, 30167, 30168, },
	[635] = { 30169, 30170, 30171, 30172, 30173, },
	[636] = { 30185, 30189, 30190, 30192, 30194, },
	[637] = { 28348, 27468, 27873, 28202, 27737, },
	[638] = { 29087, 29086, 29090, 29088, 29089, },
	[639] = { 29093, 29094, 29091, 29092, 29095, },
	[640] = { 29096, 29097, 29099, 29100, 29098, },
	[641] = { 30222, 30223, 30228, 30229, 30230, },
	[642] = { 30216, 30217, 30219, 30220, 30221, },
	[643] = { 30231, 30232, 30233, 30234, 30235, },
	[644] = { 27537, 28415, 28232, 27778, 27948, },
	[645] = { 28963, 28968, 28966, 28967, 28964, },
	[646] = { 30211, 30212, 30213, 30215, 30214, },
	[647] = { 28278, 27508, 27738, 28229, 27838, },
	[648] = { 29076, 29080, 29078, 29079, 29077, },
	[649] = { 30206, 30205, 30207, 30210, 30196, },
	[650] = { 28228, 27474, 28275, 27874, 27801, },
	[651] = { 29085, 29081, 29083, 29082, 29084, },
	[652] = { 30139, 30140, 30141, 30142, 30143, },
	[653] = { 28205, 27475, 27977, 27803, 28350, },
	[654] = { 29012, 29011, 29017, 29015, 29016, },
	[655] = { 29021, 29019, 29020, 29022, 29023, },
	[656] = { 30113, 30115, 30114, 30116, 30117, },
	[657] = { 30120, 30118, 30119, 30121, 30122, },
	[658] = { 28193, 27465, 27907, 28191, 27796, },
	[659] = { 28264, 27531, 28224, 27837, 27797, },
	[660] = { 27936, 28401, 27528, 28192, 27713, },
	[661] = { 28403, 27497, 28225, 27870, 27771, },
	[662] = { 28413, 28230, 27536, 27775, 27875, },
	[663] = { 29055, 29049, 29054, 29050, 29053, },
	[664] = { 29057, 29059, 29056, 29058, 29060, },
	[665] = { 30153, 30152, 30151, 30154, 30150, },
	[666] = { 30160, 30161, 30162, 30159, 30163, },
	[667] = { 31339, 31338, },
	[668] = { 31028, 31026, 31027, 31029, 31030, 34575, 34448, 34558, },
	[669] = { 31004, 31001, 31003, 31005, 31006, 34549, 34443, 34570, },
	[670] = { 31050, 31051, 31053, 31054, 31052, 34564, 34436, 34541, },
	[671] = { 31056, 31055, 31058, 31059, 31057, 34574, 34447, 34557, },
	[672] = { 30972, 30975, 30969, 30977, 30979, 34546, 34441, 34569, },
	[673] = { 30976, 30974, 30970, 30978, 30980, 34568, 34442, 34547, },
	[674] = { 31061, 31064, 31067, 31070, 31065, 34434, 34528, 34563, },
	[675] = { 31068, 31063, 31060, 31069, 31066, 34562, 34527, 34435, },
	[676] = { 31042, 31034, 31039, 31044, 31048, 34556, 34444, 34573, },
	[677] = { 31043, 31035, 31040, 31046, 31049, 34572, 34446, 34555, },
	[678] = { 31041, 31032, 31037, 31045, 31047, 34571, 34445, 34554, },
	[679] = { 30991, 30987, 30985, 30995, 30998, 34488, 34433, 34560, },
	[680] = { 30990, 30982, 30993, 30997, 30989, 34561, 34431, 34485, },
	[681] = { 30992, 30983, 30988, 30994, 30996, 34432, 34487, 34559, },
	[682] = { 31018, 31011, 31015, 31021, 31024, 34567, 34439, 34545, },
	[683] = { 31016, 31007, 31012, 31019, 31022, 34543, 34438, 34565, },
	[684] = { 31017, 31008, 31014, 31020, 31023, 34542, 34437, 34566, },
	[685] = { 31375, 31376, 31377, 31378, 31379, },
	[686] = { 31396, 31397, 31400, 31406, 31407, },
	[687] = { 31409, 31410, 31411, 31412, 31413, },
	[688] = { 31589, 31590, 31591, 31592, 31593, },
	[689] = { 31584, 31585, 31586, 31587, 31588, },
	[690] = { 31613, 31614, 31616, 31618, 31619, },
	[691] = { 31622, 31623, 31620, 31624, 31625, },
	[692] = { 31626, 31627, 31621, 31628, 31629, },
	[693] = { 31630, 31631, 31632, 31633, 31634, },
	[694] = { 31635, 31636, 31637, 31638, 31639, },
	[695] = { 31640, 31641, 31642, 31643, 31644, },
	[696] = { 31646, 31647, 31648, 31649, 31650, },
	[697] = { 29600, 29601, 29602, 29603, 29604, 29605, },
	[698] = { 29612, 29613, 29614, 29615, 29616, 29617, },
	[699] = { 32838, 32837, },
	[717] = { 29608, 29606, 29611, 29609, 29607, 29610, },
	[718] = { 29599, 29595, 29597, 29596, 29598, 29594, },
	[719] = { 32946, 32945, },
	[737] = { 34703, 28189, },
	[738] = { 35328, 35329, 35330, 35331, 35332, },
	[739] = { 35333, 35334, 35335, 35336, 35337, },
	[740] = { 35338, 35339, 35340, 35341, 35342, },
	[741] = { 35343, 35344, 35345, 35346, 35347, },
	[742] = { 35356, 35357, 35358, 35360, 35359, },
	[743] = { 35371, 35372, 35373, 35375, 35374, },
	[744] = { 35361, 35362, 35363, 35365, 35364, },
	[745] = { 35366, 35367, 35368, 35369, 35370, },
	[746] = { 35386, 35387, 35388, 35389, 35390, },
	[747] = { 35391, 35392, 35393, 35394, 35395, },
	[748] = { 35381, 35382, 35383, 35384, 35385, },
	[749] = { 35376, 35377, 35378, 35379, 35380, },
	[750] = { 35407, 35408, 35409, 35410, 35411, },
	[751] = { 35402, 35403, 35404, 35405, 35406, },
	[752] = { 35412, 35413, 35414, 35415, 35416, },
	[754] = { 38405, 38404, 38400, 38403, 38401, 38402, 38437, 38433, },
	[755] = { 38418, 38419, 38420, 38421, 38422, 38417, 38439, 38435, },
	[756] = { 38412, 38413, 38414, 38415, 38416, 38424, 38436, 38440, },
	[757] = { 38406, 38407, 38408, 38409, 38410, 38411, 38434, 38438, },
	[759] = { 37758, 37821, },
	[760] = { 40440, 40441, 40442, 40443, 40444, },
	[761] = { 34087, 21525, 34085, 21524, 34086, },
	[762] = { 33862, 33863, 33868, 33966, 33969, 33967, 33864, 33968, },
	[763] = { 41522, 41520, 44211, 41521, 41519, 41515, 41513, 41512, },
	[764] = { 41543, 41544, 41545, 41546, 41548, 41549, 41550, 41551, },
	[765] = { 42625, 42626, 42627, 42628, 42629, },
	[766] = { 42630, 42631, 42632, 42633, 42634, },
	[767] = { 42635, 42636, 42637, 42638, 42639, },
	[768] = { 42654, 42655, 42656, 42657, 42658, },
	[769] = { 42659, 42660, 42661, 42662, 42663, },
	[770] = { 42669, 42670, 42671, 42672, 42673, },
	[771] = { 42664, 42665, 42666, 42667, 42668, },
	[772] = { 42674, 42675, 42676, 42677, 42678, },
	[773] = { 42680, 42681, 42682, 42683, 42684, },
	[774] = { 42685, 42686, 42687, 42688, 42689, },
	[775] = { 42690, 42691, 42692, 42693, 42694, },
	[776] = { 42695, 42696, 42697, 42698, 42699, },
	[777] = { 42703, 42704, 42705, 42706, 42707, },
	[778] = { 42708, 42709, 42710, 42711, 42712, },
	[779] = { 42713, 42714, 42715, 42716, 42717, },
	[780] = { 42718, 42719, 42720, 42721, 42722, },
	[781] = { 43073, 43074, 43075, 43072, },
	[782] = { 43078, 43077, 43079, 43076, },
	[783] = { 43082, 43081, 43083, 43080, },
	[784] = { 43070, 43068, 43071, 43069, },
	[785] = { 23324, 34685, 34683, },
	[787] = { 43740, 43742, 43743, 43745, 43747, },
	[788] = { 43739, 43744, 43746, 43741, 43748, },
	[789] = { 43794, 43796, 43801, 43803, 43805, },
	[790] = { 43797, 43798, 43800, 43806, 43807, },
	[791] = { 43793, 43795, 43799, 43802, 43804, },
	[792] = { 43809, 43813, 43815, 43817, 43819, },
	[793] = { 43811, 43812, 43814, 43816, 43818, },
	[794] = { 43734, 43735, 43736, 43737, 43738, },
	[795] = { 43762, 43763, 43765, 43772, 43776, },
	[796] = { 43764, 43767, 43769, 43770, 43773, },
	[797] = { 43766, 43768, 43771, 43774, 43775, },
	[798] = { 43751, 43753, 43756, 43822, 43758, },
	[799] = { 43752, 43754, 43755, 43759, 43820, },
	[800] = { 43749, 43750, 43757, 43760, 43761, },
	[801] = { 43727, 43728, 43729, 43730, 43731, },
	[802] = { 43787, 43788, 43789, 43790, 43791, },
	[803] = { 43777, 43778, 43779, 43780, 43781, },
	[804] = { 43733, 43782, 43784, 43808, 43810, },
	[805] = { 43732, 43783, 43785, 43786, 43792, },
	[812] = { 6835, 6833, },
	[813] = { 43435, 43434, 43260, 43436, 43438, 43433, 43439, 43437, },
	[814] = { 42723, 42724, 42725, 42726, 42727, 42728, 42730, 42729, },
	[815] = { 43266, 43273, 43264, 43263, 43265, 43261, 43271, 43262, },
	[816] = { 41354, 41349, 41353, 41347, 41351, 41350, 41352, 41348, },
	[817] = { 43450, 43455, 43454, 43453, 43456, 43457, 43451, 43452, },
	[818] = { 43442, 43443, 43444, 43446, 43445, 43447, 43448, 43449, },
	[819] = { 43969, 43970, 43974, 43971, 41516, 43975, 43972, 43973, },
	[820] = { 46213, 46216, 46221, 46224, 46226, },
	[821] = { 46214, 46215, 46219, 46222, 46225, },
	[822] = { 46217, 46218, 46220, 46227, 46228, },
	[823] = { 46293, 46294, 46296, 46303, 46307, },
	[824] = { 46295, 46298, 46300, 46301, 46304, },
	[825] = { 46297, 46299, 46302, 46305, 46306, },
	[826] = { 46288, 46289, 46290, 46291, 46292, },
	[827] = { 46260, 46262, 46265, 46267, 46269, },
	[828] = { 45350, 46309, 46266, 46271, 46272, },
	[829] = { 46261, 46263, 46264, 46268, 46270, },
	[830] = { 46278, 46280, 46282, 46285, 46287, },
	[831] = { 46279, 46281, 46283, 46284, 46286, },
	[832] = { 46230, 46248, 46255, 46256, 46257, },
	[833] = { 46231, 46247, 46254, 46258, 46259, },
	[834] = { 46232, 46235, 46237, 46239, 46241, },
	[835] = { 46233, 46234, 46236, 46238, 46240, },
	[836] = { 46249, 46250, 46251, 46252, 46253, },
	[837] = { 46242, 46243, 46244, 46245, 46246, },
	[838] = { 46273, 46274, 46275, 46276, 46277, },
	[843] = { 48725, 48726, 48727, 48728, 48729, },
	[844] = { 48730, 48731, 48732, 48733, 48734, },
	[845] = { 48735, 48736, 48737, 48738, 48739, },
	[846] = { 48740, 48741, 48742, 48743, 48744, },
	[847] = { 48745, 48746, 48747, 48748, 48749, },
	[848] = { 48750, 48751, 48752, 48753, 48754, },
	[849] = { 48755, 48756, 48757, 48758, 48759, },
	[850] = { 48760, 48761, 48762, 48763, 48764, },
	[851] = { 48774, 48775, 48776, 48777, 48778, },
	[852] = { 48769, 48770, 48771, 48772, 48773, },
	[853] = { 48786, 48787, 48788, 48789, 48790, },
	[854] = { 48781, 48782, 48783, 48784, 48785, },
	[855] = { 48799, 48800, 48801, 48802, 48803, },
	[856] = { 48794, 48795, 48796, 48797, 48798, },
	[857] = { 48809, 48810, 48811, 48812, 48813, },
	[858] = { 48804, 48805, 48806, 48807, 48808, },
	[859] = { 48819, 48820, 48821, 48822, 48823, },
	[860] = { 48814, 48815, 48816, 48817, 48818, },
	[861] = { 48824, 48825, 48826, 48827, 48828, },
	[862] = { 48829, 48830, 48831, 48832, 48833, },
	[863] = { 48841, 48842, 48843, 48844, 48845, },
	[864] = { 48836, 48837, 48838, 48839, 48840, },
	[865] = { 48846, 48847, 48848, 48849, 48850, },
	[866] = { 48854, 48855, 48852, 48853, 48851, },
	[867] = { 48865, 48866, 48867, 48868, 48869, },
	[868] = { 48860, 48861, 48862, 48863, 48864, },
	[869] = { 48875, 48876, 48877, 48878, 48879, },
	[870] = { 48870, 48871, 48872, 48873, 48874, },
	[871] = { 48885, 48886, 48887, 48888, 48889, },
	[872] = { 48880, 48881, 48882, 48883, 48884, },
	[873] = { 48895, 48896, 48897, 48898, 48899, },
	[874] = { 48890, 48891, 48892, 48893, 48894, },
	[875] = { 48904, 48903, 48902, 48901, 48900, },
	[876] = { 48909, 48908, 48907, 48906, 48905, },
	[877] = { 48915, 48916, 48917, 48918, 48919, },
	[878] = { 48910, 48911, 48912, 48913, 48914, },
	[879] = { 48927, 48928, 48929, 48930, 48931, },
	[880] = { 48922, 48923, 48924, 48925, 48926, },
	[881] = { 49310, 49463, },
	[882] = { 49488, 49464, },
	[883] = { 51716, 51715, 51714, 51713, 51712, },
	[884] = { 51766, 51765, 51764, 51763, 51762, },
	[885] = { 51732, 51733, 51734, 51735, 51736, },
	[886] = { 51741, 51740, 51739, 51738, 51737, },
	[887] = { 51696, 51695, 51694, 51693, 51692, },
	[888] = { 51706, 51705, 51704, 51703, 51702, },
	[889] = { 51701, 51700, 51699, 51698, 51697, },
	[890] = { 51746, 51745, 51744, 51743, 51742, },
	[891] = { 51711, 51710, 51709, 51708, 51707, },
	[892] = { 51747, 51748, 51749, 51750, 51751, },
	[893] = { 51757, 51758, 51759, 51760, 51761, },
	[894] = { 51752, 51753, 51754, 51755, 51756, },
	[895] = { 51771, 51770, 51769, 51768, 51767, },
	[896] = { 51776, 51775, 51774, 51773, 51772, },
	[897] = { 51686, 51685, 51684, 51683, 51682, },
	[898] = { 51691, 51690, 51689, 51688, 51687, },
	[899] = { 51726, 51725, 51724, 51723, 51722, },
	[900] = { 51721, 51720, 51719, 51718, 51717, },
	[901] = { 51731, 51730, 51729, 51728, 51727, },
};
DT.ItemSetThreshold = {
	[1] = { 2, 3, 4, 5, },
	[41] = { 2, },
	[65] = { 2, },
	[81] = { 2, 3, 3, 4, 5, 5, },
	[121] = { 2, 3, 4, 5, },
	[122] = { 2, 3, 4, 5, },
	[123] = { 2, 3, 4, 5, },
	[124] = { 2, 3, 4, 5, },
	[141] = { 3, },
	[142] = { 2, 3, 4, },
	[143] = { 2, },
	[144] = { 2, },
	[161] = { 2, 3, 4, 5, },
	[162] = { 2, 3, 4, 5, },
	[163] = { 2, 3, 4, 5, 6, },
	[181] = { 2, 4, 6, 8, },
	[182] = { 2, 4, 6, 8, },
	[183] = { 2, 4, 6, 8, },
	[184] = { 2, 4, 6, 8, },
	[185] = { 2, 4, 4, 6, 8, },
	[186] = { 2, 4, 6, 8, },
	[187] = { 2, 4, 6, 8, },
	[188] = { 2, 4, 6, 8, },
	[189] = { 2, 4, 6, 8, },
	[201] = { 3, 5, 8, },
	[202] = { 3, 5, 8, },
	[203] = { 3, 5, 8, },
	[204] = { 3, 5, 8, },
	[205] = { 3, 5, 8, },
	[206] = { 3, 5, 8, },
	[207] = { 3, 5, 8, },
	[208] = { 3, 5, 8, },
	[209] = { 3, 5, 8, },
	[210] = { 3, 5, 8, },
	[211] = { 3, 5, 8, },
	[212] = { 3, 5, 8, },
	[213] = { 3, 5, 8, },
	[214] = { 3, 5, 8, },
	[215] = { 3, 5, 8, },
	[216] = { 3, 5, 8, },
	[217] = { 3, 5, 8, },
	[218] = { 3, 5, 8, },
	[221] = { 6, },
	[241] = { 2, },
	[261] = { 2, },
	[281] = { 2, 4, 6, },
	[282] = { 2, 4, 6, },
	[301] = { 2, 4, 6, },
	[321] = { 2, 4, 6, },
	[341] = { 2, 4, 6, },
	[342] = { 2, 4, 6, },
	[343] = { 2, 4, 6, },
	[344] = { 2, 4, 6, },
	[345] = { 2, 4, 6, },
	[346] = { 2, 4, 6, },
	[347] = { 2, 4, 6, },
	[348] = { 2, 4, 6, },
	[361] = { 2, 4, 6, },
	[362] = { 2, 4, 6, },
	[381] = { 2, 4, 6, },
	[382] = { 2, 4, 6, },
	[383] = { 2, 3, 6, },
	[384] = { 2, 3, 6, },
	[386] = { 2, 3, 6, },
	[387] = { 2, 3, 6, },
	[388] = { 2, 3, 6, },
	[389] = { 2, 3, 6, },
	[390] = { 2, 3, 6, },
	[391] = { 2, 3, 6, },
	[392] = { 2, 3, 6, },
	[393] = { 2, 3, 6, },
	[394] = { 2, 3, 6, },
	[395] = { 2, 3, 6, },
	[396] = { 2, 3, 6, },
	[397] = { 2, 3, 6, },
	[398] = { 2, 3, 6, },
	[401] = { 2, 2, 4, 6, },
	[402] = { 2, 3, 6, },
	[421] = { 3, },
	[441] = { 3, },
	[442] = { 2, 2, },
	[443] = { 3, },
	[444] = { 3, },
	[461] = { 2, },
	[462] = { 2, 2, },
	[463] = { 2, },
	[464] = { 2, },
	[465] = { 2, },
	[466] = { 2, },
	[467] = { 2, 3, },
	[468] = { 2, 3, },
	[469] = { 2, 3, },
	[470] = { 2, 3, },
	[471] = { 2, 3, },
	[472] = { 2, 3, },
	[473] = { 2, 3, },
	[474] = { 2, 3, 5, },
	[475] = { 2, 3, 5, },
	[476] = { 2, 3, 5, },
	[477] = { 2, 3, 5, },
	[478] = { 2, 3, 5, },
	[479] = { 2, 3, 5, },
	[480] = { 2, 3, 5, },
	[481] = { 2, 3, 5, },
	[482] = { 2, 3, 5, },
	[483] = { 2, 3, },
	[484] = { 2, 3, },
	[485] = { 2, 3, },
	[486] = { 2, 3, },
	[487] = { 2, 3, },
	[488] = { 2, 3, },
	[489] = { 2, 3, 4, },
	[490] = { 2, 3, },
	[491] = { 2, 3, },
	[492] = { 3, },
	[493] = { 3, 3, 5, },
	[494] = { 3, },
	[495] = { 3, },
	[496] = { 3, 5, },
	[497] = { 3, 5, },
	[498] = { 3, },
	[499] = { 3, 5, },
	[500] = { 3, },
	[501] = { 3, 5, },
	[502] = { 3, },
	[503] = { 3, 5, },
	[504] = { 3, },
	[505] = { 3, 5, },
	[506] = { 3, },
	[507] = { 3, 5, },
	[508] = { 3, },
	[509] = { 3, 5, },
	[510] = { 3, },
	[511] = { 2, 4, 6, 8, },
	[512] = { 2, 4, 6, 8, },
	[513] = { 2, 4, 6, 6, 8, },
	[514] = { 2, 4, 6, 8, },
	[515] = { 2, 4, 6, 8, },
	[516] = { 2, 4, 6, 8, },
	[517] = { 2, 4, 6, 8, },
	[518] = { 2, 4, 6, 8, },
	[519] = { 2, 4, 6, 8, },
	[520] = { 4, 8, },
	[521] = { 2, 4, 6, 8, },
	[522] = { 2, 4, 6, },
	[523] = { 2, 4, 6, 8, },
	[524] = { 2, 4, 6, 8, },
	[525] = { 2, 4, 6, 8, },
	[526] = { 2, 4, 6, 8, },
	[527] = { 2, 4, 6, 8, },
	[528] = { 2, 4, 6, 8, },
	[529] = { 2, 4, 6, 8, },
	[530] = { 2, 4, 6, 8, },
	[533] = { 3, },
	[534] = { 3, },
	[535] = { 3, },
	[536] = { 3, },
	[537] = { 2, 4, 6, },
	[538] = { 2, 4, 6, },
	[539] = { 2, 4, 6, },
	[540] = { 2, 4, 6, },
	[541] = { 2, 4, 6, },
	[542] = { 2, 4, 6, },
	[543] = { 2, 4, 6, },
	[544] = { 2, 4, 6, },
	[545] = { 2, 4, 6, },
	[546] = { 2, 4, 6, },
	[547] = { 2, 4, 6, },
	[548] = { 2, 4, 6, },
	[549] = { 2, 4, 6, },
	[550] = { 2, 4, 6, },
	[551] = { 2, 4, 6, },
	[552] = { 3, },
	[553] = { 3, },
	[554] = { 3, },
	[555] = { 2, 4, },
	[556] = { 3, },
	[557] = { 3, },
	[558] = { 3, },
	[559] = { 2, },
	[560] = { 2, 4, },
	[561] = { 2, 4, },
	[562] = { 3, },
	[563] = { 3, },
	[564] = { 3, },
	[565] = { 3, },
	[566] = { 2, },
	[567] = { 2, 4, },
	[568] = { 2, 4, },
	[569] = { 3, },
	[570] = { 2, },
	[571] = { 2, },
	[572] = { 2, },
	[573] = { 3, },
	[574] = { 3, },
	[575] = { 3, },
	[576] = { 3, },
	[577] = { 2, 4, },
	[578] = { 2, 4, },
	[579] = { 2, 4, },
	[580] = { 2, 4, },
	[581] = { 2, 4, },
	[582] = { 2, 4, },
	[583] = { 2, 4, },
	[584] = { 2, 4, },
	[585] = { 2, 4, },
	[586] = { 2, 4, },
	[587] = { 2, 4, },
	[588] = { 2, 4, },
	[589] = { 2, 4, },
	[590] = { 2, 4, },
	[591] = { 2, 4, },
	[592] = { 2, 4, },
	[593] = { 2, 4, },
	[594] = { 2, 4, },
	[595] = { 2, 4, },
	[596] = { 2, 4, },
	[597] = { 2, 4, },
	[598] = { 2, 4, },
	[599] = { 2, 4, },
	[600] = { 2, 4, },
	[601] = { 2, 4, },
	[602] = { 2, 4, },
	[603] = { 2, 4, },
	[604] = { 2, 4, },
	[605] = { 2, 4, },
	[606] = { 2, 4, },
	[607] = { 2, 4, },
	[608] = { 2, 4, },
	[609] = { 2, 4, },
	[610] = { 2, 4, },
	[611] = { 2, 4, },
	[612] = { 2, 4, },
	[613] = { 2, 4, },
	[614] = { 2, 4, },
	[615] = { 2, 4, },
	[616] = { 3, },
	[617] = { 3, },
	[618] = { 3, },
	[619] = { 3, },
	[620] = { 2, 4, },
	[621] = { 2, 4, },
	[622] = { 2, 4, },
	[623] = { 2, 4, },
	[624] = { 2, 4, },
	[625] = { 2, 4, },
	[626] = { 2, 4, },
	[627] = { 2, 4, },
	[628] = { 2, 4, },
	[629] = { 2, 4, },
	[630] = { 2, 4, },
	[631] = { 2, 4, },
	[632] = { 2, 4, },
	[633] = { 2, 4, },
	[634] = { 2, 4, },
	[635] = { 2, 4, },
	[636] = { 2, 4, },
	[637] = { 2, 4, },
	[638] = { 2, 4, },
	[639] = { 2, 4, },
	[640] = { 2, 2, 4, 4, },
	[641] = { 2, 4, },
	[642] = { 2, 4, },
	[643] = { 2, 4, },
	[644] = { 2, 4, },
	[645] = { 2, 2, 4, },
	[646] = { 2, 4, },
	[647] = { 2, 4, },
	[648] = { 2, 4, },
	[649] = { 2, 4, },
	[650] = { 2, 4, },
	[651] = { 2, 4, },
	[652] = { 2, 4, },
	[653] = { 2, 4, },
	[654] = { 2, 4, },
	[655] = { 2, 4, },
	[656] = { 2, 4, },
	[657] = { 2, 4, },
	[658] = { 2, 4, },
	[659] = { 2, 4, },
	[660] = { 2, 4, },
	[661] = { 2, 4, },
	[662] = { 2, 4, },
	[663] = { 2, 4, },
	[664] = { 2, 4, },
	[665] = { 2, 4, },
	[666] = { 2, 4, },
	[667] = { 2, },
	[668] = { 2, 4, },
	[669] = { 2, 4, },
	[670] = { 2, 4, },
	[671] = { 2, 4, },
	[672] = { 2, 4, },
	[673] = { 2, 4, },
	[674] = { 2, 4, },
	[675] = { 2, 4, },
	[676] = { 2, 4, },
	[677] = { 2, 4, },
	[678] = { 2, 4, },
	[679] = { 2, 4, },
	[680] = { 2, 4, },
	[681] = { 2, 4, },
	[682] = { 2, 4, },
	[683] = { 2, 4, },
	[684] = { 2, 4, },
	[685] = { 2, 4, },
	[686] = { 2, 4, },
	[687] = { 2, 4, },
	[688] = { 2, 4, },
	[689] = { 2, 4, },
	[690] = { 2, 4, },
	[691] = { 2, 4, },
	[692] = { 2, 4, },
	[693] = { 2, 4, },
	[694] = { 2, 4, },
	[695] = { 2, 4, },
	[696] = { 2, 4, },
	[697] = { 2, 3, 6, },
	[698] = { 2, 3, 6, },
	[699] = { 2, 2, },
	[700] = { 2, 4, },
	[701] = { 2, 4, },
	[702] = { 2, 4, },
	[703] = { 2, 4, },
	[704] = { 2, 4, },
	[705] = { 2, 4, },
	[706] = { 2, 4, },
	[707] = { 2, 4, },
	[708] = { 2, 4, },
	[709] = { 2, 4, },
	[710] = { 2, 4, },
	[711] = { 2, 4, },
	[712] = { 2, 4, },
	[713] = { 2, 4, },
	[714] = { 2, 4, },
	[715] = { 2, 4, },
	[716] = { 2, 4, },
	[717] = { 2, 3, 6, },
	[718] = { 2, 4, 6, },
	[719] = { 2, },
	[720] = { 2, 4, },
	[721] = { 2, 4, },
	[722] = { 2, 4, },
	[723] = { 2, 4, },
	[724] = { 2, 4, },
	[725] = { 2, 4, },
	[726] = { 2, 4, },
	[727] = { 2, 4, },
	[728] = { 2, 4, },
	[729] = { 2, 4, },
	[730] = { 2, 4, },
	[731] = { 2, 4, },
	[732] = { 2, 4, },
	[733] = { 2, 4, },
	[734] = { 2, 4, },
	[735] = { 2, 4, },
	[736] = { 2, 4, },
	[737] = { 2, },
	[738] = { 2, 4, },
	[739] = { 2, 4, },
	[740] = { 2, 4, },
	[741] = { 2, 4, },
	[742] = { 2, 4, },
	[743] = { 2, 4, },
	[744] = { 2, 4, },
	[745] = { 2, 4, },
	[746] = { 2, 4, },
	[747] = { 2, 4, },
	[748] = { 2, 4, },
	[749] = { 2, 4, },
	[750] = { 2, 4, },
	[751] = { 2, 4, },
	[752] = { 2, 4, },
	[754] = { 2, 4, },
	[755] = { 2, 4, },
	[756] = { 2, 4, },
	[757] = { 3, },
	[759] = { 2, },
	[760] = { 2, 4, },
	[761] = { 3, },
	[762] = { 3, },
	[763] = { 2, 4, },
	[764] = { 2, 4, },
	[765] = { 2, 2, 4, 4, },
	[766] = { 2, 2, 4, 4, },
	[767] = { 2, 2, 4, 4, },
	[768] = { 2, 2, 4, 4, },
	[769] = { 2, 2, 4, 4, },
	[770] = { 2, 2, 4, 4, },
	[771] = { 2, 2, 4, 4, },
	[772] = { 2, 2, 4, 4, },
	[773] = { 2, 2, 4, 4, },
	[774] = { 2, 2, 4, 4, },
	[775] = { 2, 2, 4, 4, },
	[776] = { 2, 2, 4, 4, },
	[777] = { 2, 2, 4, 4, },
	[778] = { 2, 2, 4, 4, },
	[779] = { 2, 2, 4, 4, },
	[780] = { 2, 2, 4, 4, },
	[781] = { 2, 3, 4, },
	[782] = { 2, 3, 4, },
	[783] = { 2, 3, 4, },
	[784] = { 2, 3, 4, },
	[785] = { 3, },
	[787] = { 2, 4, },
	[788] = { 2, 4, },
	[789] = { 2, 4, },
	[790] = { 2, 4, },
	[791] = { 2, 4, },
	[792] = { 2, 4, },
	[793] = { 2, 4, },
	[794] = { 2, 4, },
	[795] = { 2, 4, },
	[796] = { 2, 4, },
	[797] = { 2, 4, },
	[798] = { 2, 4, },
	[799] = { 2, 4, },
	[800] = { 2, 4, },
	[801] = { 2, 4, },
	[802] = { 2, 4, },
	[803] = { 2, 4, },
	[804] = { 2, 4, },
	[805] = { 2, 4, },
	[812] = { 2, },
	[813] = { 4, 6, },
	[814] = { 4, 6, },
	[815] = { 4, 6, },
	[816] = { 4, 6, },
	[817] = { 4, 6, },
	[818] = { 4, 6, },
	[819] = { 4, 6, },
	[820] = { 2, 4, },
	[821] = { 2, 4, },
	[822] = { 2, 4, },
	[823] = { 2, 4, },
	[824] = { 2, 4, },
	[825] = { 2, 4, },
	[826] = { 2, 4, },
	[827] = { 2, 4, },
	[828] = { 2, 4, },
	[829] = { 2, 4, },
	[830] = { 2, 4, },
	[831] = { 2, 4, },
	[832] = { 2, 4, },
	[833] = { 2, 4, },
	[834] = { 2, 4, },
	[835] = { 2, 4, },
	[836] = { 2, 4, },
	[837] = { 2, 4, },
	[838] = { 2, 4, },
	[843] = { 2, 4, },
	[844] = { 2, 4, },
	[845] = { 2, 4, },
	[846] = { 2, 4, },
	[847] = { 2, 4, },
	[848] = { 2, 4, },
	[849] = { 2, 4, },
	[850] = { 2, 4, },
	[851] = { 2, 4, },
	[852] = { 2, 4, },
	[853] = { 2, 4, },
	[854] = { 2, 4, },
	[855] = { 2, 4, },
	[856] = { 2, 4, },
	[857] = { 2, 4, },
	[858] = { 2, 4, },
	[859] = { 2, 4, },
	[860] = { 2, 4, },
	[861] = { 2, 4, },
	[862] = { 2, 4, },
	[863] = { 2, 4, },
	[864] = { 2, 4, },
	[865] = { 2, 4, },
	[866] = { 2, 4, },
	[867] = { 2, 4, },
	[868] = { 2, 4, },
	[869] = { 2, 4, },
	[870] = { 2, 4, },
	[871] = { 2, 4, },
	[872] = { 2, 4, },
	[873] = { 2, 4, },
	[874] = { 2, 4, },
	[875] = { 2, 4, },
	[876] = { 2, 4, },
	[877] = { 2, 4, },
	[878] = { 2, 4, },
	[879] = { 2, 4, },
	[880] = { 2, 4, },
	[881] = { 2, 2, },
	[882] = { 2, 2, },
	[883] = { 2, 4, },
	[884] = { 2, 4, },
	[885] = { 2, 4, },
	[886] = { 2, 4, },
	[887] = { 2, 4, },
	[888] = { 2, 4, },
	[889] = { 2, 4, },
	[890] = { 2, 4, },
	[891] = { 2, 4, },
	[892] = { 2, 4, },
	[893] = { 2, 4, },
	[894] = { 2, 4, },
	[895] = { 2, 4, },
	[896] = { 2, 4, },
	[897] = { 2, 4, },
	[898] = { 2, 4, },
	[899] = { 2, 4, },
	[900] = { 2, 4, },
	[901] = { 2, 4, },
};
local GetItemInfoInstant = GetItemInfoInstant;
for setID, set in next, DT.ItemSet do
	local h = {  };
	for i, id in next, set do
		local _, _, _, loc, icon = GetItemInfoInstant(id);
		if h[loc] then
			h = false;
			break;
		end
		h[loc] = i;
	end
	if h then
		for loc, i in next, h do
			set[loc] = i;
		end
	end
end
