-- Modal.lua
-- @Author : Dencer (tdaddon@163.com)
-- @Link   : https://dengsir.github.io
-- @Date   : 5/18/2020, 1:04:14 AM
--
---@type ns
local ns = select(2, ...)

local UnitFactionGroup = UnitFactionGroup

local Inspect = ns.Inspect

local factionLogoTextures = {
    Alliance = [[Interface\Timer\Alliance-Logo]],
    Horde = [[Interface\Timer\Horde-Logo]],
    Neutral = [[Interface\Timer\Panda-Logo]],
}

---@class UI.ModelFrame: EventHandler, Object, Frame
local ModelFrame = ns.Addon:NewClass('UI.ModelFrame', 'Frame')

function ModelFrame:Constructor()
    self.Modal = InspectModelFrame
    self.Faction = InspectFaction

    InspectModelFrameBackgroundTopLeft:Hide()
    InspectModelFrameBackgroundTopRight:Hide()
    InspectModelFrameBackgroundBotLeft:Hide()
    InspectModelFrameBackgroundBotRight:Hide()

    for _, region in ipairs({self.Modal:GetRegions()}) do
        region:SetParent(self)
    end
    self.Faction:SetPoint('CENTER')

    self.Modal:SetParent(self)
    self.Faction:SetParent(self)
    self.RaceBackground = InspectModelFrameBackgroundOverlay
    self.RaceBackground:SetAlpha(1)

    self:SetScript('OnShow', self.OnShow)
end

function ModelFrame:OnShow()
    self:Event('UNIT_MODEL_CHANGED', 'UpdateModal')
    self:Event('TDINSPECT_TARGET_CHANGED', 'Update')
    self:Update()
end

function ModelFrame:OnHide()
    self:UnAllEvents()
    self.modelName = nil
end

function ModelFrame:Update()
    self:UpdateModal()
    self:UpdateRace()
end

function ModelFrame:UpdateModal()
    local unit = Inspect.unit
    if unit then
        self.Modal:Show()

        if self.Modal:SetUnit(unit) then
            self.modelName = ns.UnitName(unit)
            self.Modal:Show()
            self.Faction:Hide()
            return
        end
    end

    if self.modelName == Inspect.unitName then
        return
    end

    self.modelName = nil
    self.Modal:Hide()
    self.Faction:SetTexture(factionLogoTextures[Inspect:GetUnitFactionGroup()])
    self.Faction:Show()
end

function ModelFrame:UpdateRace()
    local raceFileName = Inspect:GetUnitRaceFileName()

    if raceFileName then
        if raceFileName == 'Scourge' then
            raceFileName = 'Undead'
        end
        self.RaceBackground:SetAtlas('transmog-background-race-' .. raceFileName)
    else
        self.RaceBackground:SetAtlas(UnitFactionGroup('player') == 'Alliance' and 'transmog-background-race-draenei' or
                                         'transmog-background-race-bloodelf')
    end
end
